/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.proxy;

import com.denfop.IUItem;
import com.denfop.api.IFluidModelProvider;
import com.denfop.api.IModelRegister;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.FluidName;
import com.denfop.entity.EntityNuclearBombPrimed;
import com.denfop.events.ElectricItemTooltipHandler;
import com.denfop.events.TickHandler;
import com.denfop.gui.GuiColorPicker;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.book.core.CoreBook;
import com.denfop.proxy.CommonProxy;
import com.denfop.render.advoilrefiner.TileEntityAdvOilRefinerRender;
import com.denfop.render.anvil.RenderItemAnvil;
import com.denfop.render.base.IReloadableModel;
import com.denfop.render.base.IUModelLoader;
import com.denfop.render.base.RenderCoreProcess;
import com.denfop.render.entity.RenderNuclearBombPrimed;
import com.denfop.render.multiblock.TileEntityMultiBlockRender;
import com.denfop.render.oilquarry.TileEntityQuarryOilRender;
import com.denfop.render.oilrefiner.TileEntityOilRefinerRender;
import com.denfop.render.panel.TileEntityMiniPanelRender;
import com.denfop.render.panel.TileEntitySolarPanelRender;
import com.denfop.render.sintezator.TileEntitySintezatorRender;
import com.denfop.render.streak.EventSpectralSuitEffect;
import com.denfop.render.tank.TileEntityTankRender;
import com.denfop.render.tile.TileEntityAdminPanelRender;
import com.denfop.render.transport.ModelCable;
import com.denfop.render.transport.TileEntityCableRender;
import com.denfop.render.water.WaterGeneratorRenderer;
import com.denfop.render.windgenerator.KineticGeneratorRenderer;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileAdminSolarPanel;
import com.denfop.tiles.base.TileDoubleMolecular;
import com.denfop.tiles.base.TileEntityAnvil;
import com.denfop.tiles.base.TileEntityLiquedTank;
import com.denfop.tiles.base.TileMolecularTransformer;
import com.denfop.tiles.base.TileQuarryVein;
import com.denfop.tiles.base.TileSintezator;
import com.denfop.tiles.mechanism.TileAdvOilRefiner;
import com.denfop.tiles.mechanism.TileOilRefiner;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.mechanism.water.TileBaseWaterGenerator;
import com.denfop.tiles.mechanism.wind.TileWindGenerator;
import com.denfop.tiles.mechanism.worlcollector.TileCrystallize;
import com.denfop.tiles.panels.entity.TileEntityMiniPanels;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.CableType;
import com.denfop.tiles.transport.types.CoolType;
import com.denfop.tiles.transport.types.ExpType;
import com.denfop.tiles.transport.types.HeatColdType;
import com.denfop.tiles.transport.types.HeatType;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.tiles.transport.types.ItemType;
import com.denfop.tiles.transport.types.QEType;
import com.denfop.tiles.transport.types.RadTypes;
import com.denfop.tiles.transport.types.SEType;
import com.denfop.tiles.transport.types.UniversalType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
extends CommonProxy {
    public static final ArrayList<IModelRegister> modelList = new ArrayList();
    public static final ArrayList<ICableItem> cableItemTextureAspire = new ArrayList();
    private final Minecraft mc = Minecraft.func_71410_x();
    private GuiScreen gui;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        for (IModelRegister register : modelList) {
            register.registerModels();
        }
        new TickHandler();
        OBJLoader.INSTANCE.addDomain("industrialupgrade");
        for (FluidName name : FluidName.values) {
            Fluid provider;
            if (!name.hasInstance() || !((provider = name.getInstance()) instanceof IFluidModelProvider)) continue;
            ((IFluidModelProvider)provider).registerModels(name);
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystallize.class, new RenderCoreProcess());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMolecularTransformer.class, new RenderCoreProcess());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMultiBlockBase.class, new TileEntityMultiBlockRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileDoubleMolecular.class, new RenderCoreProcess());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMiniPanels.class, new TileEntityMiniPanelRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAnvil.class, (TileEntitySpecialRenderer)new RenderItemAnvil());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSintezator.class, (TileEntitySpecialRenderer)new TileEntitySintezatorRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileQuarryVein.class, (TileEntitySpecialRenderer)new TileEntityQuarryOilRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAdminSolarPanel.class, (TileEntitySpecialRenderer)new TileEntityAdminPanelRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileOilRefiner.class, (TileEntitySpecialRenderer)new TileEntityOilRefinerRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAdvOilRefiner.class, (TileEntitySpecialRenderer)new TileEntityAdvOilRefinerRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLiquedTank.class, (TileEntitySpecialRenderer)new TileEntityTankRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWindGenerator.class, (TileEntitySpecialRenderer)new KineticGeneratorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBaseWaterGenerator.class, (TileEntitySpecialRenderer)new WaterGeneratorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSolarPanel.class, new TileEntitySolarPanelRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMultiCable.class, new TileEntityCableRender());
        EnumMultiMachine.write();
        RenderingRegistry.registerEntityRenderingHandler(EntityNuclearBombPrimed.class, RenderNuclearBombPrimed::new);
        IUModelLoader loader = new IUModelLoader();
        loader.register("models/block/wiring/cable_iu", (IReloadableModel)new ModelCable(CableType.values()));
        loader.register("models/block/wiring/cool/cool_pipes", (IReloadableModel)new ModelCable(CoolType.values()));
        loader.register("models/block/wiring/universal_cable", (IReloadableModel)new ModelCable(UniversalType.values()));
        loader.register("models/block/wiring/scable/scable_scable", (IReloadableModel)new ModelCable(SEType.values()));
        loader.register("models/block/wiring/qcable/qcable_qcable", (IReloadableModel)new ModelCable(QEType.values()));
        loader.register("models/block/wiring/pipes/pipes_pipes", (IReloadableModel)new ModelCable(HeatType.values()));
        loader.register("models/block/wiring/item_pipes/itemcable_pipes", (IReloadableModel)new ModelCable(ItemType.values()));
        loader.register("models/block/wiring/heatcold/heatcool_pipes", (IReloadableModel)new ModelCable(HeatColdType.values()));
        loader.register("models/block/wiring/radcable/rad_cable_radcable", (IReloadableModel)new ModelCable(RadTypes.values()));
        loader.register("models/block/wiring/expcable/expcable_expcable", (IReloadableModel)new ModelCable(ExpType.values()));
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
    }

    @Override
    public void requestTick(boolean simulating, Runnable runnable) {
        if (simulating) {
            super.requestTick(simulating, runnable);
        } else {
            this.mc.func_152344_a(runnable);
        }
    }

    @Override
    public EntityPlayer getPlayerInstance() {
        return this.mc.field_71439_g;
    }

    @Override
    public World getWorld(int dimId) {
        if (this.isSimulating()) {
            return super.getWorld(dimId);
        }
        WorldClient world = this.mc.field_71441_e;
        return world.field_73011_w.getDimension() == dimId ? world : null;
    }

    @Override
    public World getPlayerWorld() {
        return this.mc.field_71441_e;
    }

    @Override
    public void messagePlayer(EntityPlayer player, String message, Object ... args) {
        if (args.length > 0) {
            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation(message, (Object[])this.getMessageComponents(args)));
        } else {
            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(message));
        }
    }

    @Override
    public void playSoundSp(String sound, float f, float g) {
        this.getPlayerInstance().func_184185_a(EnumSound.getSondFromString(sound), f, g);
    }

    @Override
    public boolean isRendering() {
        return !this.isSimulating();
    }

    public GuiScreen getGui() {
        return this.gui;
    }

    @Override
    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ItemStack stack;
        if (ID == 1 && (stack = player.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof IItemStackInventory) {
            IItemStackInventory inventory = (IItemStackInventory)stack.func_77973_b();
            this.gui = inventory.getInventory(player, stack).getGui(player, false);
            return this.gui;
        }
        if (ID == 2 && (stack = (ItemStack)player.field_71071_by.field_70460_b.get(1)).func_77973_b() instanceof IItemStackInventory) {
            IItemStackInventory inventory = (IItemStackInventory)stack.func_77973_b();
            this.gui = inventory.getInventory(player, stack).getGui(player, false);
            return this.gui;
        }
        if (ID == 4 && !((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b() == IUItem.spectral_chestplate) {
            return new GuiColorPicker(player);
        }
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof IAdvInventory) {
            return ((IAdvInventory)tile).getGui(player, false);
        }
        return null;
    }

    @Override
    public void registerRecipe() {
        super.registerRecipe();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new EventSpectralSuitEffect());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        new ElectricItemTooltipHandler();
        CoreBook.init();
    }

    @Override
    public boolean addIModelRegister(IModelRegister modelRegister) {
        return modelList.add(modelRegister);
    }

    @Override
    public boolean addTextureAspire(ICableItem modelRegister) {
        return cableItemTextureAspire.add(modelRegister);
    }

    @Override
    public List<ICableItem> getTextureAtlas() {
        return cableItemTextureAspire;
    }
}

