/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.world.IWorldTickCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WorldData {
    public static Map<Integer, WorldData> idxClient = FMLCommonHandler.instance().getSide().isClient() ? new HashMap() : null;
    public static Map<Integer, WorldData> idxServer = new HashMap<Integer, WorldData>();
    public final Queue<IWorldTickCallback> singleUpdates = new LinkedList<IWorldTickCallback>();
    public final Map<TileEntityBlock, Map<EntityPlayer, CustomPacketBuffer>> mapUpdateContainer = new HashMap<TileEntityBlock, Map<EntityPlayer, CustomPacketBuffer>>();
    public final List<TileEntityBlock> listUpdateTile = new ArrayList<TileEntityBlock>();
    public final Map<TileEntityBlock, List<CustomPacketBuffer>> mapUpdateField = new HashMap<TileEntityBlock, List<CustomPacketBuffer>>();
    public final Map<BlockPos, TileEntityBlock> mapUpdateOvertimeField = new HashMap<BlockPos, TileEntityBlock>();
    private final World world;

    public WorldData(World world) {
        this.world = world;
    }

    public static WorldData get(World world) {
        return WorldData.get(world, true);
    }

    public static WorldData get(World world, boolean load) {
        if (world == null) {
            return null;
        }
        Map<Integer, WorldData> index = WorldData.getIndex(!world.field_72995_K);
        WorldData ret = index.get(world.field_73011_w.getDimension());
        if (ret == null && load) {
            ret = new WorldData(world);
            WorldData prev = index.putIfAbsent(world.field_73011_w.getDimension(), ret);
            if (prev != null) {
                ret = prev;
            }
        }
        return ret;
    }

    public static void onWorldUnload(World world) {
        WorldData.getIndex(!world.field_72995_K).remove(world.field_73011_w.getDimension());
    }

    private static Map<Integer, WorldData> getIndex(boolean simulating) {
        return simulating ? idxServer : idxClient;
    }

    public World getWorld() {
        return this.world;
    }
}

