/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.transport;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.items.block.ISubItem;
import com.denfop.items.block.ItemBlockTileEntity;
import com.denfop.register.Register;
import com.denfop.tiles.transport.tiles.TileEntitySCable;
import com.denfop.tiles.transport.types.SEType;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSCable
extends Item
implements ISubItem<SEType>,
IModelRegister {
    public static final List<ItemStack> variants = new ArrayList<ItemStack>();
    protected static final String NAME = "se_iu_item";
    String[] name = new String[]{"scable"};

    public ItemSCable() {
        SEType[] var1;
        this.func_77627_a(true);
        for (SEType type : var1 = SEType.values) {
            for (int insulation = 0; insulation <= type.maxInsulation; ++insulation) {
                variants.add(this.getCable(type));
            }
        }
        this.func_77637_a(IUCore.ItemTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(ItemStack stack) {
        String loc = "industrialupgrade:scable/" + ItemSCable.getName(stack);
        return new ModelResourceLocation(loc, null);
    }

    private static SEType getCableType(ItemStack stack) {
        int type = stack.func_77952_i();
        return type < SEType.values.length ? SEType.values[type] : SEType.scable;
    }

    private static int getInsulation(ItemStack stack) {
        SEType type = ItemSCable.getCableType(stack);
        return Math.min(0, type.maxInsulation);
    }

    private static String getName(ItemStack stack) {
        SEType type = ItemSCable.getCableType(stack);
        return type.func_176610_l();
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, ItemSCable::getModelLocation);
        for (ItemStack stack : variants) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)stack.func_77952_i(), (ModelResourceLocation)ItemSCable.getModelLocation(stack));
        }
        for (ItemStack stack : variants) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemSCable.getModelLocation(stack)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:se_iu_item/" + SEType.values[meta].func_176610_l(), null));
    }

    @Override
    public ItemStack getItemStack(SEType type) {
        return this.getCable(type);
    }

    @Override
    public ItemStack getItemStack(String variant) {
        int pos = 0;
        SEType type = null;
        int insulation = 0;
        while (pos < variant.length()) {
            int sepPos;
            int nextPos = variant.indexOf(44, pos);
            if (nextPos == -1) {
                nextPos = variant.length();
            }
            if ((sepPos = variant.indexOf(58, pos)) == -1 || sepPos >= nextPos) {
                return null;
            }
            String key = variant.substring(pos, sepPos);
            String value = variant.substring(sepPos + 1, nextPos);
            if (key.equals("type")) {
                type = SEType.get(value);
            } else if (key.equals("insulation")) {
                try {
                    insulation = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            pos = nextPos + 1;
        }
        if (type == null) {
            return null;
        }
        if (insulation >= 0 && insulation <= type.maxInsulation) {
            return this.getCable(type);
        }
        return null;
    }

    public String getVariant(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null stack");
        }
        if (stack.func_77973_b() != this) {
            throw new IllegalArgumentException("The stack " + stack + " doesn't match " + this);
        }
        SEType type = ItemSCable.getCableType(stack);
        int insulation = ItemSCable.getInsulation(stack);
        return "type:" + type.func_176610_l() + ",insulation:" + insulation;
    }

    public ItemStack getCable(SEType type) {
        return new ItemStack((Item)this, 1, type.getId());
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta >= this.name.length) {
            meta = 0;
        }
        return "iu." + this.name[meta];
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = ModUtils.get(player, hand);
        IBlockState oldState = world.func_180495_p(pos);
        Block oldBlock = oldState.func_177230_c();
        if (!oldBlock.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        BlockTileEntity newBlock = IUItem.invalid;
        if (!ModUtils.isEmpty(stack) && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)newBlock, pos, false, side, (Entity)player) && newBlock.canReplace(world, pos, side, IUItem.invalid.getItemStack(MultiTileBlock.invalid))) {
            newBlock.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
            SEType type = ItemSCable.getCableType(stack);
            int insulation = ItemSCable.getInsulation(stack);
            TileEntitySCable te = TileEntitySCable.delegate(type);
            if (ItemBlockTileEntity.placeTeBlock(stack, (EntityLivingBase)player, world, pos, side, te)) {
                SoundType soundtype = newBlock.getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                player.func_184586_b(hand).func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(tab)) {
            ArrayList<ItemStack> variants = new ArrayList<ItemStack>(ItemSCable.variants);
            itemList.addAll(variants);
        }
    }

    public Set<SEType> getAllTypes() {
        return EnumSet.allOf(SEType.class);
    }

    public Set<ItemStack> getAllStacks() {
        return new HashSet<ItemStack>(variants);
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

