/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy.instruments;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrade.IUpgradeWithBlackList;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemBlackListLoad;
import com.denfop.audio.EnumSound;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.energy.ItemStackUpgradeItem;
import com.denfop.items.energy.instruments.EnumOperations;
import com.denfop.items.energy.instruments.EnumTypeInstruments;
import com.denfop.items.energy.instruments.EnumVarietyInstruments;
import com.denfop.proxy.CommonProxy;
import com.denfop.register.Register;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.denfop.utils.RetraceDiggingUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemEnergyInstruments
extends ItemTool
implements IEnergyItem,
IItemStackInventory,
IUpgradeWithBlackList,
IModelRegister {
    private final String name;
    private final int transferLimit;
    private final int maxCharge;
    private final int tier;
    private final int normalPower;
    private final int bigHolePower;
    private final int energyPerOperation;
    private final int energyBigHolePowerOperation;
    private final int ultraLowPower1;
    private final int ultraLowPower;
    private final Set<IBlockState> mineableBlocks;
    private final Set<Material> materials;
    private final int energyPerbigHolePowerOperation;
    private final int energyPerultraLowPowerOperation;
    private final List<EnumOperations> operations;
    private final List<Item> item_tools;
    private final String name_type;
    private final float fuel_balance = 10.0f;
    Set<String> toolType;

    public ItemEnergyInstruments(EnumTypeInstruments type, EnumVarietyInstruments variety, String name) {
        super(0.0f, 0.0f + Item.ToolMaterial.DIAMOND.func_78000_c(), Item.ToolMaterial.DIAMOND, new HashSet());
        this.name = name;
        this.name_type = type.getType_name() == null ? type.name().toLowerCase() : type.getType_name();
        this.transferLimit = variety.getEnergy_transfer();
        this.maxCharge = variety.getCapacity();
        this.tier = variety.getTier();
        this.normalPower = variety.getNormal_power();
        this.field_77864_a = this.normalPower;
        this.bigHolePower = variety.getBig_holes();
        this.energyPerOperation = variety.getEnergyPerOperation();
        this.energyBigHolePowerOperation = variety.getEnergyPerBigOperation();
        this.energyPerbigHolePowerOperation = variety.getEnergyPerbigHolePowerOperation();
        this.energyPerultraLowPowerOperation = variety.getEnergyPerultraLowPowerOperation();
        this.ultraLowPower = variety.getMega_holes();
        this.ultraLowPower1 = variety.getUltra_power();
        this.mineableBlocks = type.getMineableBlocks();
        this.materials = type.getMaterials();
        this.toolType = type.getToolType();
        this.operations = type.getListOperations();
        this.item_tools = type.getListItems();
        this.func_77656_e(0);
        this.func_77637_a(IUCore.EnergyTab);
        this.func_77655_b(name);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe((Item)this, type.getEnumInfoUpgradeModules());
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:energy_tools/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        float energy;
        List<UpgradeItemInform> upgradeItemInforms;
        Block block = state.func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            return false;
        }
        if (state.func_185904_a() instanceof MaterialLiquid || state.func_185887_b(world, pos) == -1.0f && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!world.field_72995_K) {
            if (ForgeHooks.onBlockBreakEvent((World)world, (GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)((EntityPlayerMP)entity), (BlockPos)pos) == -1) {
                return false;
            }
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)((EntityPlayerMP)entity), true)) {
                upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
                boolean smelter = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SMELTER, stack, upgradeItemInforms);
                boolean comb = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.COMB_MACERATOR, stack, upgradeItemInforms);
                boolean mac = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.MACERATOR, stack, upgradeItemInforms);
                boolean generator = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENERATOR, stack, upgradeItemInforms);
                int random = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RANDOM, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RANDOM, (ItemStack)stack, upgradeItemInforms).number : 0;
                NBTTagCompound nbt = ModUtils.nbt(stack);
                boolean black_list = nbt.func_74767_n("black");
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, (EntityPlayer)((EntityPlayerMP)entity), pos, state, null, stack);
                List items = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
                ((EntityPlayerMP)entity).func_71020_j(-0.025f);
                if (!black_list || ModUtils.getore(block, block.func_176201_c(state)) && this.check_list(block, block.func_176201_c(state), UpgradeSystem.system.getBlackList(stack))) {
                    int rand;
                    for (EntityItem item : items) {
                        RecipeOutput rec;
                        if (entity.func_130014_f_().field_72995_K) continue;
                        ItemStack stack1 = item.func_92059_d();
                        if (comb) {
                            rec = Recipes.recipes.getRecipeOutput((String)"comb_macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output;
                            if (rec != null) {
                                stack1 = rec.items.get(0).func_77946_l();
                                stack1.func_190920_e(3);
                            }
                        } else if (mac && (rec = Recipes.recipes.getRecipeOutput((String)"macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output) != null) {
                            stack1 = rec.items.get(0).func_77946_l();
                        }
                        ItemStack smelt = new ItemStack(Items.field_190931_a);
                        if (smelter && !(smelt = FurnaceRecipes.func_77602_a().func_151395_a(stack1).func_77946_l()).func_190926_b()) {
                            smelt.func_190920_e(stack1.func_190916_E());
                        }
                        if (generator) {
                            boolean rec2;
                            int fuel = ModUtils.getFuelValue(stack1, false);
                            boolean bl = rec2 = fuel > 0;
                            if (rec2) {
                                int amount = stack1.func_190916_E();
                                int value = fuel / 4;
                                amount *= value;
                                amount = (int)((float)amount * 10.0f);
                                double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                amount = (int)((double)amount - sentPacket);
                                amount = (int)((float)amount / ((float)value * 10.0f));
                                stack1.func_190920_e(amount);
                            }
                        }
                        if (!smelt.func_190926_b()) {
                            item.func_92058_a(smelt);
                        } else {
                            item.func_92058_a(stack1);
                        }
                        item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                        item.func_174867_a(0);
                    }
                    if (random != 0 && (rand = world.field_73012_v.nextInt(100001)) >= 100000 - random) {
                        EntityItem item;
                        item = new EntityItem(world);
                        item.func_92058_a(IUCore.get_ingot.get(world.field_73012_v.nextInt(IUCore.get_ingot.size())));
                        item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                        item.func_174867_a(0);
                    }
                } else {
                    int rand;
                    if (nbt.func_74767_n("black")) {
                        for (EntityItem item : items) {
                            if (entity.func_130014_f_().field_72995_K) continue;
                            item.func_70106_y();
                        }
                    }
                    if (random != 0 && (rand = world.field_73012_v.nextInt(100001)) >= 100000 - random) {
                        EntityItem item;
                        item = new EntityItem(world);
                        item.func_92058_a(IUCore.get_ingot.get(world.field_73012_v.nextInt(IUCore.get_ingot.size())));
                        item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                        item.func_174867_a(0);
                    }
                }
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)entity;
            mpPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, new BlockPos((Vec3i)pos)));
        } else {
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)entity, true)) {
                block.func_176206_d(world, pos, state);
            }
            Objects.requireNonNull(Minecraft.func_71410_x().func_147114_u()).func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        if (entity.func_70089_S() && (energy = this.energy(stack, upgradeItemInforms = UpgradeSystem.system.getInformation(stack))) != 0.0f) {
            ElectricItem.manager.use(stack, energy, entity);
        }
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull EnumHand hand) {
        NBTTagCompound nbt;
        ItemStack itemStack = player.func_184586_b(hand);
        if (IUCore.keyboard.isSaveModeKeyDown(player)) {
            nbt = ModUtils.nbt(itemStack);
            boolean save = !nbt.func_74767_n("save");
            CommonProxy.sendPlayerMessage(player, TextFormatting.GREEN + Localization.translate("message.savemode") + (save ? Localization.translate("message.allow") : Localization.translate("message.disallow")));
            nbt.func_74757_a("save", save);
        }
        if (IUCore.keyboard.isBlackListModeKeyDown(player)) {
            nbt = ModUtils.nbt(itemStack);
            boolean black = !nbt.func_74767_n("black");
            CommonProxy.sendPlayerMessage(player, TextFormatting.GREEN + Localization.translate("message.blacklist") + (black ? Localization.translate("message.allow") : Localization.translate("message.disallow")));
            nbt.func_74757_a("black", black);
        }
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = this.readToolMode(itemStack) + 1;
            if (!IUCore.proxy.isRendering()) {
                worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, EnumSound.toolchange.getSoundEvent(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
            if (toolMode >= this.operations.size()) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            EnumOperations operation = this.operations.get(toolMode);
            if (IUCore.proxy.isSimulating()) {
                IUCore.proxy.messagePlayer(player, TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + operation.getTextFormatting() + operation.getName_mode(), new Object[0]);
            }
            switch (operation) {
                case ORE: 
                case TREE: 
                case SHEARS: 
                case TUNNEL: 
                case DEFAULT: {
                    this.field_77864_a = this.normalPower;
                    break;
                }
                case BIGHOLES: {
                    this.field_77864_a = this.bigHolePower;
                    break;
                }
                case MEGAHOLES: {
                    this.field_77864_a = this.ultraLowPower;
                    break;
                }
                case ULTRAHOLES: {
                    this.field_77864_a = this.ultraLowPower1;
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public int readToolMode(ItemStack itemstack) {
        NBTTagCompound nbt = ModUtils.nbt(itemstack);
        int toolMode = nbt.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode >= this.operations.size()) {
            toolMode = 0;
        }
        return toolMode;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            if (nbt.func_74779_i("mode").equals("")) {
                return ItemEnergyInstruments.getModelLocation1(name, nbt.func_74779_i("mode"));
            }
            return ItemEnergyInstruments.getModelLocation1(this.name_type, nbt.func_74779_i("mode"));
        });
        for (String s : mode = new String[]{"", "Zelen", "Demon", "Dark", "Cold", "Ender", "Ukraine", "Fire", "Snow", "Taiga", "Desert", "Emerald"}) {
            if (s.equals("")) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemEnergyInstruments.getModelLocation1(name, s)});
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemEnergyInstruments.getModelLocation1(this.name_type, s)});
        }
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemBlackListLoad(world, this, itemStack, itemStack.func_77978_p()));
        }
        if (entity instanceof EntityPlayer && IUCore.keyboard.isBlackListModeViewKeyDown((EntityPlayer)entity) && IUCore.proxy.isSimulating() && !itemStack.func_190926_b() && ((EntityPlayer)entity).func_184586_b(EnumHand.MAIN_HAND).func_77969_a(itemStack)) {
            ((EntityPlayer)entity).openGui((Object)IUCore.instance, 1, world, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs subs, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(subs)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            NBTTagCompound nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((Item)this, 1);
            nbt = ModUtils.nbt(itemstack);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    public int getHarvestLevel(@Nonnull ItemStack stack, @Nonnull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return !this.toolType.contains(toolClass) ? super.getHarvestLevel(stack, toolClass, player, blockState) : this.field_77862_b.func_77996_d();
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase damagee, @Nonnull EntityLivingBase damager) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack par1ItemStack, @Nullable World worldIn, @Nonnull List<String> par3List, @Nonnull ITooltipFlag flagIn) {
        int toolMode = this.readToolMode(par1ItemStack);
        EnumOperations operations = this.operations.get(toolMode);
        par3List.add(TextFormatting.GOLD + Localization.translate("message.text.mode") + ": " + operations.getTextFormatting() + operations.getName_mode());
        par3List.add(operations.getDescription());
        if (ModUtils.nbt(par1ItemStack).func_74767_n("save")) {
            par3List.add(TextFormatting.GREEN + Localization.translate("iu.savemode_allow"));
        }
        if (ModUtils.nbt(par1ItemStack).func_74767_n("black")) {
            par3List.add(TextFormatting.DARK_GRAY + Localization.translate("iu.blacklist_allow"));
        }
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(par1ItemStack);
        if (operations != EnumOperations.DEFAULT && operations != EnumOperations.ORE && operations != EnumOperations.TREE) {
            int aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, par1ItemStack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)par1ItemStack, upgradeItemInforms).number : 0;
            int dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, par1ItemStack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)par1ItemStack, upgradeItemInforms).number : 0;
            par3List.add(Localization.translate("iu.instruments.info") + (operations.getArea_x() + aoe) + "x" + (operations.getArea_y() + aoe) + "x" + (operations.getArea_z() + dig_depth));
        }
        float energy = this.energy(par1ItemStack, upgradeItemInforms);
        par3List.add(Localization.translate("iu.instruments.info2") + (int)energy + " EF");
        if (!Keyboard.isKeyDown((int)42)) {
            par3List.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            par3List.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.changemode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
            par3List.add(Localization.translate("iu.blacklist_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.blackmode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
            par3List.add(Localization.translate("iu.savemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.savemode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
            par3List.add(Localization.translate("iu.blacklist_gui") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.blacklistviewmode.func_151463_i())));
        }
        ModUtils.mode(par1ItemStack, par3List);
        super.func_77624_a(par1ItemStack, worldIn, par3List, flagIn);
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    @Nonnull
    public Set<String> getToolClasses(@Nonnull ItemStack stack) {
        return this.toolType;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, @Nonnull ItemStack stack) {
        if (this.mineableBlocks.contains(state)) {
            return true;
        }
        if (this.materials.contains(state.func_185904_a())) {
            return true;
        }
        for (Item item : this.item_tools) {
            if (!item.canHarvestBlock(state, stack) && !(item.func_150893_a(stack, state) > 1.0f)) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        int speed;
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        int n = speed = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.EFFICIENCY, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EFFICIENCY, (ItemStack)stack, upgradeItemInforms).number : 0;
        return !ElectricItem.manager.canUse(stack, this.energy(stack, upgradeItemInforms)) ? 0.0f : (this.canHarvestBlock(state, stack) ? this.field_77864_a + (float)((int)((double)this.field_77864_a * 0.2 * (double)speed)) : 1.0f);
    }

    void chopTree(BlockPos pos, EntityPlayer player, World world, ItemStack stack, List<BlockPos> list, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        int Y = pos.func_177956_o();
        int X = pos.func_177958_n();
        int Z = pos.func_177952_p();
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= Y + 1; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    BlockPos pos1 = new BlockPos(xPos, yPos, zPos);
                    if (list.contains(pos1)) continue;
                    IBlockState state = world.func_180495_p(pos1);
                    Block block = state.func_177230_c();
                    list.add(pos1);
                    if (!block.isWood((IBlockAccess)world, pos1)) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.onBlockDestroyed(stack, world, state, pos1, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                    }
                    this.chopTree(pos1, player, world, stack, list, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
            }
        }
    }

    private boolean isTree(World world, BlockPos pos) {
        Block wood = world.func_180495_p(pos).func_177230_c();
        if (wood.equals(Blocks.field_150350_a) || !wood.isWood((IBlockAccess)world, pos)) {
            return false;
        }
        int top = pos.func_177956_o();
        int Y = pos.func_177956_o();
        int X = pos.func_177958_n();
        int Z = pos.func_177952_p();
        for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 50; ++y) {
            BlockPos pos1 = new BlockPos(X, y, Z);
            IBlockState blockstate = world.func_180495_p(pos1);
            if (blockstate.func_177230_c().isWood((IBlockAccess)world, pos1) || blockstate.func_177230_c().isLeaves(blockstate, (IBlockAccess)world, pos1)) continue;
            top += y;
            break;
        }
        int leaves = 0;
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= top; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    BlockPos pos1 = new BlockPos(xPos, yPos, zPos);
                    IBlockState blockstate = world.func_180495_p(pos1);
                    if (!blockstate.func_177230_c().isLeaves(blockstate, (IBlockAccess)world, pos1)) continue;
                    ++leaves;
                }
            }
        }
        return leaves >= 3;
    }

    boolean break_block(World world, Block block, RayTraceResult mop, byte mode_item, EntityPlayer player, BlockPos pos, ItemStack stack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        byte xRange = mode_item;
        byte yRange = mode_item;
        byte zRange = mode_item;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        byte dig_depth = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0);
        switch (mop.field_178784_b.ordinal()) {
            case 0: 
            case 1: {
                yRange = dig_depth;
                break;
            }
            case 2: 
            case 3: {
                zRange = dig_depth;
                break;
            }
            case 4: 
            case 5: {
                xRange = dig_depth;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int Yy = yRange > 0 ? yRange - 1 : 0;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        float energy = this.energy(stack, upgradeItemInforms);
        boolean save = nbt.func_74767_n("save");
        if (!player.field_71075_bZ.field_75098_d) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block6: for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, energy)) {
                            IBlockState state;
                            Block localBlock;
                            BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                            if (save && world.func_175625_s(pos_block) != null || (localBlock = (state = world.func_180495_p(pos_block)).func_177230_c()).equals(Blocks.field_150350_a) || !this.canHarvestBlock(state, stack) || !(state.func_185887_b(world, pos_block) >= 0.0f)) continue;
                            if (state.func_185887_b(world, pos_block) > 0.0f) {
                                this.onBlockDestroyed(stack, world, state, pos_block, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                            }
                            if (silktouch) continue;
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                            continue;
                        }
                        lowPower = true;
                        continue block6;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, energy)) {
            IBlockState state = world.func_180495_p(pos);
            Block localBlock = state.func_177230_c();
            if (!localBlock.equals(Blocks.field_150350_a) && this.canHarvestBlock(state, stack) && state.func_185887_b(world, pos) >= 0.0f || block == Blocks.field_150418_aU) {
                if (state.func_185887_b(world, pos) > 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.func_185887_b(world, pos) > 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
            }
        }
        if (lowPower && ElectricItem.manager.canUse(stack, energy)) {
            IBlockState state = world.func_180495_p(pos);
            Block localBlock = state.func_177230_c();
            if (!localBlock.equals(Blocks.field_150350_a) && this.canHarvestBlock(state, stack) && state.func_185887_b(world, pos) >= 0.0f || block == Blocks.field_150418_aU) {
                if (state.func_185887_b(world, pos) > 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.func_185887_b(world, pos) > 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
            }
        }
        return true;
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        EnumOperations operations = this.operations.get(this.readToolMode(stack));
        World world = player.func_130014_f_();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        RayTraceResult mop = RetraceDiggingUtils.retrace(player);
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        boolean smelter = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SMELTER, stack, upgradeItemInforms);
        boolean comb = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.COMB_MACERATOR, stack, upgradeItemInforms);
        boolean mac = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.MACERATOR, stack, upgradeItemInforms);
        boolean generator = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENERATOR, stack, upgradeItemInforms);
        int random = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RANDOM, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RANDOM, (ItemStack)stack, upgradeItemInforms).number : 0;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        boolean black_list = nbt.func_74767_n("black");
        List<String> list = UpgradeSystem.system.getBlackList(stack);
        switch (operations) {
            case DEFAULT: {
                if (block == Blocks.field_150350_a) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case BIGHOLES: {
                if (block.equals(Blocks.field_150350_a)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.func_70093_af() && !mop.field_72313_a.equals((Object)RayTraceResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(1 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case MEGAHOLES: {
                if (block.equals(Blocks.field_150350_a)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.func_70093_af() && !mop.field_72313_a.equals((Object)RayTraceResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(2 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case ULTRAHOLES: {
                if (block.equals(Blocks.field_150350_a)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.func_70093_af() && !mop.field_72313_a.equals((Object)RayTraceResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(3 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case ORE: {
                if (block.equals(Blocks.field_150350_a)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                boolean silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                nbt.func_74768_a("ore", 1);
                float energy = this.energy(stack, upgradeItemInforms);
                if (!mop.field_72313_a.equals((Object)RayTraceResult.Type.MISS)) {
                    this.ore_break(world, pos, player, silktouch, fortune, false, stack, block, smelter, comb, mac, generator, random, black_list, energy, list);
                    return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case TREE: {
                if (!IUCore.dynamicTrees && this.isTree(player.func_130014_f_(), pos)) {
                    player.func_130014_f_().func_175718_b(2001, pos, Block.func_149682_b((Block)player.func_130014_f_().func_180495_p(pos).func_177230_c()) + (player.func_130014_f_().func_180495_p(pos).func_177230_c().func_176201_c(player.func_130014_f_().func_180495_p(pos)) << 12));
                    ArrayList<BlockPos> list1 = new ArrayList<BlockPos>();
                    float energy = this.energy(stack, upgradeItemInforms);
                    this.chopTree(pos, player, player.func_130014_f_(), stack, list1, energy, smelter, comb, mac, generator, random, black_list, list);
                    return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case TUNNEL: {
                if (block == Blocks.field_150350_a) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                return this.break_block_tunel(world, block, mop, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case SHEARS: {
                if (block == Blocks.field_150350_a) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                if (block instanceof IShearable) {
                    return this.break_shears(world, block, mop, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        return false;
    }

    private boolean break_shears(World world, Block block, RayTraceResult mop, EntityPlayer player, BlockPos pos, ItemStack itemstack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean blackList, List<String> list) {
        float energy = this.energy(itemstack, upgradeItemInforms);
        IBlockState state = world.func_180495_p(pos);
        IShearable target = (IShearable)block;
        if (target.isShearable(itemstack, (IBlockAccess)world, pos) && ElectricItem.manager.use(itemstack, energy, (EntityLivingBase)player) && !block.equals(Blocks.field_150350_a) && this.canHarvestBlock(state, itemstack) && state.func_185887_b(world, pos) >= 0.0f && state.func_185887_b(world, pos) > 0.0f) {
            this.onBlockDestroyed(itemstack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, blackList, list, true);
            return true;
        }
        return false;
    }

    private boolean break_block_tunel(World world, Block block, RayTraceResult mop, EntityPlayer player, BlockPos pos, ItemStack stack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> list) {
        int xRange = 6;
        int yRange = 6;
        int zRange = 6;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (mop.field_178784_b.ordinal()) {
            case 0: 
            case 1: {
                xRange = 0;
                zRange = 0;
                break;
            }
            case 2: 
            case 3: {
                xRange = 0;
                yRange = 0;
                break;
            }
            case 4: 
            case 5: {
                zRange = 0;
                yRange = 0;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        float energy = this.energy(stack, upgradeItemInforms);
        byte dig_depth = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0);
        if (dig_depth > 0) {
            if (zRange > 0) {
                xRange = dig_depth;
            } else {
                zRange = xRange > 0 ? (int)dig_depth : (int)dig_depth;
            }
        }
        boolean save = nbt.func_74767_n("save");
        if (!player.field_71075_bZ.field_75098_d) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block6: for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, energy)) {
                            IBlockState state;
                            Block localBlock;
                            BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                            if (save && world.func_175625_s(pos_block) != null || (localBlock = (state = world.func_180495_p(pos_block)).func_177230_c()).equals(Blocks.field_150350_a) || !this.canHarvestBlock(state, stack) || !(state.func_185887_b(world, pos_block) >= 0.0f)) continue;
                            if (state.func_185887_b(world, pos_block) > 0.0f) {
                                this.onBlockDestroyed(stack, world, state, pos_block, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, list);
                            }
                            if (silktouch) continue;
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                            continue;
                        }
                        lowPower = true;
                        continue block6;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, energy)) {
            IBlockState state = world.func_180495_p(pos);
            Block localBlock = state.func_177230_c();
            if (!localBlock.equals(Blocks.field_150350_a) && this.canHarvestBlock(state, stack) && state.func_185887_b(world, pos) >= 0.0f || block == Blocks.field_150418_aU) {
                if (state.func_185887_b(world, pos) > 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, list);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.func_185887_b(world, pos) > 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        if (lowPower && ElectricItem.manager.canUse(stack, energy)) {
            IBlockState state = world.func_180495_p(pos);
            Block localBlock = state.func_177230_c();
            if (!localBlock.equals(Blocks.field_150350_a) && this.canHarvestBlock(state, stack) && state.func_185887_b(world, pos) >= 0.0f || block == Blocks.field_150418_aU) {
                if (state.func_185887_b(world, pos) > 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, list);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.func_185887_b(world, pos) > 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        return true;
    }

    private void ore_break(World world, BlockPos pos, EntityPlayer player, boolean silktouch, int fortune, boolean lowPower, ItemStack stack, Block block1, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, float energy, List<String> list) {
        NBTTagCompound NBTTagCompound2 = ModUtils.nbt(stack);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int Xx = x - 1; Xx <= x + 1; ++Xx) {
            block1: for (int Yy = y - 1; Yy <= y + 1; ++Yy) {
                for (int Zz = z - 1; Zz <= z + 1; ++Zz) {
                    BlockPos pos_block;
                    IBlockState state;
                    Block localBlock;
                    int ore = NBTTagCompound2.func_74762_e("ore");
                    if (ore >= 16 || !ModUtils.getore(localBlock = (state = world.func_180495_p(pos_block = new BlockPos(Xx, Yy, Zz))).func_177230_c(), block1)) continue;
                    if (ElectricItem.manager.canUse(stack, energy)) {
                        if (player.field_71075_bZ.field_75098_d) continue block1;
                        if (state.func_185887_b(world, pos_block) > 0.0f) {
                            this.onBlockDestroyed(stack, world, state, pos_block, (EntityLivingBase)player, energy, smelter, comb, mac, generator, random, black_list, list);
                        }
                        if (!silktouch) {
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                        }
                        NBTTagCompound2.func_74768_a("ore", ++ore);
                        this.ore_break(world, pos_block, player, silktouch, fortune, lowPower, stack, block1, smelter, comb, mac, generator, random, black_list, energy, list);
                        continue;
                    }
                    lowPower = true;
                    continue block1;
                }
            }
        }
    }

    private int getExperience(IBlockState state, World world, BlockPos pos_block, int fortune, ItemStack stack, Block localBlock) {
        int col = localBlock.getExpDrop(state, (IBlockAccess)world, pos_block, fortune);
        col = (int)((double)col * (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.EXPERIENCE, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EXPERIENCE, (ItemStack)stack).number * 0.5 + 1.0 : 1.0));
        return col;
    }

    public boolean onBlockDestroyed(@Nonnull ItemStack stack, @Nonnull World world, IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        return this.onBlockDestroyed(stack, world, state, pos, entity, energy, smelter, comb, mac, generator, random, black_list, blackList, false);
    }

    public boolean onBlockDestroyed(@Nonnull ItemStack stack, @Nonnull World world, IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList, boolean shears) {
        Block block = state.func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            return false;
        }
        if (state.func_185904_a() instanceof MaterialLiquid || state.func_185887_b(world, pos) == -1.0f && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!world.field_72995_K) {
            int rand;
            List drops1 = null;
            if (shears && block instanceof IShearable) {
                drops1 = ((IShearable)block).onSheared(stack, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            }
            if (ForgeHooks.onBlockBreakEvent((World)world, (GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)((EntityPlayerMP)entity), (BlockPos)pos) == -1) {
                return false;
            }
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)((EntityPlayerMP)entity), true)) {
                block.func_176206_d(world, pos, state);
                if (!shears) {
                    block.func_180657_a(world, (EntityPlayer)((EntityPlayerMP)entity), pos, state, null, stack);
                    NBTTagCompound nbt = ModUtils.nbt(stack);
                    List items = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
                    ((EntityPlayerMP)entity).func_71020_j(-0.025f);
                    if (!black_list || ModUtils.getore(block, block.func_176201_c(state)) && this.check_list(block, block.func_176201_c(state), blackList)) {
                        for (EntityItem item : items) {
                            BaseMachineRecipe rec;
                            if (entity.func_130014_f_().field_72995_K) continue;
                            ItemStack stack1 = item.func_92059_d();
                            if (comb) {
                                rec = Recipes.recipes.getRecipeOutput("comb_macerator", false, stack1);
                                if (rec != null) {
                                    stack1 = rec.output.items.get(0).func_77946_l();
                                    item.func_92058_a(stack1);
                                }
                            } else if (mac && (rec = Recipes.recipes.getRecipeOutput("macerator", false, stack1)) != null) {
                                stack1 = rec.output.items.get(0).func_77946_l();
                                item.func_92058_a(stack1);
                            }
                            if (smelter) {
                                ItemStack smelt = FurnaceRecipes.func_77602_a().func_151395_a(stack1).func_77946_l();
                                if (!smelt.func_190926_b()) {
                                    smelt.func_190920_e(stack1.func_190916_E());
                                    item.func_92058_a(smelt);
                                } else {
                                    item.func_92058_a(item.func_92059_d());
                                }
                            }
                            if (generator) {
                                boolean rec2;
                                int fuel = ModUtils.getFuelValue(stack1, false);
                                boolean bl = rec2 = fuel > 0;
                                if (rec2) {
                                    int amount = stack1.func_190916_E();
                                    int value = fuel / 4;
                                    amount *= value;
                                    amount = (int)((float)amount * 10.0f);
                                    double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                    amount = (int)((double)amount - sentPacket);
                                    amount = (int)((float)amount / ((float)value * 10.0f));
                                    stack1.func_190920_e(amount);
                                }
                            }
                            item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                            item.func_174867_a(0);
                            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                        }
                    } else if (nbt.func_74767_n("black")) {
                        for (EntityItem item : items) {
                            if (entity.func_130014_f_().field_72995_K) continue;
                            item.func_70106_y();
                        }
                    }
                } else {
                    for (ItemStack stack1 : drops1) {
                        ModUtils.dropAsEntity(world, pos, stack1);
                    }
                    NBTTagCompound nbt = ModUtils.nbt(stack);
                    List items = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
                    ((EntityPlayerMP)entity).func_71020_j(-0.025f);
                    if (!black_list || ModUtils.getore(block, block.func_176201_c(state)) && this.check_list(block, block.func_176201_c(state), blackList)) {
                        for (EntityItem item : items) {
                            BaseMachineRecipe rec;
                            if (entity.func_130014_f_().field_72995_K) continue;
                            ItemStack stack1 = item.func_92059_d();
                            if (comb) {
                                rec = Recipes.recipes.getRecipeOutput("comb_macerator", false, stack1);
                                if (rec != null) {
                                    stack1 = rec.output.items.get(0).func_77946_l();
                                    item.func_92058_a(stack1);
                                }
                            } else if (mac && (rec = Recipes.recipes.getRecipeOutput("macerator", false, stack1)) != null) {
                                stack1 = rec.output.items.get(0).func_77946_l();
                                item.func_92058_a(stack1);
                            }
                            if (smelter) {
                                ItemStack smelt = FurnaceRecipes.func_77602_a().func_151395_a(stack1).func_77946_l();
                                if (!smelt.func_190926_b()) {
                                    smelt.func_190920_e(stack1.func_190916_E());
                                    item.func_92058_a(smelt);
                                } else {
                                    item.func_92058_a(item.func_92059_d());
                                }
                            }
                            if (generator) {
                                boolean rec3;
                                int fuel = ModUtils.getFuelValue(stack1, false);
                                boolean bl = rec3 = fuel > 0;
                                if (rec3) {
                                    int amount = stack1.func_190916_E();
                                    int value = fuel / 4;
                                    amount *= value;
                                    amount = (int)((float)amount * 10.0f);
                                    double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                    amount = (int)((double)amount - sentPacket);
                                    amount = (int)((float)amount / ((float)value * 10.0f));
                                    stack1.func_190920_e(amount);
                                }
                            }
                            item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                            item.func_174867_a(0);
                            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                        }
                    } else if (nbt.func_74767_n("black")) {
                        for (EntityItem item : items) {
                            if (entity.func_130014_f_().field_72995_K) continue;
                            item.func_70106_y();
                        }
                    }
                    return true;
                }
            }
            if (random != 0 && (rand = world.field_73012_v.nextInt(100001)) >= 100000 - random) {
                EntityItem item = new EntityItem(world);
                item.func_92058_a(IUCore.get_ingot.get(world.field_73012_v.nextInt(IUCore.get_ingot.size())));
                item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)entity;
            mpPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, new BlockPos((Vec3i)pos)));
        } else {
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)entity, true)) {
                block.func_176206_d(world, pos, state);
            }
            Objects.requireNonNull(Minecraft.func_71410_x().func_147114_u()).func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        if (entity.func_70089_S() && energy != 0.0f) {
            ElectricItem.manager.use(stack, energy, entity);
        }
        return true;
    }

    @Override
    public IAdvInventory getInventory(EntityPlayer player, ItemStack stack) {
        return new ItemStackUpgradeItem(player, stack);
    }

    public boolean check_list(Block block, int metaFromState, List<String> blackList) {
        if (blackList.isEmpty()) {
            return true;
        }
        ItemStack stack1 = new ItemStack(block, 1, metaFromState);
        if (stack1.func_190926_b()) {
            return true;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack1);
        if (ids.length < 1) {
            return true;
        }
        String name = OreDictionary.getOreName((int)ids[0]);
        return !blackList.contains(name);
    }

    public void saveToolMode(ItemStack itemstack, int toolMode) {
        NBTTagCompound nbt = ModUtils.nbt(itemstack);
        nbt.func_74768_a("toolMode", toolMode);
        itemstack.func_77982_d(nbt);
    }

    public float energy(ItemStack stack, List<UpgradeItemInform> upgradeItemInforms) {
        float energy;
        int energy1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack, upgradeItemInforms).number : 0;
        int toolMode = this.readToolMode(stack);
        EnumOperations operations = this.operations.get(toolMode);
        switch (operations) {
            case BIGHOLES: {
                energy = (float)((double)this.energyBigHolePowerOperation - (double)this.energyBigHolePowerOperation * 0.25 * (double)energy1);
                break;
            }
            case MEGAHOLES: {
                energy = (float)((double)this.energyPerbigHolePowerOperation - (double)this.energyPerbigHolePowerOperation * 0.25 * (double)energy1);
                break;
            }
            case ULTRAHOLES: {
                energy = (float)((double)this.energyPerultraLowPowerOperation - (double)this.energyPerultraLowPowerOperation * 0.25 * (double)energy1);
                break;
            }
            default: {
                energy = (float)((double)this.energyPerOperation - (double)this.energyPerOperation * 0.25 * (double)energy1);
            }
        }
        return energy;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.toolType.contains("pickaxe")) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                boolean result;
                Item item;
                ItemStack torchStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (torchStack.func_190926_b() || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
                int oldMeta = torchStack.func_77952_i();
                int oldSize = torchStack.func_190916_E();
                ItemStack stack = player.func_184586_b(hand).func_77946_l();
                boolean bl = result = torchStack.func_179546_a(player, world, pos, hand, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS;
                if (player.field_71075_bZ.field_75098_d) {
                    torchStack.func_77964_b(oldMeta);
                    torchStack.func_190920_e(oldSize);
                }
                if (!result) continue;
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack, null);
                torchStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                player.func_184611_a(hand, stack);
                torchStack.func_190920_e(torchStack.func_190916_E() - 1);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }
}

