/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.items.BaseEnergyItem;
import com.denfop.utils.ModUtils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemWindMeter
extends BaseEnergyItem
implements IModelRegister {
    public ItemWindMeter() {
        super("wind_meter", 5000.0, 500.0, 1);
        IUCore.proxy.addIModelRegister(this);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:energy/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemWindMeter.getModelLocation(name));
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!IUCore.proxy.isSimulating() || world.field_73011_w.getDimension() != 0) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!ElectricItem.manager.canUse(stack, 10.0)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        ElectricItem.manager.use(stack, 10.0, (EntityLivingBase)player);
        IUCore.proxy.messagePlayer(player, Localization.translate("iu.wind_meter.info") + String.format("%.1f", WindSystem.windSystem.getWind_Strength()) + " m/s", new Object[0]);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }
}

