/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemKatana
extends ItemTool
implements IEnergyItem,
IUpgradeItem,
IModelRegister {
    public final int maxCharge;
    public final int transferLimit;
    public final int tier;
    private final String name;
    public int damage1;
    private int soundTicker = 0;

    public ItemKatana(String name) {
        super(0.0f, 2.0f, Item.ToolMaterial.DIAMOND, Collections.emptySet());
        this.maxCharge = 500000;
        this.transferLimit = 5000;
        this.tier = 4;
        this.name = name;
        this.damage1 = 13;
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(name);
        this.func_77637_a(IUCore.EnergyTab);
        this.setHarvestLevel("sword", 3);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SABERS.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:energy_tools/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.changemode_key") + Localization.translate("iu.changemode_rcm1"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        NBTTagCompound nbt = ModUtils.nbt(playerIn.func_184586_b(handIn));
        switch (nbt.func_74779_i("type")) {
            case "": {
                nbt.func_74778_a("type", "yellow");
                break;
            }
            case "yellow": {
                nbt.func_74778_a("type", "green");
                break;
            }
            case "green": {
                nbt.func_74778_a("type", "pink");
                break;
            }
            case "pink": {
                nbt.func_74778_a("type", "");
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_150895_a(@Nonnull CreativeTabs subs, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(subs)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((Item)this, 1, 27);
            items.add((Object)itemstack);
        }
    }

    public boolean canHarvestBlock(IBlockState state, @Nonnull ItemStack itemStack) {
        return true;
    }

    public boolean drainSaber(ItemStack itemStack, double amount) {
        int saberenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABERENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABERENERGY, (ItemStack)itemStack).number : 0;
        return ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)saberenergy, null);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack item, @Nonnull EntityPlayer player) {
        return true;
    }

    public float func_150893_a(@Nonnull ItemStack itemStack, @Nonnull IBlockState state) {
        ++this.soundTicker;
        if (this.soundTicker % 4 == 0) {
            IUCore.proxy.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return 4.0f;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot p_getAttributeModifiers_1_, @Nonnull ItemStack stack) {
        if (p_getAttributeModifiers_1_ != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(p_getAttributeModifiers_1_, stack);
        }
        int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
        int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", (double)dmg, 0));
        return hashMultimap;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase source) {
        if (IUCore.proxy.isSimulating()) {
            if (!this.drainSaber(stack, 400.0)) {
                return false;
            }
            int vampires = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.VAMPIRES, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.VAMPIRES, (ItemStack)stack).number : 0;
            boolean wither = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WITHER, stack);
            boolean poison = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.POISON, stack);
            if (vampires != 0) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 40, vampires));
            }
            if (wither) {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60));
            }
            if (poison) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.HUNGRY, stack)) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60));
            }
            if (source instanceof EntityPlayerMP) {
                new PacketSoundPlayer("katana", (EntityPlayer)source);
            }
            if (!(source instanceof EntityPlayerMP) || !(target instanceof EntityPlayer) || ((EntityPlayerMP)source).func_96122_a((EntityPlayer)target)) {
                Iterator var4 = Arrays.stream(EntityEquipmentSlot.values()).filter(slot -> slot != EntityEquipmentSlot.MAINHAND && slot != EntityEquipmentSlot.OFFHAND).iterator();
                while (var4.hasNext()) {
                    EntityEquipmentSlot slot2 = (EntityEquipmentSlot)var4.next();
                    if (!ElectricItem.manager.canUse(stack, 2000.0)) break;
                    ItemStack armor = target.func_184582_a(slot2);
                    if (!armor.func_190926_b()) continue;
                    double amount = 0.0;
                    if (armor.func_77973_b() instanceof ItemSpecialArmor) {
                        amount = ((ItemSpecialArmor)armor.func_77973_b()).getArmor().getDamageEnergy();
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.func_184201_a(slot2, ItemStack.field_190927_a);
                    }
                    this.drainSaber(stack, 2000.0);
                }
            }
        }
        if (IUCore.proxy.isRendering()) {
            IUCore.proxy.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return true;
    }

    public String getRandomSwingSound() {
        switch (IUCore.random.nextInt(3)) {
            default: {
                return "nanosabreswing1";
            }
            case 1: {
                return "nanosabreswing2";
            }
            case 2: 
        }
        return "nanosabreswing3";
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.drainSaber(stack, 80.0);
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    @Nonnull
    public String func_77658_a() {
        return "iu" + super.func_77658_a().substring(4);
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack itemStack) {
        return this.func_77658_a();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemStack) {
        return Localization.translate(this.func_77667_c(itemStack));
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            return ItemKatana.getModelLocation1(name, nbt.func_74779_i("type").equals("") ? "" : "_" + nbt.func_74779_i("type"));
        });
        for (String s : mode = new String[]{"", "_yellow", "_green", "_pink"}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemKatana.getModelLocation1(name, s)});
        }
    }
}

