/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.block;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.items.block.ItemBlockIU;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.tiles.base.TileEntityBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTileEntity
extends ItemBlockIU {
    public final ResourceLocation identifier;

    public ItemBlockTileEntity(Block block, ResourceLocation identifier) {
        super(block);
        this.func_77627_a(true);
        this.identifier = identifier;
    }

    public static boolean placeTeBlock(ItemStack stack, EntityLivingBase placer, World world, BlockPos pos, EnumFacing side, TileEntityBlock te) {
        IBlockState oldState = world.func_180495_p(pos);
        IBlockState newState = IUItem.invalid.func_176223_P();
        if (!world.func_180501_a(pos, newState, 0)) {
            return false;
        }
        world.func_175690_a(pos, (TileEntity)te);
        te.onPlaced(stack, placer, side);
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, te.getBlockState(), 3);
        if (!world.field_72995_K) {
            new PacketUpdateTile(te);
        }
        return true;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        IMultiTileBlock teBlock = this.getTeBlock(stack);
        String name = teBlock == null ? "invalid" : teBlock.func_176610_l();
        return super.func_77658_a() + "." + name;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        this.field_150939_a.func_149666_a(tab, items);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        IMultiTileBlock block = this.getTeBlock(stack);
        if (block != null && block.getDummyTe() != null) {
            block.getDummyTe().addInformation(stack, tooltip, advanced);
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        assert (newState.func_177230_c() == this.field_150939_a);
        if (!((BlockTileEntity)this.field_150939_a).canReplace(world, pos, side, stack)) {
            return false;
        }
        IMultiTileBlock teBlock = this.getTeBlock(stack);
        if (teBlock == null) {
            return false;
        }
        Class<? extends TileEntityBlock> teClass = teBlock.getTeClass();
        if (teClass == null) {
            return false;
        }
        TileEntityBlock te = TileEntityBlock.instantiate(teClass);
        return ItemBlockTileEntity.placeTeBlock(stack, (EntityLivingBase)player, world, pos, side, te);
    }

    public IMultiTileBlock getTeBlock(ItemStack stack) {
        return stack == null ? null : (((BlockTileEntity)this.field_150939_a).teInfo.getIdMap().size() > 0 ? ((BlockTileEntity)this.field_150939_a).teInfo.getIdMap().get(stack.func_77952_i()) : null);
    }
}

