/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.container.ContainerBags;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bags.BagsDescription;
import com.denfop.items.bags.ItemStackBags;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemEnergyBags
extends Item
implements IItemStackInventory,
IUpgradeItem,
IEnergyItem,
IModelRegister {
    private final int slots;
    private final int maxStorage;
    private final int getTransferLimit;
    private final String internalName;

    public ItemEnergyBags(String internalName, int slots, int maxStorage, int getTransferLimit) {
        this.func_77637_a(IUCore.EnergyTab);
        this.func_77625_d(1);
        this.internalName = internalName;
        this.slots = slots;
        this.getTransferLimit = getTransferLimit;
        this.maxStorage = maxStorage;
        IUCore.proxy.addIModelRegister(this);
        Register.registerItem(this, IUCore.getIdentifier(internalName)).func_77655_b(internalName);
        UpgradeSystem.system.addRecipe(this, EnumUpgrades.BAGS.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name) {
        String loc = "industrialupgrade:bags/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (entityIn instanceof EntityPlayer) {
            ItemStackBags toolbox;
            int slot_id;
            EntityPlayer player = (EntityPlayer)entityIn;
            if (nbt.func_74767_n("open") && (slot_id = nbt.func_74762_e("slot_inventory")) != itemSlot && !player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(stack) && player.field_71070_bA instanceof ContainerBags && (toolbox = (ItemStackBags)((ContainerBags)player.field_71070_bA).base).isThisContainer(stack)) {
                toolbox.saveAsThrown(stack);
                player.func_71053_j();
                nbt.func_74757_a("open", false);
            }
        }
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(worldIn, this, stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        } else {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            if (!nbt.func_74764_b("bag")) {
                return;
            }
            ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
            NBTTagCompound nbt1 = nbt.func_74775_l("bag");
            int size = nbt1.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                list.add(new BagsDescription(nbt1.func_74775_l(String.valueOf(i))));
            }
            for (BagsDescription description : list) {
                tooltip.add(TextFormatting.GREEN + "" + description.getCount() + "x " + description.getStack().func_82833_r());
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nonnull
    public String func_77658_a() {
        return "item." + this.internalName + ".name";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> ItemEnergyBags.getModelLocation1(name));
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemEnergyBags.getModelLocation1(name)});
    }

    @Override
    public void registerModels() {
        this.registerModels(this.internalName);
    }

    public void func_150895_a(@Nonnull CreativeTabs p_150895_1_, @Nonnull NonNullList<ItemStack> var3) {
        if (this.func_194125_a(p_150895_1_)) {
            ItemStack var4 = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            var3.add((Object)var4);
            var3.add((Object)new ItemStack((Item)this, 1, 27));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, player.func_184586_b(hand)) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)player.func_184586_b((EnumHand)hand)).number * 0.25 : 0.0);
        if (ElectricItem.manager.canUse(player.func_184586_b(hand), 350.0 * coef)) {
            ElectricItem.manager.use(player.func_184586_b(hand), 350.0 * coef, (EntityLivingBase)player);
            ItemStack stack = ModUtils.get(player, hand);
            if (IUCore.proxy.isSimulating()) {
                this.save(stack, player);
                player.openGui((Object)IUCore.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @NotNull
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        TileEntity tile = world.func_175625_s(pos);
        if (player.func_70093_af() && tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            ItemStack[] itemStackList;
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            ItemStackBags box = (ItemStackBags)this.getInventory(player, player.func_184586_b(hand));
            for (ItemStack stack : itemStackList = box.getAll()) {
                if (stack == null || stack.func_190926_b()) continue;
                ModUtils.tick(itemStackList, handler, box);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void save(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74757_a("open", true);
        nbt.func_74768_a("slot_inventory", player.field_71071_by.field_70461_c);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, EntityPlayer player) {
        ItemStackBags toolbox;
        if (!player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(stack) && player.field_71070_bA instanceof ContainerBags && (toolbox = (ItemStackBags)((ContainerBags)player.field_71070_bA).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.func_71053_j();
        }
        return true;
    }

    public boolean canInsert(EntityPlayer player, ItemStack stack, ItemStack stack1) {
        ItemStackBags box = (ItemStackBags)this.getInventory(player, stack);
        return box.canAdd(stack1);
    }

    public void insert(EntityPlayer player, ItemStack stack, ItemStack stack1) {
        ItemStackBags box = (ItemStackBags)this.getInventory(player, stack);
        box.add(stack1);
        box.func_70296_d();
    }

    @Override
    public IAdvInventory getInventory(EntityPlayer player, ItemStack stack) {
        return new ItemStackBags(player, stack, this.slots);
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxStorage;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return 2;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.getTransferLimit;
    }
}

