/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour.special;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.container.ContainerBags;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.armour.special.EnumCapability;
import com.denfop.items.armour.special.EnumSubTypeArmor;
import com.denfop.items.armour.special.EnumTypeArmor;
import com.denfop.items.armour.special.ItemStackLegsBags;
import com.denfop.items.bags.BagsDescription;
import com.denfop.items.bags.ItemStackBags;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemSpecialArmor
extends ItemArmor
implements IModelRegister,
IItemStackInventory,
ISpecialArmor,
IEnergyItem,
IUpgradeItem {
    protected final Map<Potion, Integer> potionRemovalCost = new IdentityHashMap<Potion, Integer>();
    private final List<EnumCapability> listCapability;
    private final String name;
    private final double maxCharge;
    private final int tier;
    private final double transferLimit;
    private final EnumTypeArmor armor;
    private float jumpCharge;
    private boolean lastJetpackUsed = false;

    public ItemSpecialArmor(EnumSubTypeArmor subTypeArmor, EnumTypeArmor typeArmor) {
        super(ItemArmor.ArmorMaterial.DIAMOND, -1, subTypeArmor.getEntityEquipmentSlot());
        ArrayList<EnumCapability> list = new ArrayList<EnumCapability>(subTypeArmor.getCapabilities());
        list.removeIf(capability -> !typeArmor.getListCapability().contains(capability));
        this.listCapability = list;
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        if (this.listCapability.contains((Object)EnumCapability.ACTIVE_EFFECT) || this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
            this.potionRemovalCost.put(IUPotion.radiation, 20);
            if (this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
                this.potionRemovalCost.put(MobEffects.field_76436_u, 100);
                this.potionRemovalCost.put(MobEffects.field_82731_v, 100);
                this.potionRemovalCost.put(MobEffects.field_76438_s, 200);
                this.potionRemovalCost.put(MobEffects.field_76421_d, 200);
                this.potionRemovalCost.put(MobEffects.field_189112_A, 200);
                this.potionRemovalCost.put(MobEffects.field_188424_y, 200);
                this.potionRemovalCost.put(MobEffects.field_76431_k, 200);
                this.potionRemovalCost.put(MobEffects.field_76440_q, 200);
                this.potionRemovalCost.put(MobEffects.field_76437_t, 200);
            }
        }
        this.armor = typeArmor;
        this.name = typeArmor.name().toLowerCase() + "_" + subTypeArmor.name().toLowerCase();
        this.maxCharge = typeArmor.getMaxEnergy();
        this.tier = typeArmor.getTier();
        this.transferLimit = typeArmor.getMaxTransfer();
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(this.name);
        this.func_77656_e(0);
        this.func_77637_a(IUCore.EnergyTab);
        Register.registerItem(this, IUCore.getIdentifier(this.name)).func_77655_b(this.name);
        IUCore.proxy.addIModelRegister(this);
        switch (this.field_77881_a) {
            case HEAD: {
                UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.HELMET.list);
                break;
            }
            case CHEST: {
                UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BODY.list);
                break;
            }
            case LEGS: {
                UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.LEGGINGS.list);
                break;
            }
            case FEET: {
                UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BOOTS.list);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:armour/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public EnumTypeArmor getArmor() {
        return this.armor;
    }

    public List<EnumCapability> getListCapability() {
        return this.listCapability;
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    public void func_150895_a(CreativeTabs subs, NonNullList<ItemStack> items) {
        if (this.func_194125_a(subs)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            NBTTagCompound nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((Item)this, 1);
            nbt = ModUtils.nbt(itemstack);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            String mode = nbt.func_74779_i("mode");
            if (nbt.func_74779_i("mode").equals("") || !this.armor.getSkinsList().contains(mode)) {
                return ItemSpecialArmor.getModelLocation1(name, "");
            }
            return ItemSpecialArmor.getModelLocation1(name + "_" + mode.toLowerCase(), "");
        });
        for (String s : mode = new String[]{"", "_Zelen", "_Demon", "_Dark", "_Cold", "_Ender", "_Ukraine", "_Fire", "_Snow", "_Taiga", "_Desert", "_Emerald"}) {
            if (s.equals("")) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemSpecialArmor.getModelLocation1(name, s)});
                continue;
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemSpecialArmor.getModelLocation1(name + s.toLowerCase(), "")});
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int suffix = this.field_77881_a == EntityEquipmentSlot.LEGS ? 2 : 1;
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        String mode = nbtData.func_74779_i("mode");
        if (!mode.isEmpty() && this.armor.getSkinsList().contains(mode)) {
            if (suffix == 1) {
                return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_" + mode.toLowerCase() + "_1.png";
            }
            return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_" + mode.toLowerCase() + "_2.png";
        }
        if (suffix == 1) {
            return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_1.png";
        }
        return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_2.png";
    }

    @SubscribeEvent
    public void Potion(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        NBTTagCompound nbtData = player.getEntityData();
        if (!((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77973_b() == this && this.listCapability.contains((Object)EnumCapability.AUTO_JUMP)) {
            nbtData.func_74757_a("stepHeight", true);
            player.field_70138_W = 1.0f;
        } else if (nbtData.func_74767_n("stepHeight")) {
            player.field_70138_W = 0.5f;
            nbtData.func_74757_a("stepHeight", false);
        }
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void onArmorTick(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull ItemStack itemStack) {
        int repaired;
        NBTTagCompound nbtData = ModUtils.nbt(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        int resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
        int n = repaired = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.REPAIRED, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.REPAIRED, (ItemStack)itemStack).number : 0;
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 300));
        }
        if (repaired != 0 && world.field_73011_w.getWorldTime() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxEnergy(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, resistance));
        }
        switch (this.field_77881_a) {
            case HEAD: {
                ArrayList effects = new ArrayList(player.func_70651_bq());
                for (PotionEffect effect : effects) {
                    Integer cost = this.potionRemovalCost.get(effect.func_188419_a());
                    if (cost == null || !ElectricItem.manager.canUse(itemStack, (cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
                    ElectricItem.manager.use(itemStack, cost.intValue(), null);
                    IUCore.proxy.removePotion((EntityLivingBase)player, effect.func_188419_a());
                }
                boolean Nightvision = nbtData.func_74767_n("Nightvision");
                if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = Nightvision = !Nightvision;
                    if (IUCore.proxy.isSimulating()) {
                        nbtData.func_74757_a("Nightvision", Nightvision);
                        if (Nightvision) {
                            IUCore.proxy.messagePlayer(player, "Nightvision enabled.", new Object[0]);
                        } else {
                            IUCore.proxy.messagePlayer(player, "Nightvision disabled.", new Object[0]);
                        }
                    }
                }
                if (IUCore.proxy.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (Nightvision && IUCore.proxy.isSimulating() && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
                    int x = MathHelper.func_76128_c((double)player.field_70165_t);
                    int z = MathHelper.func_76128_c((double)player.field_70161_v);
                    int y = MathHelper.func_76128_c((double)player.field_70163_u);
                    int skylight = player.func_130014_f_().func_175671_l(new BlockPos(x, y, z));
                    boolean with = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITH);
                    boolean without = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITHOUT);
                    if (without || with) {
                        if (skylight > 8) {
                            IUCore.proxy.removePotion((EntityLivingBase)player, MobEffects.field_76439_r);
                            if (with) {
                                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, true));
                            }
                        } else {
                            if (with) {
                                IUCore.proxy.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                            }
                            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0));
                        }
                    } else {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0));
                    }
                    ret = true;
                }
                if (this.listCapability.contains((Object)EnumCapability.FOOD) && ElectricItem.manager.canUse(itemStack, 1000.0) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                        if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !(((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() instanceof ItemFood)) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
                        ItemFood can = (ItemFood)stack.func_77973_b();
                        if ((stack = can.func_77654_b(stack, world, (EntityLivingBase)player)).func_190916_E() <= 0) {
                            player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
                        }
                        ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
                        ret = true;
                    }
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WATER, itemStack)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 300));
                }
                if (!UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.NIGTHVISION, itemStack)) break;
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300));
                break;
            }
            case CHEST: {
                if (nbtData.func_74767_n("jetpack")) {
                    player.field_70143_R = 0.0f;
                    if (nbtData.func_74767_n("jump") && !nbtData.func_74767_n("canFly") && !player.field_71075_bZ.field_75101_c && IUCore.keyboard.isJumpKeyDown(player) && !nbtData.func_74767_n("isFlyActive") && toggleTimer == 0) {
                        toggleTimer = 10;
                        nbtData.func_74757_a("canFly", true);
                    }
                    nbtData.func_74757_a("jump", !player.field_70122_E);
                    if (!player.field_70122_E) {
                        if (ElectricItem.manager.canUse(itemStack, 45.0)) {
                            ElectricItem.manager.use(itemStack, 45.0, null);
                        } else {
                            nbtData.func_74757_a("jetpack", false);
                        }
                    }
                }
                boolean jetpack = nbtData.func_74767_n("jetpack");
                boolean vertical = nbtData.func_74767_n("vertical");
                if (this.listCapability.contains((Object)EnumCapability.VERTICAL_FLY) && IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = vertical = !vertical;
                    if (IUCore.proxy.isSimulating()) {
                        nbtData.func_74757_a("vertical", vertical);
                        if (vertical) {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info2"), new Object[0]);
                        } else {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info3"), new Object[0]);
                        }
                    }
                }
                if (vertical && jetpack) {
                    double motion = 0.0;
                    if (IUCore.keyboard.isJumpKeyDown(player)) {
                        motion = 0.3;
                    }
                    if (player.func_70093_af()) {
                        motion = -0.3;
                    }
                    player.field_70181_x += motion;
                }
                if (IUCore.keyboard.isStreakKeyDown(player) && toggleTimer == 0 && IUItem.spectral_chestplate == this) {
                    toggleTimer = 10;
                    player.openGui((Object)IUCore.instance, 4, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                }
                int reTimer = nbtData.func_74762_e("reTimer");
                if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY) && reTimer > 0) {
                    nbtData.func_74768_a("reTimer", --reTimer);
                }
                if ((this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) && IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && reTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = jetpack = !jetpack;
                    if (IUCore.proxy.isSimulating()) {
                        nbtData.func_74757_a("jetpack", jetpack);
                        if (jetpack) {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info"), new Object[0]);
                            if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                                nbtData.func_74768_a("timer", 600);
                            }
                        } else {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"), new Object[0]);
                        }
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                    jetpack = nbtData.func_74767_n("jetpack");
                    int timer = nbtData.func_74762_e("timer");
                    if (timer > 0) {
                        nbtData.func_74768_a("timer", --timer);
                    } else if (jetpack) {
                        nbtData.func_74757_a("jetpack", false);
                        nbtData.func_74768_a("reTimer", 6000);
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"), new Object[0]);
                    }
                    boolean jetpackUsed = false;
                    if (!jetpack && IUCore.keyboard.isJumpKeyDown(player)) {
                        jetpackUsed = this.useJetpack(player);
                    }
                    if (IUCore.proxy.isRendering() && player == IUCore.proxy.getPlayerInstance()) {
                        if (this.lastJetpackUsed != jetpackUsed) {
                            if (jetpackUsed) {
                                SoundHandler.playSound(player, "JetpackLoop");
                            }
                            this.lastJetpackUsed = jetpackUsed;
                            if (!this.lastJetpackUsed) {
                                SoundHandler.stopSound(EnumSound.JetpackLoop);
                            }
                        }
                        Random rnd = world.field_73012_v;
                        if (jetpackUsed) {
                            int i;
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)(player.field_70165_t - player.field_70159_w) + rnd.nextFloat()), (double)((float)player.field_70163_u), (double)((float)(player.field_70161_v - player.field_70179_y) + rnd.nextFloat()), 0.0, -0.25, 0.0, new int[0]);
                            }
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)(player.field_70165_t - player.field_70159_w) + rnd.nextFloat()), (double)((float)player.field_70163_u), (double)((float)(player.field_70161_v - player.field_70179_y) + rnd.nextFloat()), 0.0, -0.25, 0.0, new int[0]);
                            }
                        }
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.JETPACK)) {
                    boolean jetpackUsed = false;
                    if (!jetpack && IUCore.keyboard.isJumpKeyDown(player)) {
                        jetpackUsed = this.useJetpack(player);
                    }
                    if (IUCore.proxy.isRendering() && player == IUCore.proxy.getPlayerInstance()) {
                        if (this.lastJetpackUsed != jetpackUsed) {
                            if (jetpackUsed) {
                                SoundHandler.playSound(player, "JetpackLoop");
                            }
                            this.lastJetpackUsed = jetpackUsed;
                            if (!this.lastJetpackUsed) {
                                SoundHandler.stopSound(EnumSound.JetpackLoop);
                            }
                        }
                        Random rnd = world.field_73012_v;
                        if (jetpackUsed) {
                            int i;
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)(player.field_70165_t - player.field_70159_w) + rnd.nextFloat()), (double)((float)player.field_70163_u), (double)((float)(player.field_70161_v - player.field_70179_y) + rnd.nextFloat()), 0.0, -0.25, 0.0, new int[0]);
                            }
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)(player.field_70165_t - player.field_70159_w) + rnd.nextFloat()), (double)((float)player.field_70163_u), (double)((float)(player.field_70161_v - player.field_70179_y) + rnd.nextFloat()), 0.0, -0.25, 0.0, new int[0]);
                            }
                        }
                    }
                }
                if (IUCore.proxy.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 300));
                }
                player.func_70066_B();
                break;
            }
            case LEGS: {
                if (this.listCapability.contains((Object)EnumCapability.SPEED) && ElectricItem.manager.canUse(itemStack, 1000.0) && (player.field_70122_E || player.func_70090_H()) && IUCore.keyboard.isForwardKeyDown(player)) {
                    byte speedTicker = nbtData.func_74771_c("speedTicker");
                    if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(itemStack, 1000.0, null);
                        ret = true;
                    }
                    nbtData.func_74774_a("speedTicker", speedTicker);
                    float speed = 0.22f;
                    if (player.func_70090_H()) {
                        speed = 0.1f;
                        if (IUCore.keyboard.isJumpKeyDown(player)) {
                            player.field_70181_x += (double)0.1f;
                        }
                    }
                    player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                }
                if (this.listCapability.contains((Object)EnumCapability.BAGS) && IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isBootsMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    if (IUCore.proxy.isSimulating()) {
                        this.save(itemStack, player);
                        player.openGui((Object)IUCore.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.MAGNET)) {
                    int mode;
                    boolean magnet;
                    boolean bl = magnet = !nbtData.func_74767_n("magnet");
                    if (IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isChangeKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        if (IUCore.proxy.isSimulating()) {
                            if (magnet) {
                                IUCore.proxy.messagePlayer(player, "Magnet enabled.", new Object[0]);
                            }
                            if (!magnet) {
                                IUCore.proxy.messagePlayer(player, "Magnet disabled.", new Object[0]);
                            }
                            nbtData.func_74757_a("magnet", magnet);
                        }
                    }
                    if (IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isSaveModeKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        if (IUCore.proxy.isSimulating()) {
                            int mode2 = ModUtils.NBTGetInteger(itemStack, "mode1");
                            if (++mode2 > 2 || mode2 < 0) {
                                mode2 = 0;
                            }
                            ModUtils.NBTSetInteger(itemStack, "mode1", mode2);
                            IUCore.proxy.messagePlayer(player, TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode2), new Object[0]);
                        }
                    }
                    if ((mode = ModUtils.NBTGetInteger(itemStack, "mode1")) != 0) {
                        int radius = 11;
                        AxisAlignedBB axisalignedbb = new AxisAlignedBB(player.field_70165_t - (double)radius, player.field_70163_u - (double)radius, player.field_70161_v - (double)radius, player.field_70165_t + (double)radius, player.field_70163_u + (double)radius, player.field_70161_v + (double)radius);
                        List list = player.func_130014_f_().func_72839_b((Entity)player, axisalignedbb);
                        boolean ret1 = false;
                        for (Entity entityinlist : list) {
                            boolean zcoord;
                            if (!(entityinlist instanceof EntityItem)) continue;
                            EntityItem item = (EntityItem)entityinlist;
                            if (!ElectricItem.manager.canUse(itemStack, 200.0)) continue;
                            if (mode == 1) {
                                item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                                if (!player.field_70170_p.field_72995_K) {
                                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                                }
                                item.func_174867_a(0);
                                ElectricItem.manager.use(itemStack, 200.0, null);
                                ret1 = true;
                                continue;
                            }
                            if (mode != 2) continue;
                            boolean xcoord = item.field_70165_t + 2.0 >= player.field_70165_t && item.field_70165_t - 2.0 <= player.field_70165_t;
                            boolean bl2 = zcoord = item.field_70161_v + 2.0 >= player.field_70161_v && item.field_70161_v - 2.0 <= player.field_70161_v;
                            if (xcoord || zcoord) continue;
                            item.func_70107_b(player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v);
                            item.func_174867_a(10);
                        }
                        if (ret1) {
                            player.field_71069_bz.func_75142_b();
                        }
                    }
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SPEED, itemStack)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 300));
                }
                if (!IUCore.proxy.isSimulating() || toggleTimer <= 0) break;
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.func_74774_a("toggleTimer", toggleTimer);
                break;
            }
            case FEET: {
                if (IUCore.proxy.isSimulating()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = !nbtData.func_74764_b("wasOnGround") || nbtData.func_74767_n("wasOnGround");
                    if (wasOnGround && !player.field_70122_E && IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isChangeKeyDown(player)) {
                        ElectricItem.manager.use(itemStack, 4000.0, null);
                        ret = true;
                    }
                    if (player.field_70122_E != wasOnGround) {
                        nbtData.func_74757_a("wasOnGround", player.field_70122_E);
                    }
                } else {
                    if (ElectricItem.manager.canUse(itemStack, 4000.0) && player.field_70122_E) {
                        this.jumpCharge = 1.0f;
                    }
                    if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                        if (IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isBootsMode(player)) {
                            if (this.jumpCharge == 1.0f) {
                                player.field_70159_w *= 3.5;
                                player.field_70179_y *= 3.5;
                            }
                            player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                        } else if (this.jumpCharge < 1.0f) {
                            this.jumpCharge = 0.0f;
                        }
                    }
                }
                if (!UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.JUMP, itemStack)) break;
                player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 300));
            }
        }
        if (ret) {
            player.field_71070_bA.func_75142_b();
        }
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack));
    }

    public void save(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74757_a("open", true);
        nbt.func_74768_a("slot_inventory", player.field_71071_by.field_70461_c);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, EntityPlayer player) {
        ItemStackBags toolbox;
        if (!player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(stack) && player.field_71070_bA instanceof ContainerBags && (toolbox = (ItemStackBags)((ContainerBags)player.field_71070_bA).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.func_71053_j();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World worldIn, @Nonnull List<String> info, @Nonnull ITooltipFlag flagIn) {
        NBTTagCompound nbtData = ModUtils.nbt(itemStack);
        if (this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
            info.add(Localization.translate("iu.fly") + " " + ModUtils.Boolean(nbtData.func_74767_n("jetpack")));
        }
        if (!Keyboard.isKeyDown((int)42)) {
            info.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            NBTTagCompound nbt;
            boolean with = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITH);
            boolean without = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITHOUT);
            boolean auto = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_AUTO);
            if (this.listCapability.contains((Object)EnumCapability.SPEED)) {
                info.add(Localization.translate("iu.special_armor_speed"));
            }
            if (with || without || auto) {
                info.add(Localization.translate("iu.special_armor_nightvision") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.armormode.func_151463_i())));
                if (with) {
                    info.add(Localization.translate("iu.special_armor_nightvision_1"));
                }
                if (without) {
                    info.add(Localization.translate("iu.special_armor_nightvision_2"));
                }
                if (auto) {
                    info.add(Localization.translate("iu.special_armor_nightvision_3"));
                }
            }
            if (this.listCapability.contains((Object)EnumCapability.BIG_JUMP)) {
                info.add(Localization.translate("iu.special armor big jump") + Keyboard.getKeyName((int)Math.abs(57)) + " + " + Keyboard.getKeyName((int)Math.abs(KeyboardClient.bootsmode.func_151463_i())));
            }
            if (this.listCapability.contains((Object)EnumCapability.AUTO_JUMP)) {
                info.add(Localization.translate("iu.special_armor_auto_jump"));
            }
            if (this.listCapability.contains((Object)EnumCapability.ACTIVE_EFFECT)) {
                info.add(Localization.translate("iu.special_armor_active_effect"));
            }
            if (this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
                info.add(Localization.translate("iu.special_armor_all_active_effect"));
            }
            if (this.listCapability.contains((Object)EnumCapability.BAGS)) {
                info.add("Open bag: " + Keyboard.getKeyName((int)Math.abs(KeyboardClient.bootsmode.func_151463_i())) + " + " + Keyboard.getKeyName((int)Math.abs(KeyboardClient.leggingsmode.func_151463_i())));
                nbt = ModUtils.nbt(itemStack);
                if (nbt.func_74764_b("bag")) {
                    ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
                    NBTTagCompound nbt1 = nbt.func_74775_l("bag");
                    int size = nbt1.func_74762_e("size");
                    for (int i = 0; i < size; ++i) {
                        list.add(new BagsDescription(nbt1.func_74775_l(String.valueOf(i))));
                    }
                    for (BagsDescription description : list) {
                        info.add(TextFormatting.GREEN + "" + description.getCount() + "x " + description.getStack().func_82833_r());
                    }
                }
            }
            if (this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                info.add(Localization.translate("iu.fly_need"));
                info.add(Localization.translate("iu.changemode_fly") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.flymode.func_151463_i())));
            }
            if (this.listCapability.contains((Object)EnumCapability.VERTICAL_FLY)) {
                info.add(Localization.translate("iu.vertical") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.verticalmode.func_151463_i())));
            }
            if (this.listCapability.contains((Object)EnumCapability.FOOD)) {
                info.add(Localization.translate("iu.food_mode_helmet"));
            }
            if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                String time3;
                String time2;
                String time1;
                double seconds;
                double minutes;
                info.add(Localization.translate("iu.jetpack_fly_chestplate"));
                nbt = ModUtils.nbt(itemStack);
                int reTimer = nbt.func_74762_e("reTimer");
                int timer = nbt.func_74762_e("timer");
                if (timer > 0) {
                    List<Double> time = ModUtils.Time((double)timer / 20.0);
                    double hours = 0.0;
                    minutes = 0.0;
                    seconds = 0.0;
                    if (time.size() > 0) {
                        hours = time.get(0);
                        minutes = time.get(1);
                        seconds = time.get(2);
                    }
                    time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") + "" : "";
                    time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") + "" : "";
                    time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") + "" : "";
                    info.add(Localization.translate("iu.timetoend") + time1 + time2 + time3 + " " + Localization.translate("iu.jetpack_fly_chestplate_2"));
                }
                if (reTimer > 0) {
                    List<Double> time = ModUtils.Time((double)reTimer / 20.0);
                    double hours = 0.0;
                    minutes = 0.0;
                    seconds = 0.0;
                    if (time.size() > 0) {
                        hours = time.get(0);
                        minutes = time.get(1);
                        seconds = time.get(2);
                    }
                    time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") + "" : "";
                    time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") + "" : "";
                    time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") + "" : "";
                    info.add(Localization.translate("iu.timetoend") + time1 + time2 + time3 + " " + Localization.translate("iu.jetpack_fly_chestplate_1"));
                }
            }
            if (itemStack.func_77973_b() == IUItem.spectral_chestplate) {
                info.add(Localization.translate("iu.streak") + Keyboard.getKeyName((int)KeyboardClient.streakmode.func_151463_i()));
            }
            if (this.listCapability.contains((Object)EnumCapability.MAGNET)) {
                info.add(Localization.translate("iu.magnet_mode") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.changemode.func_151463_i())) + " + " + Keyboard.getKeyName((int)Math.abs(KeyboardClient.leggingsmode.func_151463_i())));
                info.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.leggingsmode.func_151463_i())) + " + " + Keyboard.getKeyName((int)Math.abs(KeyboardClient.savemode.func_151463_i())));
                int mode = ModUtils.NBTGetInteger(itemStack, "mode1");
                if (mode > 2 || mode < 0) {
                    mode = 0;
                }
                info.add(TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode));
            }
        }
        ModUtils.mode(itemStack, info);
    }

    public boolean useJetpack(EntityPlayer player) {
        ItemStack jetpack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = true;
        float power = 0.7f;
        float dropPercentage = 0.05f;
        if (this.getCharge(jetpack) / this.getMaxEnergy(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxEnergy(jetpack) * (double)dropPercentage)));
        }
        if (IUCore.keyboard.isForwardKeyDown(player)) {
            float retruster = 0.15f;
            float forwardpower = power * (retruster += 0.15f) * 2.0f;
            if (forwardpower > 0.0f) {
                player.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        int worldHeight = player.func_130014_f_().func_72800_K();
        double y = player.field_70163_u;
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        int consume = 2;
        consume += 6;
        if (!player.field_70122_E) {
            this.use(jetpack, consume);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        return true;
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IUCore.proxy.isSimulating() && event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            ItemStack armor = entity.func_184582_a(EntityEquipmentSlot.FEET);
            if (armor.func_77973_b() == this) {
                int fallDamage = Math.max((int)event.getDistance() - 10, 0);
                double energyCost = this.armor.getDamageEnergy() * (double)fallDamage * (1.0 - (double)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FALLING_DAMAGE, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FALLING_DAMAGE, (ItemStack)armor).number : 0) * 0.25);
                if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                    ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                    event.setCanceled(true);
                }
            }
            if (entity instanceof EntityPlayer && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == this && entity.getEntityData().func_74767_n("isFlyActive")) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack var1) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack var1) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack var1) {
        return this.transferLimit;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a.func_188454_b() == 3) {
            int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
            int energyPerDamage = (int)(this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect);
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int energyPerDamage = (int)(this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(10, absorptionRatio, damageLimit);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return ElectricItem.manager.getCharge(armor) >= this.armor.getDamageEnergy() ? (int)Math.round(40.0 * this.getBaseAbsorptionRatio()) : 0;
    }

    private double getBaseAbsorptionRatio() {
        switch (this.field_77881_a) {
            case FEET: {
                return this.armor.getArmorMulDamage().getBootsMul();
            }
            case HEAD: {
                return this.armor.getArmorMulDamage().getHeadMul();
            }
            case CHEST: {
                return this.armor.getArmorMulDamage().getChestMul();
            }
            case LEGS: {
                return this.armor.getArmorMulDamage().getLeggingsMul();
            }
        }
        return 1.0;
    }

    public void damageArmor(EntityLivingBase entity, @NotNull ItemStack stack, DamageSource source, int damage, int slot) {
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)stack).number : 0;
        ElectricItem.manager.discharge(stack, (double)damage * (this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public IAdvInventory getInventory(EntityPlayer player, ItemStack stack) {
        return new ItemStackLegsBags(player, stack);
    }
}

