/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IHazmatLike;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.register.Register;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorAdvHazmat
extends ItemArmor
implements IHazmatLike,
IModelRegister,
ISpecialArmor {
    private final String name;

    public ItemArmorAdvHazmat(String name, EntityEquipmentSlot type) {
        super(ItemArmor.ArmorMaterial.DIAMOND, -1, type);
        this.func_77656_e(64);
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.func_77637_a(IUCore.EnergyTab);
        this.name = name;
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
    }

    public static boolean hasCompleteHazmat(EntityLivingBase living) {
        ItemStack stack;
        EntityEquipmentSlot slot2;
        IHazmatLike hazmat;
        Iterator var1 = Arrays.stream(EntityEquipmentSlot.values()).filter(slot -> slot != EntityEquipmentSlot.MAINHAND && slot != EntityEquipmentSlot.OFFHAND).iterator();
        do {
            if (!var1.hasNext()) {
                return true;
            }
            slot2 = (EntityEquipmentSlot)var1.next();
            stack = living.func_184582_a(slot2);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IHazmatLike)) {
                return false;
            }
            hazmat = (IHazmatLike)stack.func_77973_b();
            if (hazmat.addsProtection(living, slot2, stack)) continue;
            return false;
        } while (!hazmat.fullyProtects(living, slot2, stack));
        return true;
    }

    public static boolean hazmatAbsorbs(DamageSource source) {
        return source == DamageSource.field_76372_a || source == DamageSource.field_76368_d || source == DamageSource.field_76371_c || source == DamageSource.field_190095_e || source == DamageSource.field_76370_b || source == IUDamageSource.radiation;
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name) {
        String loc = "industrialupgrade:armour/" + name;
        return new ModelResourceLocation(loc, null);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(@Nonnull ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return false;
    }

    public String getArmorTexture(@Nonnull ItemStack stack, @Nonnull Entity entity, @Nonnull EntityEquipmentSlot slot, @Nonnull String type) {
        int suffix = this.field_77881_a.func_188452_c() == 2 ? 2 : 1;
        return "industrialupgrade:textures/armor/" + this.name + "_" + suffix + ".png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && ItemArmorAdvHazmat.hazmatAbsorbs(source) && ItemArmorAdvHazmat.hasCompleteHazmat(player)) {
            if (source == DamageSource.field_76372_a || source == DamageSource.field_76371_c || source == DamageSource.field_190095_e) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 1));
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        return this.field_77881_a == EntityEquipmentSlot.FEET && source == DamageSource.field_76379_h ? new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, (armor.func_77958_k() - armor.func_77952_i() + 2) * 2 * 25) : new ISpecialArmor.ArmorProperties(0, 0.05, (armor.func_77958_k() - armor.func_77952_i() + 2) / 2 * 25);
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        if (!ItemArmorAdvHazmat.hazmatAbsorbs(source) || !ItemArmorAdvHazmat.hasCompleteHazmat(entity)) {
            int damageTotal = damage * 2;
            if (this.field_77881_a == EntityEquipmentSlot.FEET && source == DamageSource.field_76379_h) {
                damageTotal = (damage + 1) / 2;
            }
            stack.func_77972_a(damageTotal, entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IUCore.proxy.isSimulating() && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(0);
            if (!armor.func_190926_b() && armor.func_77973_b() == this) {
                int fallDamage = (int)event.getDistance() - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int armorDamage = (fallDamage + 1) / 2;
                if (armorDamage <= armor.func_77958_k() - armor.func_77952_i() && armorDamage >= 0) {
                    armor.func_77972_a(armorDamage, (EntityLivingBase)player);
                    event.setCanceled(true);
                }
            }
        }
    }

    public boolean isRepairable() {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 1;
    }

    public void onArmorTick(World world, @Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        if (!world.field_72995_K && this.field_77881_a == EntityEquipmentSlot.HEAD && player.func_70027_ad() && ItemArmorAdvHazmat.hasCompleteHazmat((EntityLivingBase)player)) {
            if (this.isInLava(player)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 20, 0, true, true));
            }
            player.func_70066_B();
        }
    }

    public boolean isInLava(EntityPlayer player) {
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)Math.floor(player.field_70163_u + 0.02);
        int z = (int)Math.floor(player.field_70161_v);
        IBlockState state = player.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
        if (state.func_177230_c() instanceof BlockLiquid && (state.func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151581_o)) {
            float height = (float)(y + 1) - BlockLiquid.func_149801_b((int)((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
            return player.field_70163_u < (double)height;
        }
        return false;
    }

    @Override
    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getLevel() {
        return 2;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return false;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> ItemArmorAdvHazmat.getModelLocation1(name));
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemArmorAdvHazmat.getModelLocation1(name)});
    }
}

