/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemAdvJetpack
extends ItemArmorEnergy
implements IEnergyItem,
IModelRegister,
ISpecialArmor,
IUpgradeItem {
    private static boolean lastJetpackUsed = false;
    private final String armorName;
    private final double maxStorage;
    private final double TransferLimit;
    private final int tier;

    public ItemAdvJetpack(String name, double maxStorage, double TransferLimit, int tier) {
        super("", EntityEquipmentSlot.CHEST, maxStorage, TransferLimit, tier);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(name);
        this.armorName = name;
        this.func_77637_a(IUCore.EnergyTab);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.maxStorage = maxStorage;
        this.TransferLimit = TransferLimit;
        this.tier = tier;
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.JETPACK.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:armour/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(worldIn, this, stack));
        }
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World p_77624_2_, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag p_77624_4_) {
        super.func_77624_a(stack, p_77624_2_, tooltip, p_77624_4_);
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, stack)) {
            tooltip.add(Localization.translate("iu.fly") + " " + ModUtils.Boolean(nbtData.func_74767_n("jetpack")));
            tooltip.add(Localization.translate("iu.fly_need"));
            if (!Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("iu.changemode_fly") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.flymode.func_151463_i())));
            }
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.4;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public String func_77658_a() {
        return super.func_77658_a().substring(3) + ".name";
    }

    @Override
    public void registerModels() {
        this.registerModels(this.armorName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            return ItemAdvJetpack.getModelLocation1(name, nbt.func_74779_i("mode"));
        });
        for (String s : mode = new String[]{"", "Demon", "Dark", "Cold", "Ender"}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemAdvJetpack.getModelLocation1(name, s)});
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int suffix = this.field_77881_a == EntityEquipmentSlot.LEGS ? 2 : 1;
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (!nbtData.func_74779_i("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/" + this.armorName + "_" + nbtData.func_74779_i("mode") + "_" + suffix + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.armorName + "_" + suffix + ".png";
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @Override
    public String func_77653_i(ItemStack itemStack) {
        return Localization.translate(this.func_77667_c(itemStack));
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        ItemStack jetpack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = true;
        float power = 1.0f;
        float dropPercentage = 0.2f;
        power = 0.7f;
        dropPercentage = 0.05f;
        if (this.getCharge(jetpack) / this.getMaxEnergy(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxEnergy(jetpack) * (double)dropPercentage)));
        }
        if (IUCore.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 1.0f;
            }
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        int worldHeight = player.func_130014_f_().func_72800_K();
        double y = player.field_70163_u;
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IUCore.keyboard.isJumpKeyDown(player)) {
                maxHoverY = electric ? 0.1f : 0.2f;
            }
            if (IUCore.keyboard.isSneakKeyDown(player)) {
                maxHoverY = electric ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        if (electric) {
            consume += 6;
        }
        if (!player.field_70122_E) {
            this.use(jetpack, consume);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxStorage;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.TransferLimit;
    }

    @Override
    public void func_150895_a(CreativeTabs p_150895_1_, NonNullList<ItemStack> var3) {
        if (this.func_194125_a(p_150895_1_)) {
            ItemStack var4 = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            var3.add((Object)var4);
            var3.add((Object)new ItemStack((Item)this, 1, 27));
        }
    }

    public void onArmorTick(@Nonnull World world, EntityPlayer player, @Nonnull ItemStack itemStack) {
        if (((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77969_a(itemStack)) {
            int resistance;
            boolean fireResistance;
            NBTTagCompound nbtData = ModUtils.nbt(itemStack);
            boolean hoverMode = nbtData.func_74767_n("hoverMode");
            byte toggleTimer = nbtData.func_74771_c("toggleTimer");
            boolean jetpackUsed = false;
            if (IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                toggleTimer = 10;
                boolean bl = hoverMode = !hoverMode;
                if (IUCore.proxy.isSimulating()) {
                    nbtData.func_74757_a("hoverMode", hoverMode);
                    if (hoverMode) {
                        IUCore.proxy.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                    } else {
                        IUCore.proxy.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                    }
                }
            }
            if (nbtData.func_74767_n("jetpack")) {
                player.field_70143_R = 0.0f;
                if (nbtData.func_74767_n("jump") && !nbtData.func_74767_n("canFly") && !player.field_71075_bZ.field_75101_c && IUCore.keyboard.isJumpKeyDown(player) && !nbtData.func_74767_n("isFlyActive") && toggleTimer == 0) {
                    toggleTimer = 10;
                    nbtData.func_74757_a("canFly", true);
                }
                nbtData.func_74757_a("jump", !player.field_70122_E);
                if (!player.field_70122_E) {
                    if (ElectricItem.manager.canUse(itemStack, 25.0)) {
                        ElectricItem.manager.use(itemStack, 25.0, null);
                    } else {
                        nbtData.func_74757_a("jetpack", false);
                    }
                }
            }
            boolean jetpack = nbtData.func_74767_n("jetpack");
            if ((IUCore.keyboard.isJumpKeyDown(player) || hoverMode) && !jetpack) {
                jetpackUsed = this.useJetpack(player, hoverMode);
            }
            if (IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, itemStack)) {
                toggleTimer = 10;
                boolean bl = jetpack = !jetpack;
                if (IUCore.proxy.isSimulating()) {
                    nbtData.func_74757_a("jetpack", jetpack);
                    if (jetpack) {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info"), new Object[0]);
                    } else {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"), new Object[0]);
                    }
                }
            }
            if (IUCore.proxy.isSimulating() && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.func_74774_a("toggleTimer", toggleTimer);
            }
            if (IUCore.proxy.isRendering() && player == IUCore.proxy.getPlayerInstance()) {
                if (lastJetpackUsed != jetpackUsed) {
                    if (jetpackUsed) {
                        SoundHandler.playSound(player, "JetpackLoop");
                    }
                    if (!(lastJetpackUsed = jetpackUsed)) {
                        SoundHandler.stopSound(EnumSound.JetpackLoop);
                    }
                }
                Random rnd = world.field_73012_v;
                if (jetpackUsed) {
                    int i;
                    for (i = 0; i < rnd.nextInt(10); ++i) {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)(player.field_70165_t - player.field_70159_w) + rnd.nextFloat()), (double)((float)player.field_70163_u), (double)((float)(player.field_70161_v - player.field_70179_y) + rnd.nextFloat()), 0.0, -0.25, 0.0, new int[0]);
                    }
                    for (i = 0; i < rnd.nextInt(10); ++i) {
                        world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)(player.field_70165_t - player.field_70159_w) + rnd.nextFloat()), (double)((float)player.field_70163_u), (double)((float)(player.field_70161_v - player.field_70179_y) + rnd.nextFloat()), 0.0, -0.25, 0.0, new int[0]);
                    }
                }
            }
            if (fireResistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 300));
            }
            int n = resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
            if (resistance != 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, resistance));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 300));
            }
            if (jetpackUsed) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }
}

