/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.api.windsystem.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.windsystem.upgrade.IRotorUpgradeItem;
import com.denfop.api.windsystem.upgrade.RotorUpgradeItemInform;
import com.denfop.api.windsystem.upgrade.RotorUpgradeSystem;
import com.denfop.api.windsystem.upgrade.event.EventRotorItemLoad;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWindRotor
extends ItemDamage
implements IWindRotor,
IRotorUpgradeItem {
    private final int radius;
    private final float efficiency;
    private final ResourceLocation renderTexture;
    private final int level;
    private final int index;
    private final int tier;

    public ItemWindRotor(String name, int Radius, int durability, float efficiency, ResourceLocation RenderTexture, int level, int index) {
        super(name, durability);
        this.func_77637_a(IUCore.ItemTab);
        this.func_77625_d(1);
        this.radius = Radius;
        this.efficiency = efficiency;
        this.renderTexture = RenderTexture;
        this.level = level;
        this.index = index;
        double KU1 = 20.0f * efficiency * 27.0f;
        this.tier = EnergyNetGlobal.instance.getTierFromPower(KU1);
        IInputHandler input = Recipes.inputFactory;
        for (int i = 0; i < EnumInfoRotorUpgradeModules.values().length; ++i) {
            Recipes.recipes.addRecipe("rotor_upgrade", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)this, 1, 0)), input.getInput(new ItemStack((Item)IUItem.rotors_upgrade, 1, i))), new RecipeOutput(null, new ItemStack((Item)this, 1, 0))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:rotor/" + name;
        return new ModelResourceLocation(loc, null);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item", "iu"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemWindRotor.getModelLocation(name));
    }

    @Override
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            this.setCustomDamage(stack, this.getMaxCustomDamage(stack));
            subItems.add((Object)stack);
        }
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!RotorUpgradeSystem.instance.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventRotorItemLoad(world, this, itemStack));
        }
        if (this.getMaxCustomDamage(itemStack) != nbt.func_74762_e("maxDamage")) {
            nbt.func_74768_a("maxDamage", this.getMaxCustomDamage(itemStack));
            this.setCustomDamage(itemStack, this.getMaxCustomDamage(itemStack));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        this.registerModel(this, meta, name);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        this.registerModel(this, meta, name);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - (double)this.getCustomDamage(stack) / ((double)this.getMaxCustomDamage(stack) * 1.0), 0.0), 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<String> tooltip, @Nonnull ITooltipFlag advanced) {
        int windStrength = 10;
        int windStrength1 = 20;
        double KU = (float)windStrength * this.getEfficiency(stack) * 27.0f;
        double KU1 = (float)windStrength1 * this.getEfficiency(stack) * 27.0f;
        tooltip.add(Localization.translate("iu.windgenerator") + windStrength + " m/s " + Localization.translate("iu.windgenerator1") + ModUtils.getString(KU));
        tooltip.add(Localization.translate("iu.windgenerator") + windStrength1 + " m/s " + Localization.translate("iu.windgenerator1") + ModUtils.getString(KU1));
        tooltip.add(Localization.translate("gui.iu.tier") + ": " + this.getLevel());
        double hours = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        List<Double> time = ModUtils.Time(this.getCustomDamage(stack));
        if (time.size() > 0) {
            hours = time.get(0);
            minutes = time.get(1);
            seconds = time.get(2);
        }
        String time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") + "" : "";
        String time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") + "" : "";
        String time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") + "" : "";
        tooltip.add(Localization.translate("iu.timetoend") + time1 + time2 + time3);
        if (RotorUpgradeSystem.instance.hasInMap(stack)) {
            List<RotorUpgradeItemInform> lst = RotorUpgradeSystem.instance.getInformation(stack);
            int col = RotorUpgradeSystem.instance.getRemaining(stack);
            if (!lst.isEmpty()) {
                for (RotorUpgradeItemInform upgrade : lst) {
                    tooltip.add(upgrade.getName());
                }
            }
            if (col != 0) {
                tooltip.add(Localization.translate("free_slot") + col + Localization.translate("free_slot1"));
            } else {
                tooltip.add(Localization.translate("not_free_slot"));
            }
        }
    }

    @Override
    public int getDiameter(ItemStack stack) {
        return this.radius;
    }

    @Override
    public ResourceLocation getRotorRenderTexture(ItemStack stack) {
        return this.renderTexture;
    }

    @Override
    public float getEfficiency(ItemStack stack) {
        return this.efficiency;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }
}

