/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.Redstone;
import com.denfop.invslot.HandlerInventory;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InvSlotUpgrade
extends InvSlot {
    private final TileEntityInventory tile;
    private final Map<EnumFacing, HandlerInventory> iItemHandlerMap;
    private final Map<IItemHandler, Integer> slotHandler;
    private final EnumFacing[] enumFacings = EnumFacing.values();
    private final Map<EnumFacing, IFluidHandler> iFluidHandlerMap;
    private final Fluids fluids;
    private final List<Fluids.InternalFluidTank> fluidTankList = new ArrayList<Fluids.InternalFluidTank>();
    private final IItemHandler main_handler;
    public boolean isUpdate = false;
    public int extraProcessTime;
    public double processTimeMultiplier;
    public double extraEnergyDemand;
    public double energyDemandMultiplier;
    public double extraEnergyStorage;
    public double operationsPerTick;
    public double operationLength;
    public double energyConsume;
    public double energyStorageMultiplier;
    public int extraTier;
    public int tick = 0;
    public boolean update = false;
    List<InvSlotOutput> slots = new ArrayList<InvSlotOutput>();
    List<InvSlot> inv_slots = new ArrayList<InvSlot>();
    private EnumFacing[] facings;
    private boolean ejectorUpgrade;
    private boolean fluidEjectorUpgrade;
    private boolean pullingUpgrade;
    private boolean fluidPullingUpgrade;

    public InvSlotUpgrade(TileEntityInventory base, int count) {
        super(base, InvSlot.TypeItemSlot.INPUT, count);
        this.resetRates();
        this.facings = new EnumFacing[count];
        base.getInvSlots().forEach(slot -> {
            if (slot instanceof InvSlotOutput) {
                this.slots.add((InvSlotOutput)slot);
            }
        });
        base.getInvSlots().forEach(slot -> {
            if (slot.canInput()) {
                this.inv_slots.add((InvSlot)slot);
            }
        });
        this.main_handler = (IItemHandler)base.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, base.getFacing());
        this.fluids = base.getParent().getComp(Fluids.class);
        if (this.fluids != null) {
            this.fluids.getAllTanks().forEach(this.fluidTankList::add);
        }
        this.tile = base;
        this.slotHandler = new HashMap<IItemHandler, Integer>();
        this.iItemHandlerMap = new HashMap<EnumFacing, HandlerInventory>();
        this.iFluidHandlerMap = new HashMap<EnumFacing, IFluidHandler>();
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)base + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    private static EnumFacing getDirection(ItemStack stack) {
        byte rawDir = ModUtils.nbt(stack).func_74771_c("dir");
        return rawDir >= 1 && rawDir <= 6 ? EnumFacing.field_82609_l[rawDir - 1] : null;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        Item rawItem = stack.func_77973_b();
        if (!(rawItem instanceof IUpgradeItem)) {
            return false;
        }
        IUpgradeItem item = (IUpgradeItem)rawItem;
        return item.isSuitableFor(stack, ((IUpgradableBlock)((Object)this.base)).getUpgradableProperties());
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) {
                        if (!simulate) {
                            this.put(i, stack.func_77946_l());
                        }
                        return true;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        return true;
                    }
                    if (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void onChanged() {
        this.resetRates();
        IUpgradableBlock block = (IUpgradableBlock)((Object)this.base);
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (ModUtils.isEmpty(itemStack)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)itemStack.func_77973_b();
            int size = ModUtils.getSize(itemStack);
            this.extraProcessTime += size;
            this.processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(itemStack), size);
            this.extraEnergyDemand += (double)size;
            this.energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(itemStack), size);
            this.extraEnergyStorage += upgrade.getExtraEnergyStorage(itemStack) * (double)size;
            this.energyStorageMultiplier *= Math.pow(1.0, size);
            this.extraTier += upgrade.getExtraTier(itemStack) * size;
        }
        for (AbstractComponent abstractComponent : ((TileEntityInventory)this.base.getParent()).getComps()) {
            if (!(abstractComponent instanceof Redstone)) continue;
            Redstone rs = (Redstone)abstractComponent;
            rs.update();
        }
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (itemStack.func_77969_a(IUItem.ejectorUpgrade)) {
                this.ejectorUpgrade = true;
                this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                continue;
            }
            if (itemStack.func_77969_a(IUItem.fluidEjectorUpgrade)) {
                this.fluidEjectorUpgrade = true;
                this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                continue;
            }
            if (itemStack.func_77969_a(IUItem.pullingUpgrade)) {
                this.pullingUpgrade = true;
                this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                continue;
            }
            if (!itemStack.func_77969_a(IUItem.fluidpullingUpgrade)) continue;
            this.fluidPullingUpgrade = true;
            this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
        }
    }

    private void resetRates() {
        this.extraProcessTime = 0;
        this.processTimeMultiplier = 1.0;
        this.extraEnergyDemand = 0.0;
        this.energyDemandMultiplier = 1.0;
        this.extraEnergyStorage = 0.0;
        this.energyStorageMultiplier = 1.0;
        this.extraTier = 0;
        this.ejectorUpgrade = false;
        this.fluidEjectorUpgrade = false;
        this.fluidPullingUpgrade = false;
        this.pullingUpgrade = false;
        this.facings = new EnumFacing[this.size()];
    }

    public int getOperationsPerTick1(int defaultOperationLength) {
        if (this.isUpdate) {
            this.operationsPerTick = defaultOperationLength == 0 ? 64.0 : (double)this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
        }
        return (int)this.operationsPerTick;
    }

    public int getOperationLength1(int defaultOperationLength) {
        if (this.isUpdate) {
            if (defaultOperationLength == 0) {
                this.operationLength = 1.0;
            } else {
                double stackOpLen = this.getStackOpLen(defaultOperationLength);
                int opsPerTick = this.getOpsPerTick(stackOpLen);
                this.operationLength = Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
            }
        }
        return (int)this.operationLength;
    }

    public int getOperationsPerTick(int defaultOperationLength) {
        this.operationsPerTick = defaultOperationLength == 0 ? 64.0 : (double)this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
        return (int)this.operationsPerTick;
    }

    public int getOperationLength(int defaultOperationLength) {
        if (defaultOperationLength == 0) {
            this.operationLength = 1.0;
        } else {
            double stackOpLen = this.getStackOpLen(defaultOperationLength);
            int opsPerTick = this.getOpsPerTick(stackOpLen);
            this.operationLength = Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
        }
        return (int)this.operationLength;
    }

    private double getStackOpLen(int defaultOperationLength) {
        return ((double)defaultOperationLength + (double)this.extraProcessTime) * 64.0 * this.processTimeMultiplier;
    }

    private int getOpsPerTick(double stackOpLen) {
        return (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
    }

    public double getEnergyDemand(int defaultEnergyDemand) {
        return InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
    }

    public double getEnergyDemand(double defaultEnergyDemand) {
        this.energyConsume = InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
        return this.energyConsume;
    }

    public double getEnergyDemand1(double defaultEnergyDemand) {
        if (this.isUpdate) {
            this.energyConsume = InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
        }
        return this.energyConsume;
    }

    public double getEnergyStorage(int defaultEnergyStorage) {
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage, this.energyStorageMultiplier);
    }

    public double getEnergyStorage(double defaultEnergyStorage) {
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage, this.energyStorageMultiplier);
    }

    public int getTier(int defaultTier) {
        return InvSlotUpgrade.applyModifier(defaultTier, this.extraTier);
    }

    public boolean tickNoMark() {
        boolean ret = false;
        ++this.tick;
        if (this.tick % 20 == 0) {
            IItemHandler handler;
            TileEntity tile1;
            BlockPos pos;
            if (this.ejectorUpgrade || this.pullingUpgrade) {
                this.iItemHandlerMap.clear();
                this.slotHandler.clear();
                for (EnumFacing facing : this.enumFacings) {
                    pos = this.tile.func_174877_v().func_177972_a(facing);
                    tile1 = this.tile.func_145831_w().func_175625_s(pos);
                    handler = this.getItemHandler(tile1, facing.func_176734_d());
                    if (!(tile1 instanceof IInventory)) {
                        if (handler == null) {
                            this.iItemHandlerMap.put(facing, null);
                        } else {
                            this.iItemHandlerMap.put(facing, new HandlerInventory(handler, null));
                        }
                    } else {
                        this.iItemHandlerMap.put(facing, new HandlerInventory(handler, (IInventory)tile1));
                    }
                    if (handler == null) continue;
                    this.slotHandler.put(handler, handler.getSlots());
                }
            }
            if (this.fluidEjectorUpgrade || this.fluidPullingUpgrade) {
                this.iFluidHandlerMap.clear();
                for (EnumFacing facing : this.enumFacings) {
                    pos = this.tile.func_174877_v().func_177972_a(facing);
                    tile1 = this.tile.func_145831_w().func_175625_s(pos);
                    handler = this.getFluidHandler(tile1, facing.func_176734_d());
                    this.iFluidHandlerMap.put(facing, (IFluidHandler)handler);
                }
            }
            this.tick = 0;
        }
        boolean update = false;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (ModUtils.isEmpty(stack) || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            update = true;
            if (this.tick % 2 == 0 && stack.func_77969_a(IUItem.ejectorUpgrade)) {
                this.tick(i);
            } else if (this.tick % 2 == 0 && stack.func_77969_a(IUItem.fluidEjectorUpgrade)) {
                this.tick_fluid(i);
            } else if (this.tick % 4 == 0 && stack.func_77969_a(IUItem.pullingUpgrade)) {
                this.tickPullIn(i);
            } else if (this.tick % 4 == 0 && stack.func_77969_a(IUItem.fluidpullingUpgrade)) {
                this.tickPullIn_fluid(i);
            }
            ret = true;
        }
        if (this.update != update) {
            this.update = update;
            return true;
        }
        return ret;
    }

    private void tickPullIn_fluid(int i) {
        EnumFacing facing = this.facings[i];
        if (facing != null) {
            IFluidHandler handler = this.iFluidHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (this.fluids == null) {
                return;
            }
            if (handler.drain(Integer.MAX_VALUE, false) == null) {
                return;
            }
            for (IFluidTankProperties fluidTankProperties : handler.getTankProperties()) {
                if (fluidTankProperties.getContents() == null) continue;
                for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                    FluidStack fluid;
                    if (tank.getFluidAmount() >= tank.getCapacity() || (fluid = handler.drain(fluidTankProperties.getContents(), false)) == null || fluid.amount <= 0 || !tank.canFillFluidType(fluid)) continue;
                    tank.fill(handler.drain(fluidTankProperties.getContents(), true), true);
                }
            }
        } else {
            for (EnumFacing facing1 : this.enumFacings) {
                IFluidHandler handler = this.iFluidHandlerMap.get(facing1);
                if (handler == null || handler.drain(Integer.MAX_VALUE, false) == null) continue;
                if (this.fluids == null) {
                    return;
                }
                for (IFluidTankProperties fluidTankProperties : handler.getTankProperties()) {
                    if (fluidTankProperties.getContents() == null) continue;
                    for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                        FluidStack fluid;
                        if (tank.getFluidAmount() >= tank.getCapacity() || (fluid = handler.drain(fluidTankProperties.getContents(), false)) == null || fluid.amount <= 0 || !tank.acceptsFluid(fluid.getFluid())) continue;
                        tank.fill(handler.drain(fluidTankProperties.getContents(), true), true);
                    }
                }
            }
        }
    }

    public IItemHandler getItemHandler(@Nullable TileEntity tile, EnumFacing side) {
        IItemHandler handler;
        if (tile == null) {
            return null;
        }
        IItemHandler iItemHandler = handler = tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public IFluidHandler getFluidHandler(@Nullable TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        return tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : null;
    }

    public boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || !a.func_77969_a(b) || a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return !a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p());
    }

    private void tickPullIn(int i) {
        EnumFacing facing = this.facings[i];
        if (facing != null) {
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            try {
                slots = this.slotHandler.get(handler.getHandler());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int j = 0; j < slots; ++j) {
                ItemStack took = handler.getHandler().extractItem(j, 64, true);
                if (took.func_190926_b()) continue;
                ItemStack took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots());
                if (took1.func_190926_b()) {
                    took = handler.getHandler().extractItem(j, took.func_190916_E(), false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                    continue;
                }
                if (took1 == took) continue;
                int count = took1.func_190916_E() - took.func_190916_E();
                count = Math.abs(count);
                took = handler.getHandler().extractItem(j, count, false);
                ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
            }
        } else {
            for (EnumFacing facing1 : this.enumFacings) {
                HandlerInventory handler = this.iItemHandlerMap.get(facing1);
                if (handler == null) continue;
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.func_190926_b()) continue;
                    ItemStack took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots());
                    if (took1.func_190926_b()) {
                        took = handler.getHandler().extractItem(j, took.func_190916_E(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.func_190916_E() - took.func_190916_E();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        }
    }

    private void tick(int i) {
        EnumFacing facing = this.facings[i];
        if (facing != null) {
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            try {
                slots = this.slotHandler.get(handler.getHandler());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (handler.getInventory() != null) {
                for (InvSlotOutput slot : this.slots) {
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack took = slot.get(j);
                        if (took.func_190926_b()) continue;
                        ItemStack stack = this.insertItem1(handler, took, true, slots);
                        if (stack.func_190926_b()) {
                            slot.put(j, ItemStack.field_190927_a);
                            this.insertItem1(handler, took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).func_190916_E() - stack.func_190916_E();
                        slot.get(j).func_190918_g(col);
                        stack.func_190920_e(col);
                        this.insertItem1(handler, stack, false, slots);
                    }
                }
            } else {
                for (InvSlotOutput slot : this.slots) {
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack took = slot.get(j);
                        if (took.func_190926_b()) continue;
                        took = took.func_77946_l();
                        ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.func_190926_b()) {
                            slot.put(j, ItemStack.field_190927_a);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).func_190916_E() - stack.func_190916_E();
                        slot.get(j).func_190918_g(col);
                        stack.func_190920_e(col);
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        } else {
            for (EnumFacing facing1 : this.enumFacings) {
                ItemStack stack;
                ItemStack took;
                int j;
                HandlerInventory handler = this.iItemHandlerMap.get(facing1);
                if (handler == null) continue;
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    for (InvSlotOutput slot : this.slots) {
                        for (j = 0; j < slot.size(); ++j) {
                            took = slot.get(j);
                            if (took.func_190926_b()) continue;
                            stack = this.insertItem1(handler, took, true, slots);
                            if (stack.func_190926_b()) {
                                slot.put(j, ItemStack.field_190927_a);
                                this.insertItem1(handler, took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            slot.get(j).func_190918_g(stack.func_190916_E());
                            this.insertItem1(handler, stack, false, slots);
                        }
                    }
                    continue;
                }
                for (InvSlotOutput slot : this.slots) {
                    for (j = 0; j < slot.size(); ++j) {
                        took = slot.get(j);
                        if (took.func_190926_b()) continue;
                        took = took.func_77946_l();
                        stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.func_190926_b()) {
                            slot.put(j, ItemStack.field_190927_a);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        slot.get(j).func_190918_g(stack.func_190916_E());
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        }
    }

    private void tick_fluid(int i) {
        EnumFacing facing = this.facings[i];
        if (facing != null) {
            IFluidHandler handler = this.iFluidHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (this.fluids == null) {
                return;
            }
            for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                int amount;
                if (tank.getFluidAmount() <= 0 || (amount = handler.fill(tank.getFluid(), false)) <= 0 || !tank.canDrain(facing)) continue;
                tank.drain(handler.fill(tank.getFluid(), true), true);
            }
        } else {
            for (EnumFacing facing1 : this.enumFacings) {
                IFluidHandler handler = this.iFluidHandlerMap.get(facing1);
                if (handler == null) continue;
                if (this.fluids == null) {
                    return;
                }
                for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                    int amount;
                    if (tank.getFluidAmount() <= 0 || (amount = handler.fill(tank.getFluid(), false)) <= 0 || !tank.canDrain(facing1)) continue;
                    tank.drain(handler.fill(tank.getFluid(), true), true);
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItem1(HandlerInventory dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = this.insertItem2(dest, i, stack, simulate);
            if (stack2.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItem2(HandlerInventory dest1, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack stackInSlot;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IItemHandler dest = dest1.getHandler();
        IInventory inventory = dest1.getInventory();
        int maxSlots = dest.getSlots();
        try {
            stackInSlot = inventory.func_70301_a(slot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            stackInSlot = dest.getStackInSlot(slot);
        }
        if (!stackInSlot.func_190926_b()) {
            int max = stackInSlot.func_77976_d();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.func_190916_E() >= Math.min(max, limit)) {
                return stack;
            }
            if (simulate && !inventory.func_94041_b(slot, stack)) {
                return stack;
            }
            if (!this.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    inventory.func_70299_a(slot, copy);
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                inventory.func_70299_a(slot, copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), dest.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                inventory.func_70299_a(slot, stack.func_77979_a(m));
            }
            return stack;
        }
        if (!simulate) {
            try {
                inventory.func_70299_a(slot, stack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                dest.insertItem(slot, stack, false);
            }
        }
        return ItemStack.field_190927_a;
    }

    public double getEnergyStorage(int defaultEnergyStorage, int defaultOperationLength, int defaultEnergyDemand) {
        int opLen = this.getOperationLength(defaultOperationLength);
        double energyDemand = this.getEnergyDemand(defaultEnergyDemand);
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage + (double)opLen * energyDemand, this.energyStorageMultiplier);
    }
}

