/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.welding;

import com.denfop.Localization;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.integration.jei.welding.WeldingRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class WeldingCategory
extends Gui
implements IRecipeCategory<WeldingRecipeWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public WeldingCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guialloysmelter.png"), 5, 16, 140, 65);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine3.welding.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(TileBlockCreator.instance.get(BlockBaseMachine3.welding.getIdentifier()).getItemStack(BlockBaseMachine3.welding).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        double energylevel = Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        double xScale = 24.0f * (float)this.progress / 100.0f;
        if (xScale > 24.0) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(52, 34 - (int)energylevel, 176, 14 - (int)energylevel, 14, (int)energylevel);
        this.func_73729_b(74, 18, 176, 14, (int)(xScale + 1.0), 16);
    }

    public void setRecipe(IRecipeLayout layout, WeldingRecipeWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 32, 0);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 68, 0);
        isg.set(1, recipes.getInput1());
        isg.init(2, false, 110, 17);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guialloysmelter.png");
    }
}

