/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.upgradeblock;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockUpgradeBlock;
import com.denfop.integration.jei.upgradeblock.UpgradeBlockWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class UpgradeBlockCategory
extends Gui
implements IRecipeCategory<UpgradeBlockWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public UpgradeBlockCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiUpgradeBlock.png"), 3, 3, 148, 80);
    }

    @Nonnull
    public String getUid() {
        return BlockUpgradeBlock.upgrade_block.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.upgradeblock).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = 31 * this.progress / 100;
        int xScale1 = 27 * this.progress / 100;
        if (xScale > 31) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(28, 33, 176, 17, xScale + 1, 11);
        this.func_73729_b(78, 31, 176, 29, xScale1 + 1, 15);
        this.func_73729_b(21, 67 - energylevel, 176, 14 - energylevel, 14, energylevel);
    }

    public void setRecipe(IRecipeLayout layout, UpgradeBlockWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 10, 30);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 60, 30);
        isg.set(1, recipes.getInput1());
        isg.init(2, false, 106, 30);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiUpgradeBlock.png");
    }
}

