/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.synthesis;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class SynthesisHandler {
    private static final List<SynthesisHandler> recipes = new ArrayList<SynthesisHandler>();
    private final int percent;
    private final ItemStack input;
    private final ItemStack input1;
    private final ItemStack output;

    public SynthesisHandler(ItemStack input, ItemStack input1, ItemStack output, int percent) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
        this.percent = percent;
    }

    public static List<SynthesisHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SynthesisHandler.initRecipes();
        }
        return recipes;
    }

    public static SynthesisHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output, int percent) {
        SynthesisHandler recipe = new SynthesisHandler(input, input1, output, percent);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static SynthesisHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (SynthesisHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("synthesis")) {
            SynthesisHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.func_74762_e("percent"));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getPercent() {
        return this.percent;
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77969_a(this.input) || is.func_77969_a(this.input1);
    }
}

