/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.microchip;

import com.denfop.integration.jei.microchip.MicrochipHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MicrochipRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack inputstack;
    private final ItemStack outputstack;
    private final ItemStack inputstack1;
    private final ItemStack inputstack2;
    private final ItemStack inputstack3;
    private final ItemStack inputstack4;
    private final short temperature;

    public MicrochipRecipeWrapper(MicrochipHandler container) {
        this.inputstack = container.getInput();
        this.inputstack1 = container.getInput1();
        this.inputstack2 = container.getInput2();
        this.inputstack3 = container.getInput3();
        this.inputstack4 = container.getInput4();
        this.temperature = container.getTemperature();
        this.outputstack = container.getOutput();
    }

    public ItemStack getInput() {
        return this.inputstack;
    }

    public ItemStack getInput1() {
        return this.inputstack1;
    }

    public ItemStack getInput2() {
        return this.inputstack2;
    }

    public ItemStack getInput3() {
        return this.inputstack3;
    }

    public ItemStack getInput4() {
        return this.inputstack4;
    }

    public short getTemperature() {
        return this.temperature;
    }

    public List<List<ItemStack>> getInputs() {
        int id;
        ItemStack inputs = this.inputstack;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (OreDictionary.getOreIDs((ItemStack)inputs).length > 0) {
            id = OreDictionary.getOreIDs((ItemStack)inputs)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(inputs);
        }
        if (OreDictionary.getOreIDs((ItemStack)this.inputstack1).length > 0) {
            id = OreDictionary.getOreIDs((ItemStack)this.inputstack1)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(this.inputstack1);
        }
        if (OreDictionary.getOreIDs((ItemStack)this.inputstack2).length > 0) {
            id = OreDictionary.getOreIDs((ItemStack)this.inputstack2)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(this.inputstack2);
        }
        if (OreDictionary.getOreIDs((ItemStack)this.inputstack3).length > 0) {
            id = OreDictionary.getOreIDs((ItemStack)this.inputstack3)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(this.inputstack3);
        }
        if (OreDictionary.getOreIDs((ItemStack)this.inputstack4).length > 0) {
            id = OreDictionary.getOreIDs((ItemStack)this.inputstack4)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(this.inputstack4);
        }
        return inputs.func_190926_b() ? Collections.emptyList() : Collections.singletonList(stack);
    }

    public List<ItemStack> getOutputs() {
        return new ArrayList<ItemStack>(Collections.singleton(this.outputstack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
    }

    public ItemStack getOutput() {
        return this.outputstack;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int temperature = 38 * this.temperature / 5000;
        short temp = this.temperature;
        if (temperature > 0) {
            this.drawTexturedModalRect(67, 60, 176, 21, temperature + 1, 11);
        }
        minecraft.field_71466_p.func_78276_b("" + temp + "\u00b0C", 70, 80, 0x404040);
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

