/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.laser;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class LaserHandler {
    private static final List<LaserHandler> recipes = new ArrayList<LaserHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public LaserHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<LaserHandler> getRecipes() {
        if (recipes.isEmpty()) {
            LaserHandler.initRecipes();
        }
        return recipes;
    }

    public static LaserHandler addRecipe(ItemStack input, ItemStack output) {
        LaserHandler recipe = new LaserHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static LaserHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (LaserHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("laser")) {
            LaserHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77969_a(this.input);
    }
}

