/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.handlerho;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.integration.jei.handlerho.HandlerHORecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HandlerHOCategory
extends Gui
implements IRecipeCategory<HandlerHORecipeWrapper> {
    private final IDrawableStatic bg;
    private int energy = 0;
    private int progress = 0;

    public HandlerHOCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GUIHandlerHO_jei.png"), 3, 3, 140, 80);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine1.handler_ho.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine, 1, 12).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = 44 * this.progress / 100;
        if (xScale > 44) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(45, 28, 177, 32, xScale + 1, 14);
        this.func_73729_b(22, 68 - energylevel, 176, 14 - energylevel, 14, energylevel);
    }

    public void setRecipe(IRecipeLayout layout, HandlerHORecipeWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 21, 25);
        isg.set(0, recipes.getInput());
        for (int i = 0; i < recipes.getOutput().size(); ++i) {
            isg.init(1 + i, false, 98, 7 + 18 * i);
            isg.set(1 + i, recipes.getOutput().get(i));
        }
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GUIHandlerHO_jei.png");
    }
}

