/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.fishmachine;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.integration.jei.fishmachine.FishMWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FishMCategory
extends Gui
implements IRecipeCategory<FishMWrapper> {
    private final IDrawableStatic bg;
    private int energy = 0;
    private int progress = 0;

    public FishMCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiFisher.png"), 3, 3, 160, 80);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine2.fisher.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine1, 1, 1).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(48.0f * (float)this.energy / 100.0f, 48.0f);
        double xScale = 15.0f * (float)this.progress / 100.0f;
        if (xScale > 15.0) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(143, 73 - energylevel, 176, 48 - energylevel, 48, energylevel);
        this.func_73729_b(39, 43, 177, 48, (int)(xScale + 1.0), 14);
    }

    public void setRecipe(IRecipeLayout layout, FishMWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 13, 41);
        isg.set(0, new ItemStack((Item)Items.field_151112_aM));
        isg.init(1, false, 61, 23);
        isg.set(1, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiFisher.png");
    }
}

