/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.farmer;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockMoreMachine3;
import com.denfop.integration.jei.farmer.FarmerRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FarmerCategory
extends Gui
implements IRecipeCategory<FarmerRecipeWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public FarmerCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guimachine3.png"), 3, 3, 140, 80);
    }

    @Nonnull
    public String getUid() {
        return BlockMoreMachine3.farmer.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.machines_base3, 1, 0).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = Math.min(16 * this.energy / 100, 16);
        int xScale = 24 * this.progress / 100;
        if (xScale > 24) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/gui_progressbars.png"));
        this.func_73729_b(2, 45, 136, 4, 12, 14);
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(66, 31, 176, 15, 16, 24);
        this.func_73729_b(65, 31, 192, 15, 16, xScale + 1);
        this.func_73729_b(4, 58 - energylevel, 176, 16 - energylevel, 16, energylevel);
        this.func_73729_b(65, 11, 238, 0, 18, 18);
        this.func_73729_b(65, 55, 238, 0, 18, 18);
        this.func_73729_b(2, 60, 238, 0, 18, 18);
        mc.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/gui_progressbars.png"));
        this.func_73729_b(5, 42, 0, 0, 12, 16);
    }

    public void setRecipe(IRecipeLayout layout, FarmerRecipeWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 65, 11);
        isg.set(0, recipes.getInput());
        isg.init(1, false, 65, 55);
        isg.set(1, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine3.png");
    }
}

