/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.extractor;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ExtractorHandler {
    private static final List<ExtractorHandler> recipes = new ArrayList<ExtractorHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public ExtractorHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<ExtractorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ExtractorHandler.initRecipes();
        }
        return recipes;
    }

    public static ExtractorHandler addRecipe(ItemStack input, ItemStack output) {
        ExtractorHandler recipe = new ExtractorHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ExtractorHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (ExtractorHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("extractor")) {
            try {
                ExtractorHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
            }
            catch (Exception exception) {}
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

