/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.deposits;

import com.denfop.Localization;
import com.denfop.integration.jei.deposits.DepositsHandler;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class DepositsWrapper
implements IRecipeWrapper {
    private final VeinType vein;

    public DepositsWrapper(DepositsHandler container) {
        this.vein = container.getVeinType();
    }

    public VeinType getVein() {
        return this.vein;
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (this.vein.getHeavyOre() != null) {
            stack.add(new ItemStack((Block)this.vein.getHeavyOre(), 1, this.vein.getMeta()));
        }
        for (ChanceOre ore : this.vein.getOres()) {
            stack.add(new ItemStack(ore.getBlock().func_177230_c(), 1, ore.getMeta()));
        }
        return stack;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.getInputs());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int y = 20;
        int x = 25;
        minecraft.field_71466_p.func_78279_b(Localization.translate("deposists.jei1") + (this.vein.getHeavyOre() != null ? new ItemStack((Block)this.vein.getHeavyOre(), 1, this.vein.getMeta()).func_82833_r() : new ItemStack(this.vein.getOres().get(0).getBlock().func_177230_c(), 1, this.vein.getOres().get(0).getMeta()).func_82833_r()), 5, 3, recipeWidth - 5, 0x404040);
        if (this.vein.getHeavyOre() != null) {
            minecraft.field_71466_p.func_78279_b(" 50%", x, y, recipeWidth - x, 0x404040);
            for (int i = 0; i < this.vein.getOres().size(); ++i) {
                minecraft.field_71466_p.func_78279_b(" " + this.vein.getOres().get(i).getChance() + "%", x, y + 19 + 20 * i, recipeWidth - x, 0x404040);
            }
        } else {
            for (int i = 0; i < this.vein.getOres().size(); ++i) {
                minecraft.field_71466_p.func_78279_b(" " + this.vein.getOres().get(i).getChance() + "%", x, y + 20 * i, recipeWidth - x, 0x404040);
            }
        }
    }
}

