/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.convertermatter;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockConverterMatter;
import com.denfop.integration.jei.convertermatter.ConverterWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ConverterCategory
extends Gui
implements IRecipeCategory<ConverterWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public ConverterCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiconvertersolidmatter.png"), 3, 5, 168, 135);
    }

    @Nonnull
    public String getUid() {
        return BlockConverterMatter.converter_matter.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.convertersolidmatter, 1, 0).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(38.0f * (float)this.energy / 100.0f, 38.0f);
        int xScale = 31 * this.progress / 100;
        if (xScale > 31) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(116, 110, 176, 81, energylevel, 11);
        this.func_73729_b(76, 46, 176, 24, xScale, 15);
        this.func_73729_b(168 - xScale, 46, 208 - xScale, 24, xScale, 15);
        this.func_73729_b(113, 12, 176, 42, 17, xScale);
        this.func_73729_b(113, 96 - xScale, 176, 74 - xScale, 17, xScale);
    }

    public void setRecipe(IRecipeLayout layout, ConverterWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, false, 113, 45);
        isg.set(0, recipes.getOutput());
        isg.init(1, true, 47, 45);
        isg.set(1, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiconvertersolidmatter.png");
    }
}

