/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.centrifuge;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CentrifugeHandler {
    private static final List<CentrifugeHandler> recipes = new ArrayList<CentrifugeHandler>();
    private final ItemStack input;
    private final List<ItemStack> output;
    private final short temperature;

    public CentrifugeHandler(ItemStack input, List<ItemStack> output, short temperature) {
        this.input = input;
        this.output = output;
        this.temperature = temperature;
    }

    public static List<CentrifugeHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CentrifugeHandler.initRecipes();
        }
        return recipes;
    }

    public static CentrifugeHandler addRecipe(ItemStack input, List<ItemStack> output, short temperature) {
        CentrifugeHandler recipe = new CentrifugeHandler(input, output, temperature);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CentrifugeHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (CentrifugeHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("centrifuge")) {
            CentrifugeHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items, container.getOutput().metadata.func_74765_d("minHeat"));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }

    public short getTemperature() {
        return this.temperature;
    }
}

