/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.recipe.IInputItemStack;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public class IC2InputItemStack
implements IInputItemStack {
    private final IIngredient ingredient;

    public IC2InputItemStack(IIngredient ingredient) {
        this.ingredient = ingredient;
    }

    @Override
    public boolean matches(ItemStack subject) {
        return this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)subject));
    }

    @Override
    public int getAmount() {
        return this.ingredient.getAmount();
    }

    @Override
    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IItemStack item : this.ingredient.getItems()) {
            items.add(CraftTweakerMC.getItemStack((IItemStack)item));
        }
        return items;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.ingredient != null ? this.ingredient.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IC2InputItemStack other = (IC2InputItemStack)obj;
        return Objects.equals(this.ingredient, other.ingredient);
    }
}

