/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.integration.crafttweaker.BaseAction;
import com.denfop.integration.crafttweaker.IC2InputItemStack;
import com.denfop.recipe.IInputHandler;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.MolecularTransformer")
@ModOnly(value="industrialupgrade")
@ZenRegister
public class CTMolecularTransformer {
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient ingredient, double energy) {
        if (ingredient.getAmount() < 0) {
            CraftTweakerAPI.logWarning((String)("invalid ingredient: " + ingredient + " - stack size not known"));
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("energy", energy);
            CraftTweakerAPI.apply((IAction)new AddMolecularAction(ingredient, new ItemStack[]{CTMolecularTransformer.getItemStack(output)}, tag, false));
        }
    }

    @ZenMethod
    public static void addOreRecipe(IItemStack output, IIngredient ingredient, double energy) {
        if (ingredient.getAmount() < 0) {
            CraftTweakerAPI.logWarning((String)("invalid ingredient: " + ingredient + " - stack size not known"));
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("energy", energy);
            CraftTweakerAPI.apply((IAction)new AddMolecularAction(ingredient, new ItemStack[]{CTMolecularTransformer.getItemStack(output)}, tag, true));
        }
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
        }
        assert (internal instanceof ItemStack);
        return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
    }

    private static class AddMolecularAction
    extends BaseAction {
        private final IIngredient ingredient;
        private final NBTTagCompound tag;
        private final ItemStack[] output;
        private final boolean oreDictionary;

        public AddMolecularAction(IIngredient ingredient, ItemStack[] output, NBTTagCompound tag, boolean oreDictionary) {
            super("MolecularTransformer");
            this.ingredient = ingredient;
            this.tag = tag;
            this.output = output;
            this.oreDictionary = oreDictionary;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            IInputHandler input = Recipes.inputFactory;
            if (this.oreDictionary) {
                ItemStack stack = new IC2InputItemStack(this.ingredient).getInputs().get(0);
                String ore = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0]);
                Recipes.recipes.addAdderRecipe("molecular", new BaseMachineRecipe(new Input(OreDictionary.getOres((String)ore).isEmpty() ? new IC2InputItemStack(this.ingredient) : input.getInput(ore)), new RecipeOutput(this.tag, this.output)));
            } else {
                Recipes.recipes.addAdderRecipe("molecular", new BaseMachineRecipe(new Input(new IC2InputItemStack(this.ingredient)), new RecipeOutput(this.tag, this.output)));
            }
        }

        @Override
        public String describe() {
            return "Adding molecular recipe " + this.ingredient + " + " + this.tag + " => " + Arrays.toString(this.output);
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.ingredient != null ? this.ingredient.hashCode() : 0);
            hash = 67 * hash + (this.tag != null ? this.tag.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? Arrays.hashCode(this.output) : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddMolecularAction other = (AddMolecularAction)obj;
            if (!Objects.equals(this.ingredient, other.ingredient)) {
                return false;
            }
            if (!Objects.equals(this.tag, other.tag)) {
                return false;
            }
            return Arrays.equals(this.output, other.output);
        }
    }

    private static class Remove
    extends BaseAction {
        private final IItemStack output;

        public Remove(IItemStack output) {
            super("MolecularTransformer");
            this.output = output;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            Recipes.recipes.addRemoveRecipe("molecular", CraftTweakerMC.getItemStack((IItemStack)this.output));
        }

        @Override
        public String describe() {
            return "removing recipe " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Remove other = (Remove)obj;
            return Objects.equals(this.output, other.output);
        }
    }
}

