/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.IUCore;
import com.denfop.integration.crafttweaker.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.QuarryFurnaceRecipe")
@ModOnly(value="industrialupgrade")
@ZenRegister
public class CTFQuarry {
    @ZenMethod
    public static void addRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new AddMolecularAction(output));
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
        }
        assert (internal instanceof ItemStack);
        return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new Remove(input));
    }

    private static class Remove
    extends BaseAction {
        private final IItemStack input;

        public Remove(IItemStack input) {
            super("fquarry");
            this.input = input;
        }

        public void apply() {
            if (OreDictionary.getOreIDs((ItemStack)((ItemStack)this.input.getInternal())).length == 0) {
                IUCore.list_furnace_removing.add((ItemStack)this.input.getInternal());
            } else {
                int i = OreDictionary.getOreIDs((ItemStack)((ItemStack)this.input.getInternal()))[0];
                IUCore.list_furnace_removing.add((ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)i)).get(0));
            }
        }
    }

    private static class AddMolecularAction
    extends BaseAction {
        private final IItemStack output;

        public AddMolecularAction(IItemStack output) {
            super("fquarry");
            this.output = output;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            if (OreDictionary.getOreIDs((ItemStack)((ItemStack)this.output.getInternal())).length == 0) {
                if (!IUCore.list_furnace_adding.contains((ItemStack)this.output.getInternal())) {
                    IUCore.list_furnace_adding.add((ItemStack)this.output.getInternal());
                } else {
                    int i = OreDictionary.getOreIDs((ItemStack)((ItemStack)this.output.getInternal()))[0];
                    if (!IUCore.list_furnace_adding.contains(OreDictionary.getOres((String)OreDictionary.getOreName((int)i)).get(0))) {
                        IUCore.list_furnace_adding.add((ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)i)).get(0));
                    }
                }
            }
        }

        @Override
        public String describe() {
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddMolecularAction other = (AddMolecularAction)obj;
            return Objects.equals(this.output, other.output);
        }
    }
}

