/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.heat;

import com.denfop.api.heat.IHeatNet;
import com.denfop.api.heat.IHeatTile;
import com.denfop.heat.EventHandler;
import com.denfop.heat.HeatNetLocal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatNetGlobal
implements IHeatNet {
    private static Map<World, HeatNetLocal> worldToEnergyNetMap = new WeakHashMap<World, HeatNetLocal>();

    public static HeatNetGlobal initialize() {
        new EventHandler();
        return new HeatNetGlobal();
    }

    public static void onWorldUnload(World world) {
        HeatNetLocal local = worldToEnergyNetMap.remove(world);
        if (local != null) {
            local.onUnload();
        }
    }

    public static HeatNetLocal getForWorld(World world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new HeatNetLocal());
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTickEnd(World world) {
        HeatNetLocal energyNet = HeatNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public IHeatTile getSubTile(World var1, BlockPos var2) {
        HeatNetLocal local = HeatNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }
}

