/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerBlastFurnace;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.blastfurnace.block.TileBlastFurnaceMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBlastFurnace
extends GuiIU<ContainerBlastFurnace> {
    public final ContainerBlastFurnace container;

    public GuiBlastFurnace(ContainerBlastFurnace container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.addComponent(new GuiComponent(this, 60, 67, EnumTypeComponent.HEAT, new Component<HeatComponent>(((TileBlastFurnaceMain)this.container.base).heat)));
        this.addComponent(new GuiComponent(this, 159, 14, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.blast_furnace_recipe.info"));
            List<String> compatibleUpgrades = ListInformationUtils.blast_furnace;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        if (((TileBlastFurnaceMain)this.container.base).tank1 != null) {
            TankGauge.createNormal(this, 6, 5, (IFluidTank)((TileBlastFurnaceMain)this.container.base).tank1).drawForeground(par1, par2);
        }
        TankGauge.createNormal(this, 27, 5, (IFluidTank)((TileBlastFurnaceMain)this.container.base).tank).drawForeground(par1, par2);
        String temp = ModUtils.getString((double)((TileBlastFurnaceMain)this.container.base).bar * 100000.0) + " Pa";
        ((Area)new AdvArea(this, 136, 63, 164, 66).withTooltip(temp)).drawForeground(par1, par2);
        ((Area)new AdvArea(this, 136, 69, 146, 79).withTooltip("+1")).drawForeground(par1, par2);
        ((Area)new AdvArea(this, 154, 69, 164, 79).withTooltip("-1")).drawForeground(par1, par2);
        ((Area)new AdvArea(this, 80, 35, 101, 49).withTooltip(Localization.translate("gui.MolecularTransformer.progress") + ": " + (int)(Math.min(((TileBlastFurnaceMain)this.container.base).getProgress() / 3600.0, 1.0) * 100.0) + "%")).drawForeground(par1, par2);
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 136 && x <= 146 && y >= 69 && y <= 79) {
            new PacketUpdateServerTile((TileEntity)this.container.base, 0.0);
        }
        if (x >= 154 && x <= 164 && y >= 69 && y <= 79) {
            new PacketUpdateServerTile((TileEntity)this.container.base, 1.0);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(((TileBlastFurnaceMain)this.container.base).func_70005_c_());
        this.drawXCenteredString(this.field_146999_f / 2 + 20, 6, name, 0x404040, false);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        int progress = (int)(24.0 * ((TileBlastFurnaceMain)this.container.base).getProgress() / 3600.0);
        int xoffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yoffset = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        if (progress > 0) {
            this.func_73729_b(xoffset + 79, yoffset + 34, 176, 14, progress + 1, 16);
        }
        if (((TileBlastFurnaceMain)this.container.base).tank1 != null) {
            TankGauge.createNormal(this, 6, 5, (IFluidTank)((TileBlastFurnaceMain)this.container.base).tank1).drawBackground(xoffset, yoffset);
        }
        TankGauge.createNormal(this, 27, 5, (IFluidTank)((TileBlastFurnaceMain)this.container.base).tank).drawBackground(xoffset, yoffset);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.func_73729_b(xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        int bar = (int)(Math.min((double)((TileBlastFurnaceMain)this.container.base).bar * 1.0, 5.0) / 5.0 * 27.0);
        if (bar > 0) {
            this.func_73729_b(this.field_147003_i + 136, this.field_147009_r + 63, 177, 104, bar + 1, 3);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiblastfurnace.png");
    }
}

