/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.FakePlayer;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.tiles.quarry_earth.TileEntityEarthQuarryController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class WorldSavedDataIU
extends WorldSavedData {
    public int col;
    World world;
    private NBTTagCompound tagCompound = new NBTTagCompound();

    public WorldSavedDataIU() {
        super("industrialupgrade");
    }

    public WorldSavedDataIU(String name) {
        super(name);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void func_76184_a(@Nonnull NBTTagCompound compound) {
        NBTTagCompound tag2;
        NBTTagCompound tag1;
        this.col = compound.func_74762_e("col");
        for (int i = 0; i < this.col; ++i) {
            NBTTagCompound nbt = compound.func_74775_l(String.valueOf(i));
            String name = nbt.func_74779_i("name");
            NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("tag");
            FakePlayer player = new FakePlayer(name, tag);
            SpaceNet.instance.getFakeSpaceSystem().loadDataFromPlayer(player);
            NBTTagCompound nbt_operation = nbt.func_74775_l("operation");
            ArrayList<SpaceOperation> spaceOperations = new ArrayList<SpaceOperation>();
            for (Map.Entry<String, IBody> map : SpaceNet.instance.getBodyMap().entrySet()) {
                if (!nbt_operation.func_74764_b(map.getKey())) continue;
                SpaceOperation spaceOperation = new SpaceOperation(nbt_operation.func_74775_l(map.getKey()));
                spaceOperations.add(spaceOperation);
            }
            SpaceNet.instance.getFakeSpaceSystem().loadSpaceOperation(spaceOperations, player);
        }
        if (compound.func_74764_b("vein")) {
            NBTTagCompound tag = compound.func_74775_l("vein");
            int size = tag.func_74762_e("max");
            for (int i = 0; i < size; ++i) {
                tag1 = tag.func_74775_l(String.valueOf(i));
                VeinSystem.system.addVein(tag1);
            }
        } else {
            compound.func_74782_a("vein", (NBTBase)new NBTTagCompound());
        }
        if (compound.func_74764_b("earth_quarry")) {
            NBTTagCompound tag = compound.func_74775_l("earth_quarry");
            int size = tag.func_74762_e("max");
            for (int i = 0; i < size; ++i) {
                tag1 = tag.func_74775_l(String.valueOf(i));
                TileEntityEarthQuarryController.chunkPos.add(new ChunkPos(tag1.func_74762_e("x"), tag1.func_74762_e("z")));
            }
        } else {
            compound.func_74782_a("earth_quarry", (NBTBase)new NBTTagCompound());
        }
        if (compound.func_74764_b("colonies")) {
            NBTTagCompound tag12 = compound.func_74775_l("colonies");
            int size = tag12.func_74762_e("col");
            for (int i = 0; i < size; ++i) {
                tag2 = tag12.func_74775_l(String.valueOf(i));
                SpaceNet.instance.getColonieNet().addColony(tag2);
            }
        } else {
            compound.func_74782_a("colonies", (NBTBase)new NBTTagCompound());
        }
        if (compound.func_74764_b("radiations")) {
            NBTTagCompound tag13 = compound.func_74775_l("radiations");
            int size = tag13.func_74762_e("col");
            for (int i = 0; i < size; ++i) {
                tag2 = tag13.func_74775_l(String.valueOf(i));
                RadiationSystem.rad_system.addRadiation(tag2);
            }
        } else {
            compound.func_74782_a("radiations", (NBTBase)new NBTTagCompound());
        }
        if (compound.func_74764_b("streaks")) {
            NBTTagCompound tag14 = compound.func_74775_l("streaks");
            int size = tag14.func_74762_e("col");
            for (int i = 0; i < size; ++i) {
                tag2 = tag14.func_74775_l(String.valueOf(i));
                String nick = tag2.func_74779_i("nick");
                PlayerStreakInfo playerStreakInfo = new PlayerStreakInfo(tag2.func_74775_l("streak"));
                if (IUCore.mapStreakInfo.containsKey(nick)) continue;
                IUCore.mapStreakInfo.put(nick, playerStreakInfo);
            }
        } else {
            compound.func_74782_a("streaks", (NBTBase)new NBTTagCompound());
        }
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        compound = new NBTTagCompound();
        List<FakePlayer> list = SpaceNet.instance.getFakeSpaceSystem().getFakePlayers();
        int i = 0;
        for (FakePlayer player : list) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", player.getName());
            nbt.func_74782_a("tag", (NBTBase)player.getTag());
            NBTTagCompound nbt_operation = new NBTTagCompound();
            List<SpaceOperation> list1 = SpaceNet.instance.getFakeSpaceSystem().getSpaceOperationMap(player);
            Iterator<SpaceOperation> iterator = list1.iterator();
            while (iterator.hasNext()) {
                SpaceOperation spaceOperation = iterator.next();
                spaceOperation.writeTag(nbt_operation);
            }
            nbt.func_74782_a("operation", (NBTBase)nbt_operation);
            compound.func_74782_a(String.valueOf(i), (NBTBase)compound);
            ++i;
        }
        compound.func_74768_a("col", i);
        List<Vein> list1 = VeinSystem.system.getVeinsList();
        NBTTagCompound tag = new NBTTagCompound();
        for (int i1 = 0; i1 < list1.size(); ++i1) {
            tag.func_74782_a(String.valueOf(i1), (NBTBase)list1.get(i1).writeTag());
        }
        tag.func_74768_a("max", list1.size());
        compound.func_74782_a("vein", (NBTBase)tag);
        NBTTagCompound tag1 = new NBTTagCompound();
        tag1.func_74768_a("col", SpaceNet.instance.getColonieNet().getList().size());
        List<FakePlayer> list2 = SpaceNet.instance.getColonieNet().getList();
        i = 0;
        for (FakePlayer player : list2) {
            tag1.func_74782_a(String.valueOf(i), (NBTBase)SpaceNet.instance.getColonieNet().writeNBT(tag1, player));
            ++i;
        }
        compound.func_74782_a("colonies", (NBTBase)tag1);
        NBTTagCompound tag2 = new NBTTagCompound();
        tag2.func_74768_a("col", RadiationSystem.rad_system.radiationList.size());
        List<Radiation> list3 = RadiationSystem.rad_system.radiationList;
        i = 0;
        for (Radiation radiation : list3) {
            tag2.func_74782_a(String.valueOf(i), (NBTBase)radiation.writeCompound());
            ++i;
        }
        compound.func_74782_a("radiations", (NBTBase)tag2);
        NBTTagCompound tag3 = new NBTTagCompound();
        tag3.func_74768_a("col", IUCore.mapStreakInfo.size());
        i = 0;
        for (Map.Entry<String, PlayerStreakInfo> entry : IUCore.mapStreakInfo.entrySet()) {
            NBTTagCompound tag4 = new NBTTagCompound();
            tag4.func_74778_a("nick", entry.getKey());
            tag4.func_74782_a("streak", (NBTBase)entry.getValue().writeNBT());
            tag3.func_74782_a(String.valueOf(i), (NBTBase)tag4);
            ++i;
        }
        compound.func_74782_a("streaks", (NBTBase)tag3);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("max", TileEntityEarthQuarryController.chunkPos.size());
        List<ChunkPos> list4 = TileEntityEarthQuarryController.chunkPos;
        i = 0;
        for (ChunkPos chunkPos : list4) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("x", chunkPos.field_77276_a);
            nbt.func_74768_a("z", chunkPos.field_77275_b);
            nBTTagCompound.func_74782_a(String.valueOf(i), (NBTBase)nbt);
            ++i;
        }
        compound.func_74782_a("earth_quarry", (NBTBase)nBTTagCompound);
        this.tagCompound = compound;
        return compound;
    }
}

