/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class Fluids
extends AbstractComponent {
    protected final List<InternalFluidTank> managedTanks = new ArrayList<InternalFluidTank>();
    protected final List<Supplier<? extends Collection<InternalFluidTank>>> unmanagedTanks = new ArrayList<Supplier<? extends Collection<InternalFluidTank>>>();

    public Fluids(TileEntityInventory parent) {
        super(parent);
    }

    public static Predicate<Fluid> fluidPredicate(Fluid ... fluids) {
        Collection<Fluid> acceptedFluids = fluids.length > 10 ? new HashSet<Fluid>(Arrays.asList(fluids)) : Arrays.asList(fluids);
        return acceptedFluids::contains;
    }

    public static Predicate<Fluid> fluidPredicate(List<Fluid> fluids) {
        Collection<Object> acceptedFluids = fluids != null ? (fluids.size() > 10 ? new HashSet<Fluid>(fluids) : fluids) : new ArrayList();
        return acceptedFluids::contains;
    }

    public InternalFluidTank addTankInsert(String name, int capacity) {
        return this.addTankInsert(name, capacity, (Predicate<Fluid>)Predicates.alwaysTrue());
    }

    public InternalFluidTank addTankInsert(String name, int capacity, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.INPUT, acceptedFluids);
    }

    public InternalFluidTank addTankExtract(String name, int capacity) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.OUTPUT, (Predicate<Fluid>)Predicates.alwaysTrue());
    }

    public InternalFluidTank addTank(String name, int capacity) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.INPUT_OUTPUT);
    }

    public InternalFluidTank addTank(String name, int capacity, InvSlot.TypeItemSlot typeItemSlot) {
        return this.addTank(name, capacity, typeItemSlot, (Predicate<Fluid>)Predicates.alwaysTrue());
    }

    public InternalFluidTank addTank(String name, int capacity, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.INPUT_OUTPUT, acceptedFluids);
    }

    public InternalFluidTank addTank(String name, int capacity, InvSlot.TypeItemSlot typeItemSlot, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, typeItemSlot.isInput() ? ModUtils.allFacings : Collections.emptySet(), typeItemSlot.isOutput() ? ModUtils.allFacings : Collections.emptySet(), acceptedFluids);
    }

    public InternalFluidTank addTank(String name, int capacity, Collection<EnumFacing> inputSides, Collection<EnumFacing> outputSides, Predicate<Fluid> acceptedFluids) {
        return this.addTank(new InternalFluidTank(name, inputSides, outputSides, acceptedFluids, capacity));
    }

    public InternalFluidTank addTank(InternalFluidTank tank) {
        this.managedTanks.add(tank);
        return tank;
    }

    public void addUnmanagedTanks(InternalFluidTank tank) {
        this.unmanagedTanks.add((Supplier<? extends Collection<InternalFluidTank>>)Suppliers.ofInstance(Collections.singleton(tank)));
    }

    public void addUnmanagedTanks(Collection<InternalFluidTank> tanks) {
        this.addUnmanagedTankHook((Supplier<? extends Collection<InternalFluidTank>>)Suppliers.ofInstance(tanks));
    }

    public void addUnmanagedTankHook(Supplier<? extends Collection<InternalFluidTank>> suppl) {
        this.unmanagedTanks.add(suppl);
    }

    public void changeConnectivity(InternalFluidTank tank, InvSlot.TypeItemSlot typeItemSlot) {
        this.changeConnectivity(tank, typeItemSlot.isInput() ? ModUtils.allFacings : Collections.emptySet(), typeItemSlot.isOutput() ? ModUtils.allFacings : Collections.emptySet());
    }

    public void changeConnectivity(InternalFluidTank tank, Collection<EnumFacing> inputSides, Collection<EnumFacing> outputSides) {
        assert (this.managedTanks.contains((Object)tank));
        tank.inputSides = inputSides;
        tank.outputSides = outputSides;
    }

    public FluidTank getFluidTank(String name) {
        InternalFluidTank tank;
        Iterator<InternalFluidTank> var2 = this.getAllTanks().iterator();
        do {
            if (!var2.hasNext()) {
                throw new IllegalArgumentException("Unable to find tank: " + name);
            }
            tank = var2.next();
        } while (!tank.identifier.equals(name));
        return tank;
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        for (InternalFluidTank tank : this.managedTanks) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag = tank.writeToNBT(subTag);
            try {
                EncoderHandler.encode(buffer, subTag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        for (InternalFluidTank tank : this.managedTanks) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag = tank.writeToNBT(subTag);
            try {
                EncoderHandler.encode(buffer, subTag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        for (InternalFluidTank tank : this.managedTanks) {
            tank.readFromNBT((NBTTagCompound)DecoderHandler.decode(is));
        }
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        for (InternalFluidTank tank : this.managedTanks) {
            if (!nbt.func_150297_b(tank.identifier, 10)) continue;
            tank.readFromNBT(nbt.func_74775_l(tank.identifier));
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (InternalFluidTank tank : this.managedTanks) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag = tank.writeToNBT(subTag);
            nbt.func_74782_a(tank.identifier, (NBTBase)subTag);
        }
        return nbt;
    }

    @Override
    public Collection<? extends Capability<?>> getProvidedCapabilities(EnumFacing side) {
        return Collections.singleton(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        return (T)(cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? new FluidHandler(side) : super.getCapability(cap, side));
    }

    public Iterable<InternalFluidTank> getAllTanks() {
        if (this.unmanagedTanks.isEmpty()) {
            return this.managedTanks;
        }
        ArrayList<InternalFluidTank> tanks = new ArrayList<InternalFluidTank>();
        tanks.addAll(this.managedTanks);
        for (Supplier<? extends Collection<InternalFluidTank>> unmanagedTank : this.unmanagedTanks) {
            tanks.addAll((Collection)unmanagedTank.get());
        }
        return tanks;
    }

    private class FluidHandler
    implements IFluidHandler {
        private final EnumFacing side;

        FluidHandler(EnumFacing side) {
            this.side = side;
        }

        public IFluidTankProperties[] getTankProperties() {
            ArrayList<IFluidTankProperties> props = new ArrayList<IFluidTankProperties>(Fluids.this.managedTanks.size());
            Iterator<InternalFluidTank> var2 = Fluids.this.getAllTanks().iterator();
            while (var2.hasNext()) {
                InternalFluidTank tank = var2.next();
                if (!tank.canFill(this.side) && !tank.canDrain(this.side)) continue;
                props.add(tank.getTankProperties(this.side));
            }
            return props.toArray(new IFluidTankProperties[0]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource != null && resource.amount > 0) {
                int total = 0;
                FluidStack missing = resource.copy();
                for (InternalFluidTank tank : Fluids.this.getAllTanks()) {
                    if (!tank.canFill(this.side)) continue;
                    missing.amount = resource.amount - (total += tank.fill(missing, doFill));
                    if (missing.amount > 0) continue;
                    break;
                }
                return total;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource != null && resource.amount > 0) {
                FluidStack ret = new FluidStack(resource.getFluid(), 0);
                for (InternalFluidTank tank : Fluids.this.getAllTanks()) {
                    FluidStack add;
                    FluidStack inTank;
                    if (!tank.canDrain(this.side) || (inTank = tank.getFluid()) == null || inTank.getFluid() != resource.getFluid() || (add = tank.drain(resource.amount - ret.amount, doDrain)) == null) continue;
                    assert (add.getFluid() == resource.getFluid());
                    ret.amount += add.amount;
                    if (ret.amount < resource.amount) continue;
                    break;
                }
                return ret.amount == 0 ? null : ret;
            }
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            for (InternalFluidTank tank : Fluids.this.getAllTanks()) {
                FluidStack stack;
                if (!tank.canDrain(this.side) || (stack = tank.drain(maxDrain, false)) == null) continue;
                stack.amount = maxDrain;
                return this.drain(stack, doDrain);
            }
            return null;
        }
    }

    public static class InternalFluidTank
    extends FluidTank {
        protected final String identifier;
        private Predicate<Fluid> acceptedFluids;
        private Collection<EnumFacing> inputSides;
        private Collection<EnumFacing> outputSides;

        protected InternalFluidTank(String identifier, Collection<EnumFacing> inputSides, Collection<EnumFacing> outputSides, Predicate<Fluid> acceptedFluids, int capacity) {
            super(capacity);
            this.identifier = identifier;
            this.acceptedFluids = acceptedFluids;
            this.inputSides = inputSides;
            this.outputSides = outputSides;
        }

        public void setAcceptedFluids(Predicate<Fluid> acceptedFluids) {
            this.acceptedFluids = acceptedFluids;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && this.acceptsFluid(fluid.getFluid());
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return fluid != null && this.acceptsFluid(fluid.getFluid());
        }

        public boolean acceptsFluid(Fluid fluid) {
            return this.acceptedFluids.apply((Object)fluid);
        }

        public Predicate<Fluid> getAcceptedFluids() {
            return this.acceptedFluids;
        }

        IFluidTankProperties getTankProperties(final EnumFacing side) {
            assert (side == null || this.inputSides.contains(side) || this.outputSides.contains(side));
            return new IFluidTankProperties(){

                public FluidStack getContents() {
                    return this.getFluid();
                }

                public int getCapacity() {
                    return capacity;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    if (fluidStack != null && fluidStack.amount > 0) {
                        return this.acceptsFluid(fluidStack.getFluid()) && (side == null || this.canFill(side));
                    }
                    return false;
                }

                public boolean canFill() {
                    return this.canFill(side);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    if (fluidStack != null && fluidStack.amount > 0) {
                        return this.acceptsFluid(fluidStack.getFluid()) && (side == null || this.canDrain(side));
                    }
                    return false;
                }

                public boolean canDrain() {
                    return this.canDrain(side);
                }
            };
        }

        public boolean canFill(EnumFacing side) {
            return this.inputSides.contains(side);
        }

        public boolean canDrain(EnumFacing side) {
            return this.outputSides.contains(side);
        }
    }
}

