/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.componets.TypeUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public class ComponentUpgrade
extends AbstractComponent {
    private final List<TypeUpgrade> listUpgrade;
    private final List<TypeUpgrade> listActiveUpgrade = new ArrayList<TypeUpgrade>();
    private boolean change = true;

    public ComponentUpgrade(TileEntityInventory parent, TypeUpgrade ... typeUpgrades) {
        super(parent);
        this.listUpgrade = Arrays.asList(typeUpgrades);
    }

    public boolean isChange() {
        return this.change;
    }

    public void setChange(boolean change) {
        this.change = change;
    }

    public boolean hasUpgrade(TypeUpgrade typeUpgrade) {
        return this.listActiveUpgrade.contains((Object)typeUpgrade);
    }

    @Override
    public boolean canUsePurifier(EntityPlayer player) {
        return !this.listActiveUpgrade.isEmpty();
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> list = super.getDrops();
        for (TypeUpgrade upgrade : this.listActiveUpgrade) {
            list.add(upgrade.getStack().func_77946_l());
        }
        return list;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        TypeUpgrade type = this.listActiveUpgrade.remove(0);
        this.change = true;
        if (type != null) {
            return type.getStack().func_77946_l();
        }
        return super.getItemStackUpgrade();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        for (TypeUpgrade upgrade : this.listUpgrade) {
            if (!upgrade.getStack().func_77969_a(stack) || this.listActiveUpgrade.contains((Object)upgrade)) continue;
            this.listActiveUpgrade.add(upgrade);
            stack.func_190918_g(1);
            this.change = true;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74768_a("max", this.listActiveUpgrade.size());
        int i = 0;
        for (TypeUpgrade upgrade : this.listActiveUpgrade) {
            nbt.func_74768_a(String.valueOf(i), upgrade.ordinal());
            ++i;
        }
        return nbt;
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        buffer.writeInt(this.listActiveUpgrade.size());
        for (TypeUpgrade upgrade : this.listActiveUpgrade) {
            buffer.writeInt(upgrade.ordinal());
        }
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        int i = is.readInt();
        for (int j = 0; j < i; ++j) {
            this.listActiveUpgrade.add(TypeUpgrade.values()[is.readInt()]);
        }
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        int size = nbt.func_74762_e("max");
        TypeUpgrade[] values = TypeUpgrade.values();
        for (int i = 0; i < size; ++i) {
            this.listActiveUpgrade.add(values[nbt.func_74762_e(String.valueOf(i))]);
        }
    }
}

