/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.componets.AbstractComponent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;

public class ComponentProgress
extends AbstractComponent {
    private final short[] progress;
    private short maxValue;

    public ComponentProgress(TileEntityInventory parent, int col, short max) {
        super(parent);
        this.progress = new short[col];
        this.maxValue = max;
    }

    public short getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(short maxValue) {
        this.maxValue = maxValue;
    }

    public void addProgress() {
        this.addProgress(0);
    }

    public void addProgress(int col) {
        int n = col;
        this.progress[n] = (short)(this.progress[n] + 1);
    }

    public void addProgress(int col, short value) {
        int n = col;
        this.progress[n] = (short)(this.progress[n] + value);
    }

    public double getBar(int col) {
        return (double)this.progress[col] * 1.0 / (double)this.maxValue;
    }

    public short getProgress(int index) {
        return this.progress[index];
    }

    public short getProgress() {
        return this.getProgress(0);
    }

    public void setProgress(short col) {
        this.progress[0] = col;
    }

    public void cancellationProgress() {
        this.cancellationProgress(0);
    }

    public void setProgress(int index, short col) {
        this.progress[index] = col;
    }

    public void cancellationProgress(int index) {
        this.progress[index] = 0;
    }

    public double getBar() {
        return this.getBar(0);
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeShort(this.progress.length);
        for (short value : this.progress) {
            buffer.writeShort(value);
        }
        buffer.writeShort(this.maxValue);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeShort(this.progress.length);
        for (short value : this.progress) {
            buffer.writeShort(value);
        }
        buffer.writeShort(this.maxValue);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        int size = is.readShort();
        for (int i = 0; i < size; ++i) {
            this.progress[i] = is.readShort();
        }
        this.maxValue = is.readShort();
    }
}

