/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.api.item.IItemIgnoringNull;
import com.denfop.api.item.IMultiBlockItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.tile.IWrenchable;
import com.denfop.blocks.BlockBase;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.blocks.State;
import com.denfop.blocks.StateMapperIU;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.TypeProperty;
import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.items.block.ItemBlockTileEntity;
import com.denfop.network.packet.PacketLandEffect;
import com.denfop.network.packet.PacketRunParticles;
import com.denfop.render.base.ISpecialParticleModel;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleBaseBlockDust;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class BlockTileEntity
extends BlockBase
implements IWrenchable,
ITileEntityProvider {
    public static final Map<BlockPos, TileEntityBlock> teBlockDrop = new HashMap<BlockPos, TileEntityBlock>();
    public static final IProperty<EnumFacing> facingProperty = PropertyDirection.func_177714_a((String)"facing");
    public static TypeProperty currentTypeProperty;
    public final ItemBlockTileEntity item;
    public final TileBlockCreator.InfoAboutTile<?> teInfo;
    private final CreativeTabs tab;
    public final TypeProperty typeProperty = this.getTypeProperty();

    public BlockTileEntity(String name, ResourceLocation identifier, TileBlockCreator.InfoAboutTile<?> value) {
        super(null, value.getDefaultMaterial());
        this.item = new ItemBlockTileEntity(this, identifier);
        this.register(name, identifier, (Item)this.item);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.typeProperty, (Comparable)TypeProperty.invalid).func_177226_a(facingProperty, (Comparable)EnumFacing.DOWN));
        this.teInfo = value;
        this.tab = value.getTab();
        this.func_149672_a(value.getDefaultMaterial() == Material.field_151580_n ? SoundType.field_185854_g : SoundType.field_185851_d);
    }

    static BlockTileEntity create(String name, ResourceLocation identifier, TileBlockCreator.InfoAboutTile<?> value) {
        currentTypeProperty = new TypeProperty(identifier, value);
        BlockTileEntity ret = new BlockTileEntity(name, identifier, value);
        currentTypeProperty = null;
        return ret;
    }

    public static EnumFacing getItemFacing(IMultiTileBlock teBlock) {
        Set<EnumFacing> supported = teBlock.getSupportedFacings();
        if (supported.contains(EnumFacing.NORTH)) {
            return EnumFacing.NORTH;
        }
        return !supported.isEmpty() ? supported.iterator().next() : EnumFacing.DOWN;
    }

    private static TileEntityBlock getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityBlock ? (TileEntityBlock)te : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapperIU stateInvalid = new StateMapperIU(ModUtils.getName(IUItem.invalid));
        ModelResourceLocation invalidLocation = stateInvalid.func_178132_a(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.typeProperty, (Comparable)TypeProperty.invalid).func_177226_a(facingProperty, (Comparable)EnumFacing.NORTH));
        ModelLoader.setCustomStateMapper((Block)this, block -> block.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(state -> state, state -> {
            State stateProperty = (State)state.func_177229_b((IProperty)this.typeProperty);
            EnumFacing facing = (EnumFacing)state.func_177229_b(facingProperty);
            StateMapperIU stateMapper = new StateMapperIU(stateProperty.teBlock.getIdentifier());
            if (!(stateProperty.teBlock.getSupportedFacings().contains(facing) || facing == EnumFacing.DOWN && stateProperty.teBlock.getSupportedFacings().isEmpty())) {
                return invalidLocation;
            }
            return stateMapper.func_178132_a((IBlockState)state);
        })));
        ModelLoader.setCustomMeshDefinition((Item)this.item, stack -> {
            IMultiTileBlock teBlock;
            IMultiTileBlock iMultiTileBlock = teBlock = this.teInfo.getIdMap().isEmpty() ? null : this.teInfo.getIdMap().get(stack.func_77952_i());
            if (teBlock == null && !(this.teInfo.getListBlock().get(0) instanceof IItemIgnoringNull)) {
                return invalidLocation;
            }
            if (this.teInfo.getListBlock().get(0) instanceof IItemIgnoringNull) {
                teBlock = this.teInfo.getListBlock().get(0);
                StateMapperIU stateMapper = new StateMapperIU(teBlock.getIdentifier());
                IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.typeProperty, (Comparable)this.typeProperty.getState(teBlock));
                return stateMapper.func_178132_a(state);
            }
            if (teBlock instanceof IMultiBlockItem && ((IMultiBlockItem)((Object)teBlock)).hasUniqueRender(stack)) {
                ModelResourceLocation location = ((IMultiBlockItem)((Object)teBlock)).getModelLocation(stack);
                return location == null ? invalidLocation : location;
            }
            try {
                IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.typeProperty, (Comparable)this.typeProperty.getState(teBlock));
                StateMapperIU stateMapper = new StateMapperIU(teBlock.getIdentifier());
                if (state != null) {
                    return stateMapper.func_178132_a(state);
                }
                stateMapper = new StateMapperIU(ModUtils.getName(IUItem.invalid));
                return stateMapper.func_178132_a(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.typeProperty, (Comparable)TypeProperty.invalid));
            }
            catch (Exception e) {
                StateMapperIU stateMapper = new StateMapperIU(ModUtils.getName(IUItem.invalid));
                return stateMapper.func_178132_a(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.typeProperty, (Comparable)TypeProperty.invalid));
            }
        });
        boolean checkSpecialModels = this.teInfo.hasSpecialModels();
        for (TypeProperty.StatesBlocks statesBlocks : this.typeProperty.getAllStates()) {
            ModelResourceLocation model;
            if (!statesBlocks.hasItem()) continue;
            ModelResourceLocation modelResourceLocation = model = checkSpecialModels ? this.getSpecialModel(statesBlocks) : null;
            if (model == null) {
                IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.typeProperty, (Comparable)statesBlocks.statesBlocks.get(0));
                StateMapperIU stateMapper = new StateMapperIU(statesBlocks.getIdentifier());
                model = stateMapper.func_178132_a(state);
            }
            ModelBakery.registerItemVariants((Item)this.item, (ResourceLocation[])new ResourceLocation[]{model});
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? state : te.getExtendedState((TileEntityBlockStateContainer.PropertiesStateInstance)state);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getSpecialModel(TypeProperty.StatesBlocks blockTextures) {
        ItemStack stack;
        assert (blockTextures.getBlock() instanceof IMultiBlockItem);
        IMultiBlockItem block = (IMultiBlockItem)((Object)blockTextures.getBlock());
        return block.hasUniqueRender(stack = new ItemStack((Item)this.item, 1, blockTextures.getBlock().getId())) ? block.getModelLocation(stack) : null;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public BlockStateContainer func_180661_e() {
        return new TileEntityBlockStateContainer(this, this.getTypeProperty(), facingProperty);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.func_149915_a(world, this.getMetaFromState1(state));
    }

    public TileEntity func_149915_a(World world, int i) {
        if (i == -1) {
            return null;
        }
        IMultiTileBlock teBlock = this.item.getTeBlock(this.getItemStack(i));
        Class<? extends TileEntityBlock> teClass = teBlock.getTeClass();
        return TileEntityBlock.instantiate(teClass);
    }

    public int func_176201_c(IBlockState state) {
        State value = (State)state.func_177229_b((IProperty)this.getTypeProperty());
        return value.teBlock.getId() == -1 ? 0 : (value.teBlock.getId() >= 16 ? 15 : value.teBlock.getId());
    }

    public int getMetaFromState1(IBlockState state) {
        State value = (State)state.func_177229_b((IProperty)this.getTypeProperty());
        return value.teBlock.getId();
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        HashMap<ImmutableMap<IProperty<?>, Comparable<?>>, IBlockState> property = ((TileEntityBlockStateContainer.PropertiesStateInstance)this.func_176223_P()).getMapProperties();
        for (IBlockState state : property.values()) {
            State value = (State)state.func_177229_b((IProperty)this.getTypeProperty());
            if (value.state.equals("active")) continue;
            if (value.teBlock.getId() == -1 && meta == 0) {
                return state;
            }
            if (value.teBlock.getId() != meta) continue;
            return state;
        }
        return this.func_176223_P();
    }

    @NotNull
    public IBlockState getStateFromMeta1(ItemStack stack, EnumFacing facing) {
        IMultiTileBlock teBlock = this.item.getTeBlock(stack);
        if (facing == null) {
            return this.getState(teBlock);
        }
        return this.getState(teBlock, facing);
    }

    @NotNull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? state : te.getBlockState();
    }

    @Override
    public String func_149739_a() {
        return this.item.identifier.func_110624_b() + '.' + this.item.identifier.func_110623_a();
    }

    public void func_149666_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        if (tabs == this.tab || tabs == CreativeTabs.field_78027_g) {
            for (IMultiTileBlock type : this.teInfo.getListBlock()) {
                if (type.hasItem()) {
                    list.add((Object)this.getItemStack(type));
                }
                if (!type.hasOtherVersion()) continue;
                list.addAll(type.getOtherVersion(this.getItemStack(type)));
            }
        }
    }

    public Set<IMultiTileBlock> getAllTypes() {
        return Collections.unmodifiableSet(this.teInfo.getTeBlocks());
    }

    @NotNull
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te == null ? ModUtils.emptyStack : te.getItem(null, null);
    }

    @NotNull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te == null ? ModUtils.emptyStack : te.getPickBlock(player, target);
    }

    public IBlockState getState(IMultiTileBlock variant) {
        Set<EnumFacing> supportedFacings = variant.getSupportedFacings();
        EnumFacing facing = supportedFacings.isEmpty() ? EnumFacing.DOWN : (supportedFacings.contains(EnumFacing.NORTH) ? EnumFacing.NORTH : supportedFacings.iterator().next());
        return this.func_176223_P().func_177226_a((IProperty)this.typeProperty, (Comparable)this.typeProperty.getState(variant)).func_177226_a(facingProperty, (Comparable)facing);
    }

    public IBlockState getState(IMultiTileBlock variant, EnumFacing facing) {
        return this.func_176223_P().func_177226_a((IProperty)this.typeProperty, (Comparable)this.typeProperty.getState(variant)).func_177226_a(facingProperty, (Comparable)facing);
    }

    public ItemStack getItemStack(IMultiTileBlock type) {
        return new ItemStack((Item)this.item, 1, type.getId());
    }

    public ItemStack getItemStack(int type) {
        return new ItemStack((Item)this.item, 1, type);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean canReplace(World world, BlockPos pos, EnumFacing side, ItemStack stack) {
        if (ModUtils.isEmpty(stack)) {
            return true;
        }
        return stack.func_77973_b() == this.item;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        new PacketLandEffect((World)world, pos, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles);
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        new PacketRunParticles(world, pos, entity);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (pos != null && te.hasSpecialModel()) {
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(te.getBlockState());
            IBlockState state = te.getBlockState().func_177230_c().getExtendedState(te.getBlockState(), (IBlockAccess)world, pos);
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        ParticleBaseBlockDust particle = new ParticleBaseBlockDust(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0, state);
                        ((ISpecialParticleModel)model).enhanceParticle((Particle)particle, (TileEntityBlockStateContainer.PropertiesStateInstance)state);
                        particle.func_174845_l();
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        IBakedModel model;
        BlockPos pos = target.func_178782_a();
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        double offset = 0.1;
        AxisAlignedBB aabb = te.getVisualBoundingBox();
        double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - offset * 2.0) + offset + aabb.field_72340_a;
        double y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - offset * 2.0) + offset + aabb.field_72338_b;
        double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - offset * 2.0) + offset + aabb.field_72339_c;
        switch (target.field_178784_b) {
            case DOWN: {
                y = (double)pos.func_177956_o() + aabb.field_72338_b - offset;
                break;
            }
            case UP: {
                y = (double)pos.func_177956_o() + aabb.field_72337_e + offset;
                break;
            }
            case NORTH: {
                z = (double)pos.func_177952_p() + aabb.field_72339_c - offset;
                break;
            }
            case SOUTH: {
                z = (double)pos.func_177952_p() + aabb.field_72334_f + offset;
                break;
            }
            case WEST: {
                x = (double)pos.func_177958_n() + aabb.field_72340_a - offset;
                break;
            }
            case EAST: {
                x = (double)pos.func_177958_n() + aabb.field_72336_d + offset;
            }
        }
        ParticleBaseBlockDust particle = new ParticleBaseBlockDust(world, x, y, z, 0.0, 0.0, 0.0, te.getBlockState());
        particle.func_174846_a(pos);
        particle.func_70543_e(0.2f);
        particle.func_70541_f(0.6f);
        if (pos != null && te.hasSpecialModel() && (model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(te.getBlockState())) instanceof ISpecialParticleModel) {
            state = te.getBlockState().func_177230_c().getExtendedState(te.getBlockState(), (IBlockAccess)world, pos);
            ((ISpecialParticleModel)model).enhanceParticle((Particle)particle, (TileEntityBlockStateContainer.PropertiesStateInstance)state);
        }
        particle.func_174845_l();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        return true;
    }

    public Material func_149688_o(IBlockState state) {
        return this.field_149764_J;
    }

    public boolean func_176214_u(IBlockState state) {
        return this.func_149688_o(state).func_76230_c() && this.func_176223_P().func_185917_h();
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return !this.func_149688_o(world.func_180495_p(pos)).func_76230_c();
    }

    public boolean func_181623_g() {
        return super.func_181623_g();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.func_149688_o(state).func_186274_m();
    }

    public boolean func_149751_l(IBlockState state) {
        return !this.func_149688_o(state).func_76228_b();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149688_o(state).func_151565_r();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onPlaced(stack, placer, EnumFacing.UP);
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return super.func_180636_a(state, world, pos, start, end);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.func_185496_a(state, world, pos) : te.getVisualBoundingBox();
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te == null ? super.func_180640_a(state, world, pos) : te.getOutlineBoundingBox().func_186670_a(pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.func_180646_a(state, world, pos) : te.getPhysicsBoundingBox();
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity, boolean isActualState) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            super.func_185477_a(state, world, pos, mask, list, collidingEntity, isActualState);
        } else {
            te.addCollisionBoxesToList(mask, list, collidingEntity);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onEntityCollision(entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.func_176225_a(state, world, pos, side) : te.shouldSideBeRendered(side, pos.func_177972_a(side));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.doesSideBlockRendering(face);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.isNormalCube();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.isSideSolid(side);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.func_193383_a(world, state, pos, face) : te.getFaceShape(face);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
            return te != null && te.onSneakingActivated(player, hand, side, hitX, hitY, hitZ);
        }
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te != null && te.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onClicked(player);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onNeighborChange(neighborBlock, neighborPos);
        }
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? 0 : te.getWeakPower(side);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.canConnectRedstone(side);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te == null ? 0 : te.getComparatorInputOverride();
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onBlockBreak(false);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            if (!te.onRemovedByPlayer(player, willHarvest)) {
                return false;
            }
            teBlockDrop.put(pos, te);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntityBlock te;
        float ret = super.func_180647_a(state, player, world, pos);
        if (!player.func_184823_b(state) && (te = BlockTileEntity.getTe((IBlockAccess)world, pos)) != null && te.teBlock.getHarvestTool() == MultiTileBlock.HarvestTool.None) {
            ret *= 3.3333333f;
        }
        return ret;
    }

    public void func_176208_a(World p_176208_1_, BlockPos p_176208_2_, IBlockState p_176208_3_, EntityPlayer p_176208_4_) {
        p_176208_1_.func_184133_a(null, p_176208_2_, this.func_149688_o(p_176208_3_) == MultiTileBlock.MACHINE ? SoundEvents.field_187835_fT : SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 1.0f, 1.0f);
        super.func_176208_a(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        boolean ret = super.canHarvestBlock(world, pos, player);
        if (ret) {
            return ret;
        }
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        switch (te.teBlock.getHarvestTool()) {
            case None: {
                return true;
            }
            case Wrench: {
                ItemStack stack = player.func_184614_ca();
                if (stack.func_190926_b()) break;
                String tool = MultiTileBlock.HarvestTool.Pickaxe.toolClass;
                return stack.func_77973_b().getHarvestLevel(stack, tool, player, world.func_180495_p(pos)) >= MultiTileBlock.HarvestTool.Pickaxe.level;
            }
        }
        return false;
    }

    public String getHarvestTool(IBlockState state) {
        return state.func_177230_c() != this ? null : ((State)state.func_177229_b((IProperty)this.typeProperty)).teBlock.getHarvestTool().toolClass;
    }

    public int getHarvestLevel(IBlockState state) {
        return state.func_177230_c() != this ? 0 : ((State)state.func_177229_b((IProperty)this.typeProperty)).teBlock.getHarvestTool().level;
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        list.addAll(this.getDrops(world, pos, state, fortune));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack;
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            ItemStack stack2;
            te = teBlockDrop.get(pos);
            if (te == null) {
                return new ArrayList<ItemStack>();
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            boolean wasWrench = false;
            EntityPlayer player = (EntityPlayer)this.harvesters.get();
            if (player != null && !(stack2 = player.func_184614_ca()).func_190926_b()) {
                String tool = MultiTileBlock.HarvestTool.Wrench.toolClass;
                wasWrench = stack2.func_77973_b().getHarvestLevel(stack2, tool, player, state) >= MultiTileBlock.HarvestTool.Wrench.level;
            }
            ret.addAll(te.getSelfDrops(fortune, wasWrench));
            ret.addAll(te.getAuxDrops(fortune));
            teBlockDrop.remove(pos);
            return ret;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        boolean wasWrench = false;
        EntityPlayer player = (EntityPlayer)this.harvesters.get();
        if (player != null && !(stack = player.func_184614_ca()).func_190926_b()) {
            String tool = MultiTileBlock.HarvestTool.Wrench.toolClass;
            wasWrench = stack.func_77973_b().getHarvestLevel(stack, tool, player, state) >= MultiTileBlock.HarvestTool.Wrench.level;
        }
        ret.addAll(te.getSelfDrops(fortune, wasWrench));
        ret.addAll(te.getAuxDrops(fortune));
        return ret;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te == null ? 5.0f : te.getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return 5.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null || te.canEntityDestroy(entity);
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te == null ? EnumFacing.DOWN : te.getFacing();
    }

    @Override
    public boolean canSetFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te != null && te.canSetFacingWrench(newDirection, player);
    }

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te != null && te.setFacingWrench(newDirection, player);
    }

    @Override
    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return te != null && te.wrenchCanRemove(player);
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        List<ItemStack> list = ((TileEntityBlock)te).getWrenchDrops(player, fortune);
        return list;
    }

    @Override
    public void wrenchBreak(World world, BlockPos pos) {
        TileEntityBlock tileEntityBlock = (TileEntityBlock)world.func_175625_s(pos);
        if (tileEntityBlock != null) {
            tileEntityBlock.wrenchBreak();
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        return this.func_185467_w();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            EnumFacing target = te.getFacing().func_176732_a(axis.func_176740_k());
            if (te.getSupportedFacings().contains(target) && te.getFacing() != target) {
                te.setFacing(target);
                return true;
            }
        }
        return false;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return null;
        }
        Set<EnumFacing> facings = te.getSupportedFacings();
        return !facings.isEmpty() ? facings.toArray(new EnumFacing[0]) : null;
    }

    public ItemBlockTileEntity getItem() {
        return this.item;
    }

    public TypeProperty getTypeProperty() {
        return this.typeProperty != null ? this.typeProperty : currentTypeProperty;
    }
}

