/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.blocks.BlockBase;
import com.denfop.blocks.BlockResource;
import com.denfop.blocks.ISubEnum;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFoam
extends BlockBase {
    public static final PropertyEnum<FoamType> VARIANT = PropertyEnum.func_177709_a((String)"state", FoamType.class);

    public BlockFoam() {
        super("foam", Material.field_151580_n);
        this.func_149675_a(true);
        this.func_149711_c(0.01f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)FoamType.reinforced)));
    }

    public static float getHardenChance(World world, BlockPos pos, IBlockState state, FoamType type) {
        int light = world.func_175671_l(pos);
        if (!state.func_185916_f() && state.func_177230_c().getLightOpacity(state, (IBlockAccess)world, pos) == 0) {
            EnumFacing[] var5 = EnumFacing.field_82609_l;
            int var6 = var5.length;
            for (EnumFacing side : var5) {
                light = Math.max(light, world.func_175721_c(pos.func_177972_a(side), false));
            }
        }
        int avgTime = type.hardenTime * (16 - light);
        return 1.0f / (float)(avgTime * 20);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)FoamType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((FoamType)((Object)state.func_177229_b(VARIANT))).getId();
    }

    public IBlockState getState(FoamType type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        int tickSpeed = world.func_82736_K().func_180263_c("randomTickSpeed");
        if (tickSpeed <= 0) {
            throw new IllegalStateException("Foam was randomly ticked when world " + world + " isn't ticking?");
        }
        FoamType type = (FoamType)((Object)state.func_177229_b(VARIANT));
        float chance = BlockFoam.getHardenChance(world, pos, state, type) * 4096.0f / (float)tickSpeed;
        if (random.nextFloat() < chance) {
            world.func_175656_a(pos, ((FoamType)((Object)state.func_177229_b(VARIANT))).getResult());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack handItem = player.func_184586_b(hand);
        if (!handItem.func_190926_b() && handItem.func_77969_a(new ItemStack((Block)Blocks.field_150354_m))) {
            world.func_175656_a(pos, ((FoamType)((Object)state.func_177229_b(VARIANT))).getResult());
            handItem.func_190918_g(1);
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public static enum FoamType implements IStringSerializable,
    ISubEnum
    {
        reinforced(600);

        public final int hardenTime;

        private FoamType(int hardenTime) {
            this.hardenTime = hardenTime;
        }

        public String func_176610_l() {
            return this.name();
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        public IBlockState getResult() {
            return IUItem.blockResource.func_176203_a(BlockResource.Type.reinforced_stone.getMetadata());
        }
    }
}

