/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.energy.SystemTick;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportSink;
import com.denfop.api.transport.ITransportSource;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.TransportItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TransportNetLocal {
    final List<SystemTick<ITransportSource, TransportPath>> senderPath = new ArrayList<SystemTick<ITransportSource, TransportPath>>();
    private final World world;
    private final Map<BlockPos, ITransportTile> chunkCoordinatesITransportTileMap;
    final List<ITransportSource> sourceToUpdateList = new ArrayList<ITransportSource>();

    TransportNetLocal(World world) {
        this.world = world;
        this.chunkCoordinatesITransportTileMap = new HashMap<BlockPos, ITransportTile>();
    }

    public void remove1(ITransportSource par1) {
        for (SystemTick<ITransportSource, TransportPath> ticks : this.senderPath) {
            if (ticks.getSource() != par1) continue;
            ticks.setList(null);
            break;
        }
    }

    public void remove(ITransportSource par1) {
        this.senderPath.remove(new SystemTick(par1, null));
    }

    public void removeAll(List<SystemTick<ITransportSource, TransportPath>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<ITransportSource, TransportPath> iTransportSource : par1) {
            iTransportSource.setList(null);
        }
    }

    public boolean hasInSystem(ITransportAcceptor par1) {
        for (SystemTick<ITransportSource, TransportPath> entry : this.senderPath) {
            if (entry.getList() == null) continue;
            for (TransportPath path : entry.getList()) {
                if (!path.first.getBlockPos().equals((Object)par1.getBlockPos()) && !path.end.getBlockPos().equals((Object)par1.getBlockPos())) continue;
                return true;
            }
        }
        return false;
    }

    public List<SystemTick<ITransportSource, TransportPath>> getSources(ITransportAcceptor par1) {
        ArrayList<SystemTick<ITransportSource, TransportPath>> source = new ArrayList<SystemTick<ITransportSource, TransportPath>>();
        block0: for (SystemTick<ITransportSource, TransportPath> entry : this.senderPath) {
            if (entry.getList() == null) continue;
            for (TransportPath path : entry.getList()) {
                if (!(par1 instanceof ITransportConductor && path.conductors.contains(par1) || par1 instanceof ITransportSink && path.target == par1)) continue;
                source.add(entry);
                continue block0;
            }
        }
        return source;
    }

    public void addTile(ITransportTile tile1) {
        this.addTileEntity(tile1.getBlockPos(), tile1);
    }

    public boolean containsKey(SystemTick<ITransportSource, TransportPath> par1) {
        return this.senderPath.contains(par1);
    }

    public void addTileEntity(BlockPos coords, ITransportTile tile) {
        ITransportSource transportSource;
        if (this.chunkCoordinatesITransportTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesITransportTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof ITransportAcceptor) {
            if (tile instanceof ITransportSink) {
                ITransportSink transportSink = (ITransportSink)tile;
                if (transportSink.isSink()) {
                    this.onTileEntityAdded((ITransportAcceptor)tile);
                }
            } else {
                this.onTileEntityAdded((ITransportAcceptor)tile);
            }
        }
        if (tile instanceof ITransportSource && (transportSource = (ITransportSource)tile).isSource()) {
            this.senderPath.add(new SystemTick(tile, null));
        }
    }

    public void removeTile(ITransportTile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(ITransportTile tile) {
        if (!this.chunkCoordinatesITransportTileMap.containsKey(tile.getBlockPos())) {
            return;
        }
        this.chunkCoordinatesITransportTileMap.remove(tile.getBlockPos(), tile);
        this.update(tile.getBlockPos());
        if (tile instanceof ITransportAcceptor) {
            this.removeAll(this.getSources((ITransportAcceptor)tile));
            this.onTileEntityRemoved((ITransportAcceptor)tile);
        }
        if (tile instanceof ITransportSource) {
            this.remove((ITransportSource)tile);
        }
    }

    public boolean canInsertOrExtract(ITransportConductor transportConductor, ItemStack stack) {
        List<ItemStack> BlackItemStacks = transportConductor.getBlackListItems();
        if (BlackItemStacks.isEmpty()) {
            List<ItemStack> WhiteItemStacks = transportConductor.getWhiteListItems();
            if (!WhiteItemStacks.isEmpty()) {
                for (ItemStack stack1 : WhiteItemStacks) {
                    if (!stack1.func_77969_a(stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (ItemStack stack1 : BlackItemStacks) {
            if (!stack1.func_77969_a(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean canInsertOrExtract(ITransportConductor transportConductor, FluidStack stack) {
        List<FluidStack> BlackItemStacks = transportConductor.getBlackListFluids();
        if (BlackItemStacks.isEmpty()) {
            List<FluidStack> WhiteItemStacks = transportConductor.getWhiteListFluids();
            if (!WhiteItemStacks.isEmpty()) {
                for (FluidStack stack1 : WhiteItemStacks) {
                    if (!stack1.isFluidEqual(stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (FluidStack stack1 : BlackItemStacks) {
            if (!stack1.isFluidEqual(stack)) continue;
            return false;
        }
        return true;
    }

    public void emitTransportFrom(ITransportSource<ItemStack, IItemHandler> TransportSource, TransportItem<ItemStack> amount, List<TransportPath> TransportPaths, SystemTick<ITransportSource, TransportPath> tick) {
        List<ItemStack> list = amount.getList();
        List<Integer> list1 = amount.getList1();
        if (!list.isEmpty()) {
            for (TransportPath TransportPath2 : TransportPaths) {
                if (list.isEmpty()) break;
                ITransportSink TransportSink = TransportPath2.target;
                List<Integer> demandedTransport = TransportSink.getDemanded();
                if (demandedTransport.isEmpty() || !TransportSink.canAccept(TransportPath2.targetDirection.func_176734_d())) continue;
                for (Integer integer : demandedTransport) {
                    for (int i = 0; i < list1.size(); ++i) {
                        if (list.get(i).func_190926_b() || !this.canInsertOrExtract(TransportPath2.first, list.get(i)) || !this.canInsertOrExtract(TransportPath2.end, list.get(i))) continue;
                        ItemStack stack = ((IItemHandler)TransportSink.getHandler()).insertItem(integer.intValue(), list.get(i), true);
                        if (stack.func_190926_b() && stack.func_190916_E() != list.get(i).func_190916_E()) {
                            stack = ((IItemHandler)TransportSink.getHandler()).insertItem(integer.intValue(), list.get(i).func_77946_l(), false);
                            if (!stack.func_190926_b()) {
                                TransportSource.draw(stack, list1.get(i));
                                list.get(i).func_190920_e(stack.func_190916_E());
                            } else {
                                TransportSource.draw(list.get(i), list1.get(i));
                            }
                            list.get(i).func_190920_e(0);
                            continue;
                        }
                        if (stack.func_190926_b() || stack.func_190916_E() == list.get(i).func_190916_E()) continue;
                        stack = ((IItemHandler)TransportSink.getHandler()).insertItem(integer.intValue(), list.get(i).func_77946_l(), false);
                        stack.func_190920_e(list.get(i).func_190916_E() - stack.func_190916_E());
                        if (!stack.func_190926_b()) {
                            TransportSource.draw(stack, list1.get(i));
                            list.get(i).func_190920_e(stack.func_190916_E());
                        } else {
                            TransportSource.draw(list.get(i), list1.get(i));
                        }
                        list.get(i).func_190920_e(0);
                    }
                }
            }
        }
    }

    public TileEntity getTileFromITransport(ITransportTile tile) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof TileEntity) {
            return (TileEntity)tile;
        }
        return this.world.func_175625_s(tile.getBlockPos());
    }

    public List<TransportPath> discover(ITransportSource emitter) {
        HashMap<ITransportConductor, EnumFacing> reachedTileEntities = new HashMap<ITransportConductor, EnumFacing>();
        ArrayList tileEntitiesToCheck = new ArrayList();
        ArrayList<TransportPath> TransportPaths = new ArrayList<TransportPath>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            ITransportTile currentTileEntity = (ITransportTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<ITransportTile>> validReceivers = this.getValidReceivers(currentTileEntity, false);
            for (InfoTile<ITransportTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                if (validReceiver.tileEntity instanceof ITransportSink) {
                    TransportPaths.add(new TransportPath((ITransportSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity)) continue;
                reachedTileEntities.put((ITransportConductor)validReceiver.tileEntity, validReceiver.direction);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        block2: for (TransportPath TransportPath2 : TransportPaths) {
            ITransportTile tileEntity = TransportPath2.target;
            EnumFacing TransportBlockLink = TransportPath2.targetDirection;
            if (emitter == null) continue;
            while (tileEntity != emitter) {
                BlockPos te = tileEntity.getBlockPos();
                if (TransportBlockLink != null && te != null) {
                    tileEntity = this.getTileEntity(te.func_177972_a(TransportBlockLink));
                }
                if (!(tileEntity instanceof ITransportConductor)) continue block2;
                TransportPath2.conductors.add((ITransportConductor)tileEntity);
                TransportBlockLink = (EnumFacing)reachedTileEntities.get(tileEntity);
                if (TransportBlockLink == null) continue;
            }
        }
        return TransportPaths;
    }

    public ITransportTile getNeighbor(ITransportTile tile, EnumFacing dir) {
        if (tile == null) {
            return null;
        }
        return this.getTileEntity(tile.getBlockPos().func_177972_a(dir));
    }

    private List<InfoTile<ITransportTile>> getValidReceivers(ITransportTile emitter, boolean reverse) {
        LinkedList<InfoTile<ITransportTile>> validReceivers = new LinkedList<InfoTile<ITransportTile>>();
        for (EnumFacing direction : EnumFacing.values()) {
            ITransportAcceptor receiver2;
            ITransportEmitter sender2;
            ITransportTile target2 = this.getNeighbor(emitter, direction);
            if (target2 == null) continue;
            EnumFacing inverseDirection2 = direction.func_176734_d();
            if (reverse) {
                if (!(emitter instanceof ITransportAcceptor) || !(target2 instanceof ITransportEmitter) || !(sender2 = (ITransportEmitter)target2).emitsTo(receiver2 = (ITransportAcceptor)emitter, inverseDirection2) || !receiver2.acceptsFrom(sender2, direction)) continue;
                validReceivers.add(new InfoTile<ITransportTile>(target2, inverseDirection2));
                continue;
            }
            if (!(emitter instanceof ITransportEmitter) || !(target2 instanceof ITransportAcceptor) || !(sender2 = (ITransportEmitter)emitter).emitsTo(receiver2 = (ITransportAcceptor)target2, direction) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
            validReceivers.add(new InfoTile<ITransportTile>(target2, inverseDirection2));
        }
        return validReceivers;
    }

    public void onTickEnd() {
        if (this.sourceToUpdateList.size() > 0) {
            for (ITransportSource iTransportSource : this.sourceToUpdateList) {
                this.remove1(iTransportSource);
            }
            this.sourceToUpdateList.clear();
        }
        try {
            if (this.world.func_72820_D() % 4L == 0L) {
                for (SystemTick systemTick : this.senderPath) {
                    TransportItem<ItemStack> offered;
                    ITransportSource entry;
                    if (((ITransportSource)systemTick.getSource()).isItem() && (entry = (ITransportSource)systemTick.getSource()) != null) {
                        if (systemTick.getList() == null) {
                            List<TransportPath> TransportPaths = this.discover(entry);
                            for (TransportPath transportPaths : TransportPaths) {
                                transportPaths.first = transportPaths.getConductors().get(transportPaths.getConductors().size() - 1);
                                transportPaths.end = transportPaths.getConductors().get(0);
                            }
                            systemTick.setList(TransportPaths);
                        }
                        if (!(offered = entry.getOffered(0)).getList().isEmpty()) {
                            this.emitTransportFrom(entry, offered, systemTick.getList(), systemTick);
                        }
                    }
                    if (!((ITransportSource)systemTick.getSource()).isFluid() || (entry = (ITransportSource)systemTick.getSource()) == null) continue;
                    offered = entry.getOffered(1);
                    if (systemTick.getList() == null) {
                        List<TransportPath> TransportPaths = this.discover(entry);
                        for (TransportPath transportPaths : TransportPaths) {
                            transportPaths.first = transportPaths.getConductors().get(transportPaths.getConductors().size() - 1);
                            transportPaths.end = transportPaths.getConductors().get(0);
                        }
                        systemTick.setList(TransportPaths);
                    }
                    if (offered.getList().isEmpty()) continue;
                    this.emitTransportFluidFrom(entry, offered, systemTick.getList(), systemTick);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void emitTransportFluidFrom(ITransportSource<FluidStack, IFluidHandler> TransportSource, TransportItem<FluidStack> transportItem, List<TransportPath> TransportPaths, SystemTick<ITransportSource, TransportPath> tick) {
        List<FluidStack> list;
        if (TransportPaths == null) {
            TransportPaths = this.discover(TransportSource);
            for (TransportPath transportPaths : TransportPaths) {
                transportPaths.first = transportPaths.getConductors().get(transportPaths.getConductors().size() - 1);
                transportPaths.end = transportPaths.getConductors().get(0);
            }
            tick.setList(TransportPaths);
        }
        if (!(list = transportItem.getList()).isEmpty()) {
            for (TransportPath TransportPath2 : TransportPaths) {
                if (list.isEmpty()) break;
                if (!TransportPath2.target.canAccept(TransportPath2.targetDirection.func_176734_d())) continue;
                IFluidHandler handler = TransportPath2.getHandler();
                for (FluidStack fluidStack : list) {
                    int amount;
                    if (!this.canInsertOrExtract(TransportPath2.first, fluidStack) || !this.canInsertOrExtract(TransportPath2.end, fluidStack) || fluidStack.amount <= 0 || (amount = handler.fill(fluidStack, false)) <= 0) continue;
                    TransportSource.draw(fluidStack, handler.fill(fluidStack.copy(), true));
                }
            }
        }
    }

    public ITransportTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesITransportTileMap.get(pos);
    }

    public void update(BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos1 = pos.func_177972_a(dir);
            ITransportTile tile = this.chunkCoordinatesITransportTileMap.get(pos1);
            if (!(tile instanceof ITransportConductor)) continue;
            ((ITransportConductor)tile).update_render();
        }
    }

    public void onTileEntityAdded(ITransportAcceptor tile) {
        ArrayList<ITransportTile> tileEntitiesToCheck = new ArrayList<ITransportTile>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        blockPosList.add(tile.getBlockPos());
        tileEntitiesToCheck.add(tile);
        while (!tileEntitiesToCheck.isEmpty()) {
            ITransportTile currentTileEntity = (ITransportTile)tileEntitiesToCheck.remove(0);
            for (EnumFacing direction : EnumFacing.values()) {
                ITransportTile target2 = this.getTileEntity(currentTileEntity.getBlockPos().func_177972_a(direction));
                if (target2 == null || blockPosList.contains(target2.getBlockPos())) continue;
                blockPosList.add(target2.getBlockPos());
                if (target2 instanceof ITransportSource) {
                    if (this.sourceToUpdateList.contains((ITransportSource)target2)) continue;
                    this.sourceToUpdateList.add((ITransportSource)target2);
                    continue;
                }
                if (!(target2 instanceof ITransportConductor)) continue;
                tileEntitiesToCheck.add(target2);
            }
        }
    }

    public void onTileEntityRemoved(ITransportAcceptor par1) {
        this.onTileEntityAdded(par1);
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesITransportTileMap.clear();
    }

    public class TransportPath {
        final List<ITransportConductor> conductors;
        final ITransportSink target;
        final EnumFacing targetDirection;
        IFluidHandler fluidHandler = null;
        ITransportConductor first = null;
        ITransportConductor end = null;

        TransportPath(ITransportSink sink, EnumFacing facing) {
            this.target = sink;
            this.conductors = new ArrayList<ITransportConductor>();
            this.targetDirection = facing;
            if (this.target.getHandler() instanceof IFluidHandler) {
                this.fluidHandler = (IFluidHandler)TransportNetLocal.this.getTileFromITransport(this.target).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.targetDirection);
            }
        }

        public List<ITransportConductor> getConductors() {
            return this.conductors;
        }

        public IFluidHandler getHandler() {
            return this.fluidHandler;
        }
    }
}

