/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportSink;
import com.denfop.api.transport.ITransportSource;
import com.denfop.api.transport.ItemFluidHandler;
import com.denfop.api.transport.TransportItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class TransportFluidItemSinkSource
implements ITransportSource,
ITransportSink {
    private final BlockPos pos;
    private final ItemFluidHandler handler;
    private final int slots;
    private final List<Integer> list_limits;
    private int sinks;
    private int sources;
    private int sinksfluid;
    private int sourcesfluid;
    private boolean isSink;
    private boolean isSource;
    private boolean isSinkFluid;
    private boolean isSourceFluid;
    private boolean need_update = false;
    private List<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
    private List<EnumFacing> facingListSource = new ArrayList<EnumFacing>();

    public TransportFluidItemSinkSource(BlockPos pos, IItemHandler handler, IFluidHandler handler1, boolean isSink, boolean isSource, boolean isSinkFluid, boolean isSourceFluid) {
        int slots1;
        this.pos = pos;
        this.handler = new ItemFluidHandler(handler, handler1);
        try {
            slots1 = handler.getSlots();
        }
        catch (Exception exception) {
            slots1 = 0;
        }
        this.slots = slots1;
        this.isSink = isSink;
        this.isSource = isSource;
        this.isSinkFluid = isSinkFluid;
        this.isSourceFluid = isSourceFluid;
        this.list_limits = new ArrayList<Integer>();
        for (int i = 0; i < this.slots; ++i) {
            this.list_limits.add(handler.getSlotLimit(i));
        }
        this.sinks = isSink ? 1 : 0;
        this.sources = isSource ? 1 : 0;
        this.sinksfluid = isSinkFluid ? 1 : 0;
        this.sourcesfluid = isSourceFluid ? 1 : 0;
    }

    public void setFacingListSink(List<EnumFacing> facingListSink) {
        this.facingListSink = facingListSink;
    }

    public void setFacingListSource(List<EnumFacing> facingListSource) {
        this.facingListSource = facingListSource;
    }

    public boolean need_delete() {
        return !this.isSink && !this.isSinkFluid && !this.isSourceFluid && !this.isSource;
    }

    public boolean isNeed_update() {
        return this.need_update;
    }

    public void setNeed_update(boolean need_update) {
        this.need_update = need_update;
    }

    public boolean isSinkFluid() {
        return this.isSinkFluid;
    }

    public void setSinkFluid(boolean sinkFluid) {
        if (!sinkFluid) {
            if (this.sinksfluid == 1) {
                this.isSinkFluid = false;
                this.need_update = true;
            }
            --this.sinksfluid;
        } else {
            this.isSinkFluid = true;
            if (this.sinksfluid == 0) {
                this.need_update = true;
            }
            ++this.sinksfluid;
        }
    }

    public boolean isSourceFluid() {
        return this.isSourceFluid;
    }

    public void setSourceFluid(boolean sourceFluid) {
        if (!sourceFluid) {
            if (this.sourcesfluid == 1) {
                this.isSourceFluid = false;
                this.need_update = true;
            }
            --this.sourcesfluid;
        } else {
            this.isSourceFluid = true;
            if (this.sourcesfluid == 0) {
                this.need_update = true;
            }
            ++this.sourcesfluid;
        }
    }

    public IItemHandler getItemHandler() {
        return this.handler.getItemHandler();
    }

    public IFluidHandler getFluidHandler() {
        return this.handler.getFluidHandler();
    }

    @Override
    public boolean emitsTo(ITransportAcceptor var1, EnumFacing var2) {
        Object handler = var1.getHandler();
        if (this.isSource && handler instanceof IItemHandler) {
            return true;
        }
        return this.isSourceFluid && handler instanceof IFluidHandler;
    }

    public TransportItem getOffered(int type) {
        IFluidTankProperties[] fluidTanks;
        if (type == 0) {
            TransportItem transportItem = new TransportItem();
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            ArrayList<Integer> integerList = new ArrayList<Integer>();
            for (int i = 0; i < this.slots; ++i) {
                ItemStack stack = this.handler.extractItem(i, this.list_limits.get(i), true);
                if (stack.func_190926_b()) continue;
                itemStackList.add(stack);
                integerList.add(i);
            }
            transportItem.setList(itemStackList);
            transportItem.setList1(integerList);
            return transportItem;
        }
        TransportItem transportItem = new TransportItem();
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (IFluidTankProperties fluidTankProperties : fluidTanks = this.handler.getTankProperties()) {
            if (!fluidTankProperties.canDrain() || fluidTankProperties.getContents() == null) continue;
            fluidStackList.add(fluidTankProperties.getContents());
        }
        transportItem.setList(fluidStackList);
        return transportItem;
    }

    public void draw(Object var, int col) {
        if (this.isSource && var instanceof ItemStack) {
            this.handler.extractItem(col, ((ItemStack)var).func_190916_E(), false);
        }
        if (this.isSourceFluid && var instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)var;
            fluidStack = fluidStack.copy();
            fluidStack.amount = col;
            this.handler.drain(fluidStack, true);
        }
    }

    @Override
    public boolean isItem() {
        return this.isSource;
    }

    @Override
    public boolean isFluid() {
        return this.isSourceFluid;
    }

    @Override
    public boolean isSource() {
        return this.isSource || this.isSourceFluid;
    }

    public void setSource(boolean source) {
        if (!source) {
            if (this.sources == 1) {
                this.isSource = false;
                this.need_update = true;
            }
            --this.sources;
        } else {
            this.isSource = true;
            if (this.sources == 0) {
                this.need_update = true;
            }
            ++this.sources;
        }
    }

    @Override
    public Object getHandler() {
        if (this.handler.getFluidHandler() != null && this.handler.getItemHandler() != null) {
            return this.handler;
        }
        if (this.handler.getFluidHandler() == null) {
            return this.handler.getItemHandler();
        }
        if (this.handler.getItemHandler() == null) {
            return this.handler.getFluidHandler();
        }
        return this.handler;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public boolean acceptsFrom(ITransportEmitter var1, EnumFacing var2) {
        Object handler = var1.getHandler();
        if (this.isSink && handler instanceof IItemHandler) {
            return true;
        }
        return this.isSinkFluid && handler instanceof IFluidHandler;
    }

    @Override
    public List<Integer> getDemanded() {
        if (this.isSink) {
            int i = 0;
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Integer integer : this.list_limits) {
                ItemStack stack = this.handler.getStackInSlot(i);
                if (stack.func_190926_b() || stack.func_190916_E() < integer && integer <= stack.func_77976_d() || stack.func_190916_E() < stack.func_77976_d() && integer < stack.func_77976_d()) {
                    list.add(i);
                }
                ++i;
            }
            return list;
        }
        return null;
    }

    @Override
    public boolean isSink() {
        return this.isSink || this.isSinkFluid;
    }

    public void setSink(boolean sink) {
        if (!sink) {
            if (this.sinks == 1) {
                this.isSink = false;
                this.need_update = true;
            }
            --this.sinks;
        } else {
            this.isSink = true;
            if (this.sinks == 0) {
                this.need_update = true;
            }
            ++this.sinks;
        }
    }

    public List getItemStackFromFacing(EnumFacing facing) {
        return null;
    }

    @Override
    public boolean canAccept(EnumFacing facing) {
        return this.facingListSink.contains(facing);
    }

    @Override
    public void removeFacing(EnumFacing facing) {
        this.facingListSink.remove(facing);
    }

    @Override
    public boolean canAdd(EnumFacing facing) {
        if (!this.facingListSink.contains(facing)) {
            this.facingListSink.add(facing);
            return true;
        }
        return false;
    }

    @Override
    public List<EnumFacing> getFacingList() {
        return this.facingListSink;
    }
}

