/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.sytem;

import com.denfop.api.energy.NodeStats;
import com.denfop.api.energy.SystemTick;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.IDual;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ILocalNet;
import com.denfop.api.sytem.ISink;
import com.denfop.api.sytem.ISource;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.sytem.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class LocalNet
implements ILocalNet {
    final List<SystemTick<ISource, Path>> senderPath = new ArrayList<SystemTick<ISource, Path>>();
    final List<ISource> sourceToUpdateList = new ArrayList<ISource>();
    private final Map<BlockPos, ITile> chunkCoordinatesTileMap;
    private final EnergyType energyType;
    private final EnumFacing[] directions = EnumFacing.values();
    private int tick;

    public LocalNet(EnergyType energyType) {
        this.energyType = energyType;
        this.chunkCoordinatesTileMap = new HashMap<BlockPos, ITile>();
        this.tick = 0;
    }

    public void put(ISource par1, List<Path> par2) {
        this.senderPath.add(new SystemTick<ISource, Path>(par1, par2));
    }

    public boolean containsKey(SystemTick<ISource, Path> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(ISource par1) {
        return this.senderPath.contains(new SystemTick(par1, null));
    }

    public void remove1(ISource par1) {
        for (SystemTick<ISource, Path> ticks : this.senderPath) {
            if (ticks.getSource() != par1) continue;
            ticks.setList(null);
            break;
        }
    }

    public void remove(ISource par1) {
        this.senderPath.remove(new SystemTick(par1, null));
    }

    public void remove(SystemTick<ISource, Path> par1) {
        this.senderPath.remove(par1);
    }

    public void removeAll(List<SystemTick<ISource, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<ISource, Path> iSESource : par1) {
            iSESource.setList(null);
        }
    }

    @Override
    public List<Path> getPaths(IAcceptor par1) {
        ArrayList<Path> paths = new ArrayList<Path>();
        List<SystemTick<ISource, Path>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (SystemTick<ISource, Path> source : sources_list) {
            if (!this.containsKey(source)) continue;
            paths.addAll(source.getList());
        }
        return paths;
    }

    public List<SystemTick<ISource, Path>> getSources(IAcceptor par1) {
        ArrayList<SystemTick<ISource, Path>> source = new ArrayList<SystemTick<ISource, Path>>();
        block0: for (SystemTick<ISource, Path> entry : this.senderPath) {
            if (entry.getList() == null) continue;
            for (Path path : entry.getList()) {
                if (!(par1 instanceof IConductor && path.conductors.contains(par1) || par1 instanceof ISink && path.target == par1)) continue;
                source.add(entry);
                continue block0;
            }
        }
        return source;
    }

    public void clear() {
        for (SystemTick<ISource, Path> entry : this.senderPath) {
            List<Path> list = entry.getList();
            if (list == null) continue;
            for (Path SEPath : list) {
                SEPath.conductors.clear();
            }
        }
        this.senderPath.clear();
    }

    public SystemTick<ISource, Path> get(ISource tileEntity) {
        for (SystemTick<ISource, Path> entry : this.senderPath) {
            if (entry.getSource() != tileEntity) continue;
            return entry;
        }
        return null;
    }

    public double emitEnergyFrom(ISource energySource, double amount, SystemTick<ISource, Path> tick) {
        List<Path> energyPaths = tick.getList();
        if (energyPaths == null) {
            energyPaths = this.discover(energySource);
            tick.setList(energyPaths);
        }
        if (!(energySource instanceof IDual) && energySource.isSource()) {
            energySource.setPastEnergy(energySource.getPerEnergy());
        } else if (energySource instanceof IDual && energySource.isSource()) {
            ((IDual)energySource).setPastEnergy1(((IDual)energySource).getPerEnergy1());
        }
        if (amount > 0.0) {
            for (Path energyPath : energyPaths) {
                if (amount <= 0.0) break;
                ISink energySink = energyPath.target;
                double demandedEnergy = energySink.getDemanded();
                if (demandedEnergy <= 0.0) continue;
                double energyProvided = Math.min(demandedEnergy, amount);
                energySink.receivedEnergy(energyProvided);
                if (!(energySource instanceof IDual) && energySource.isSource()) {
                    energySource.addPerEnergy(energyProvided);
                } else if (energySource instanceof IDual && energySource.isSource()) {
                    ((IDual)energySource).addPerEnergy1(energyProvided);
                }
                energyPath.tick(this.tick, energyProvided);
                if (this.energyType.isDraw()) {
                    amount -= energyProvided;
                    amount = Math.max(0.0, amount);
                }
                if (!this.energyType.isBreak_conductors() || !(energyProvided > energyPath.min)) continue;
                for (IConductor HeatConductor : energyPath.conductors) {
                    if (!(HeatConductor.getConductorBreakdownEnergy(this.energyType) < energyProvided)) break;
                    HeatConductor.removeConductor();
                }
            }
        }
        return amount;
    }

    @Override
    public void TickEnd() {
        if (this.sourceToUpdateList.size() > 0) {
            for (ISource iSource : this.sourceToUpdateList) {
                this.remove1(iSource);
            }
            this.sourceToUpdateList.clear();
        }
        for (SystemTick systemTick : this.senderPath) {
            double offer;
            ISource entry = (ISource)systemTick.getSource();
            if (systemTick.getList() != null && systemTick.getList().isEmpty() || entry == null) continue;
            if (entry.isSource()) {
                if (entry instanceof IDual) {
                    ((IDual)entry).setPastEnergy1(((IDual)entry).getPastEnergy1());
                } else {
                    entry.setPastEnergy(entry.getPerEnergy());
                }
            }
            if ((offer = entry.canProvideEnergy()) > 0.0) {
                double removed = offer - this.emitEnergyFrom(entry, offer, systemTick);
                if (!this.energyType.isDraw()) continue;
                entry.extractEnergy(removed);
                continue;
            }
            if (!entry.isSource()) continue;
            if (entry instanceof IDual) {
                ((IDual)entry).setPastEnergy1(((IDual)entry).getPastEnergy1());
                continue;
            }
            entry.setPastEnergy(entry.getPerEnergy());
        }
        ++this.tick;
    }

    public double getTotalEmitted(ITile tileEntity) {
        double ret = 0.0;
        int col = 0;
        if (tileEntity instanceof IConductor) {
            for (Path energyPath : this.getPaths((IAcceptor)tileEntity)) {
                if (!energyPath.conductors.contains(tileEntity)) continue;
                ret += this.getTotalAccepted(energyPath.target);
                ++col;
            }
        }
        if (tileEntity instanceof ISource) {
            ISource advEnergySource = (ISource)tileEntity;
            if (!(advEnergySource instanceof IDual) && advEnergySource.isSource()) {
                ret = Math.max(0.0, advEnergySource.getPerEnergy() - advEnergySource.getPastEnergy());
            } else if (advEnergySource instanceof IDual && advEnergySource.isSource()) {
                IDual dual = (IDual)advEnergySource;
                ret = Math.max(0.0, dual.getPerEnergy1() - dual.getPastEnergy1());
            }
        }
        return col == 0 ? ret : ret / (double)col;
    }

    public double getTotalAccepted(ITile tileEntity) {
        ISink advEnergySink;
        double ret = 0.0;
        if (tileEntity instanceof ISink && (advEnergySink = (ISink)tileEntity).isSink() && ((double)(this.tick - 1) == advEnergySink.getTick() || (double)this.tick == advEnergySink.getTick() || (double)(this.tick + 1) == advEnergySink.getTick())) {
            ret = Math.max(0.0, advEnergySink.getPerEnergy() - advEnergySink.getPastEnergy());
        }
        return ret;
    }

    @Override
    public void update(BlockPos pos1) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos = pos1.func_177972_a(dir);
            ITile tile = this.chunkCoordinatesTileMap.get(pos);
            if (!(tile instanceof IConductor)) continue;
            ((IConductor)tile).update_render();
        }
    }

    @Override
    public NodeStats getNodeStats(ITile tile) {
        double emitted = this.getTotalEmitted(tile);
        double received = this.getTotalAccepted(tile);
        return new NodeStats(received, emitted);
    }

    @Override
    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesTileMap.clear();
    }

    @Override
    public ITile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesTileMap.get(pos);
    }

    @Override
    public void addTile(ITile tile1) {
        this.addTileEntity(tile1.getBlockPos(), tile1);
    }

    public ITile getNeighbor(ITile tile, EnumFacing dir) {
        if (tile == null) {
            return null;
        }
        return this.getTileEntity(tile.getBlockPos().func_177972_a(dir));
    }

    @Override
    public void removeTile(ITile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(ITile tile) {
        if (!this.chunkCoordinatesTileMap.containsKey(tile.getBlockPos())) {
            return;
        }
        BlockPos coord = tile.getBlockPos();
        this.chunkCoordinatesTileMap.remove(coord);
        this.update(coord);
        if (tile instanceof IAcceptor) {
            this.removeAll(this.getSources((IAcceptor)tile));
            this.onTileEntityRemoved((IAcceptor)tile);
        }
        if (tile instanceof ISource) {
            this.remove((ISource)tile);
        }
    }

    public List<Path> discover(ISource emitter) {
        HashMap<IConductor, EnumFacing> reachedTileEntities = new HashMap<IConductor, EnumFacing>();
        ArrayList<ISource> tileEntitiesToCheck = new ArrayList<ISource>();
        ArrayList<Path> Paths = new ArrayList<Path>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            ITile currentTileEntity = (ITile)tileEntitiesToCheck.remove(0);
            List<InfoTile<ITile>> validReceivers = this.getValidReceivers(currentTileEntity, false);
            for (InfoTile<ITile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                if (validReceiver.tileEntity instanceof ISink) {
                    Paths.add(new Path((ISink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (reachedTileEntities.containsKey((IConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.put((IConductor)validReceiver.tileEntity, validReceiver.direction);
                tileEntitiesToCheck.add((ISource)validReceiver.tileEntity);
            }
        }
        block2: for (Path Path2 : Paths) {
            ITile tileEntity = Path2.target;
            EnumFacing QEBlockLink = Path2.targetDirection;
            BlockPos te = Path2.target.getBlockPos();
            if (emitter == null) continue;
            while (tileEntity != emitter) {
                if (QEBlockLink != null && te != null) {
                    tileEntity = this.getTileEntity(te.func_177972_a(QEBlockLink));
                    te = te.func_177972_a(QEBlockLink);
                }
                if (!(tileEntity instanceof IConductor)) continue block2;
                IConductor Conductor = (IConductor)tileEntity;
                Path2.conductors.add(Conductor);
                if (Conductor.getConductorBreakdownEnergy(this.energyType) - 1.0 < Path2.getMin()) {
                    Path2.setMin(Conductor.getConductorBreakdownEnergy(this.energyType) - 1.0);
                }
                if ((QEBlockLink = (EnumFacing)reachedTileEntities.get(tileEntity)) != null) continue;
                assert (te != null);
                throw new NullPointerException("BlockPos is null");
            }
        }
        return Paths;
    }

    public List<InfoTile<ITile>> getValidReceivers(ITile emitter, boolean reverse) {
        LinkedList<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
        for (EnumFacing direction : this.directions) {
            IAcceptor receiver2;
            IEmitter sender2;
            ITile target2 = this.getNeighbor(emitter, direction);
            if (target2 == null) continue;
            EnumFacing inverseDirection2 = direction.func_176734_d();
            if (reverse) {
                if (!(emitter instanceof IAcceptor) || !(target2 instanceof IEmitter) || !(sender2 = (IEmitter)target2).emitsTo(receiver2 = (IAcceptor)emitter, inverseDirection2) || !receiver2.acceptsFrom(sender2, direction)) continue;
                validReceivers.add(new InfoTile<ITile>(target2, inverseDirection2));
                continue;
            }
            if (!(emitter instanceof IEmitter) || !(target2 instanceof IAcceptor) || !(sender2 = (IEmitter)emitter).emitsTo(receiver2 = (IAcceptor)target2, direction) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
            validReceivers.add(new InfoTile<ITile>(target2, inverseDirection2));
        }
        return validReceivers;
    }

    public void addTileEntity(BlockPos coords, ITile tile) {
        if (this.chunkCoordinatesTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof IAcceptor) {
            this.onTileEntityAdded((IAcceptor)tile);
        }
        if (tile instanceof ISource) {
            this.senderPath.add(new SystemTick((ISource)tile, null));
        }
    }

    public void onTileEntityAdded(IAcceptor tile) {
        ArrayList<ITile> tileEntitiesToCheck = new ArrayList<ITile>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        blockPosList.add(tile.getBlockPos());
        tileEntitiesToCheck.add(tile);
        while (!tileEntitiesToCheck.isEmpty()) {
            ITile currentTileEntity = (ITile)tileEntitiesToCheck.remove(0);
            for (EnumFacing direction : EnumFacing.values()) {
                ITile target2 = this.getTileEntity(currentTileEntity.getBlockPos().func_177972_a(direction));
                if (target2 == null || blockPosList.contains(target2.getBlockPos())) continue;
                blockPosList.add(target2.getBlockPos());
                if (target2 instanceof ISource) {
                    if (this.sourceToUpdateList.contains((ISource)target2)) continue;
                    this.sourceToUpdateList.add((ISource)target2);
                    continue;
                }
                if (!(target2 instanceof IConductor)) continue;
                tileEntitiesToCheck.add(target2);
            }
        }
    }

    public void onTileEntityRemoved(IAcceptor par1) {
        this.onTileEntityAdded(par1);
    }
}

