/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.research;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.EnumOperation;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.IResearchSystem;
import com.denfop.api.space.research.IResearchTable;
import com.denfop.api.space.rovers.IRovers;
import java.util.Iterator;
import java.util.List;

public class BaseSpaceResearchSystem
implements IResearchSystem {
    @Override
    public void sendingOperation(IRovers rovers, IBody body, IResearchTable table) {
        if (this.canSendingOperation(rovers, body, table)) {
            if (body instanceof IPlanet) {
                FakePlanet fakeplanet = new FakePlanet(table.getPlayer(), (IPlanet)body, rovers, new Data(table.getPlayer(), body));
                if (!SpaceNet.instance.getFakeSpaceSystem().getFakePlayers().contains(table.getPlayer())) {
                    SpaceNet.instance.getFakeSpaceSystem().getFakePlayers().add(table.getPlayer());
                }
                SpaceNet.instance.getFakeSpaceSystem().addFakePlanet(fakeplanet);
                table.getSpaceBody().put(body, new SpaceOperation(fakeplanet.getPlanet(), EnumOperation.WAIT));
            }
            if (body instanceof ISatellite) {
                FakeSatellite fakeSatellite = new FakeSatellite(table.getPlayer(), (ISatellite)body, rovers, new Data(table.getPlayer(), body));
                if (!SpaceNet.instance.getFakeSpaceSystem().getFakePlayers().contains(table.getPlayer())) {
                    SpaceNet.instance.getFakeSpaceSystem().getFakePlayers().add(table.getPlayer());
                }
                SpaceNet.instance.getFakeSpaceSystem().addFakeSatellite(fakeSatellite);
                table.getSpaceBody().put(body, new SpaceOperation(fakeSatellite.getSatellite(), EnumOperation.WAIT));
            }
        }
    }

    @Override
    public boolean canSendingOperation(IRovers rovers, IBody body, IResearchTable table) {
        if (body instanceof IPlanet && SpaceNet.instance.getFakeSpaceSystem().cadAddFakePlanet(new FakePlanet(table.getPlayer(), (IPlanet)body, rovers, new Data(table.getPlayer(), body)))) {
            return table.getLevel().ordinal() > ((IPlanet)body).getLevels().ordinal() && (!table.getSpaceBody().containsKey(body) || table.getSpaceBody().get(body) != null && table.getSpaceBody().get(body).getOperation() != EnumOperation.WAIT);
        }
        if (body instanceof ISatellite && SpaceNet.instance.getFakeSpaceSystem().cadAddFakeSatellite(new FakeSatellite(table.getPlayer(), (ISatellite)body, rovers, new Data(table.getPlayer(), body)))) {
            return table.getLevel().ordinal() > ((ISatellite)body).getLevels().ordinal() && (!table.getSpaceBody().containsKey(body) || table.getSpaceBody().get(body) != null && table.getSpaceBody().get(body).getOperation() != EnumOperation.WAIT);
        }
        return false;
    }

    @Override
    public void returnOperation(IBody body, IResearchTable table) {
        if (body instanceof IPlanet) {
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(table.getPlayer());
            IFakePlanet fakePlanet = null;
            for (IFakeBody iFakeBody : list) {
                if (!iFakeBody.matched(body)) continue;
                fakePlanet = (IFakePlanet)iFakeBody;
                break;
            }
            if (fakePlanet != null) {
                fakePlanet.setEnd();
                if (table.getContainerBlock() != null) {
                    List<IBaseResource> resourceList = SpaceNet.instance.getFakeSpaceSystem().getFakePlanetListMap().get(fakePlanet);
                    for (IBaseResource resource : resourceList) {
                        table.getContainerBlock().getSlotOutput().add(resource.getItemStack());
                    }
                    table.getContainerBlock().getSlotOutput().add(fakePlanet.getRover().getItemStack());
                    SpaceNet.instance.getFakeSpaceSystem().getFakePlanetListMap().remove(fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().getFakePlanetList().remove(fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().removeFakeBodyFromPlayer(table, fakePlanet.getPlanet());
                    table.getSpaceBody().get(fakePlanet.getPlanet()).setOperation(EnumOperation.FAIL);
                    fakePlanet.remove();
                }
            }
        } else if (body instanceof ISatellite) {
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(table.getPlayer());
            IFakeSatellite fakeSatellite = null;
            for (IFakeBody iFakeBody : list) {
                if (!iFakeBody.matched(body)) continue;
                fakeSatellite = (IFakeSatellite)iFakeBody;
                break;
            }
            if (fakeSatellite != null) {
                fakeSatellite.setEnd();
                if (table.getContainerBlock() != null) {
                    List<IBaseResource> resourceList = SpaceNet.instance.getFakeSpaceSystem().getFakeSatelliteListMap().get(fakeSatellite);
                    Iterator iterator = resourceList.iterator();
                    while (iterator.hasNext()) {
                        IBaseResource resource = (IBaseResource)iterator.next();
                        table.getContainerBlock().getSlotOutput().add(resource.getItemStack());
                    }
                    table.getContainerBlock().getSlotOutput().add(fakeSatellite.getRover().getItemStack());
                    SpaceNet.instance.getFakeSpaceSystem().getFakeSatelliteListMap().remove(fakeSatellite);
                    SpaceNet.instance.getFakeSpaceSystem().getFakeSatelliteList().remove(fakeSatellite);
                    SpaceNet.instance.getFakeSpaceSystem().removeFakeBodyFromPlayer(table, fakeSatellite.getSatellite());
                    table.getSpaceBody().get(fakeSatellite.getSatellite()).setOperation(EnumOperation.FAIL);
                    fakeSatellite.remove();
                }
            }
        }
    }
}

