/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.EnumFluidFactory;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IColonyFluidFactory;
import com.denfop.api.space.colonies.IStorage;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FluidFactory
extends Building
implements IColonyFluidFactory {
    private final EnumFluidFactory type;

    public FluidFactory(String name, IColony colonie, EnumFluidFactory type) {
        super(name, colonie);
        this.type = type;
        this.getColony().addConsumeEnergy(this.getEnergy());
        this.getColony().addNeededWorkers(this.getNeedPeople());
        this.getColony().addNeedProtection(this.getNeedProtection());
    }

    public FluidFactory(NBTTagCompound tag, IColony colonie) {
        super(tag.func_74779_i("name"), colonie);
        this.type = EnumFluidFactory.getID(tag.func_74762_e("id"));
    }

    @Override
    public void work() {
        List<IStorage> storageList = this.getColony().getStorageList();
        if (storageList.isEmpty() || this.getColony().getEnergy() < this.getEnergy()) {
            return;
        }
        for (IStorage storage : storageList) {
            if (!storage.canAddFluidStack(this.getStack())) continue;
            this.getColony().useEnergy(this.getEnergy());
            return;
        }
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74768_a("id", this.type.ordinal());
        tag.func_74778_a("type", "fluidfactory");
        return tag;
    }

    @Override
    public void remove() {
    }

    @Override
    public int getEnergy() {
        return this.type.getEnergy();
    }

    @Override
    public FluidStack getStack() {
        return this.type.getStack();
    }

    @Override
    public int getNeedPeople() {
        return this.type.getNeedPeople();
    }

    @Override
    public int getNeedProtection() {
        return this.type.getNeedProtection();
    }

    @Override
    public EnumFluidFactory getFactory() {
        return this.type;
    }
}

