/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.EnumTypeFactory;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IFactory;
import net.minecraft.nbt.NBTTagCompound;

public class Factory
extends Building
implements IFactory {
    public final EnumTypeFactory typeFactory;

    public Factory(String name, IColony colonie, EnumTypeFactory typeFactory) {
        super(name, colonie);
        this.typeFactory = typeFactory;
        this.getColony().addWorkers(this.getWorkers());
        this.getColony().addConsumeEnergy(this.getEnergy());
    }

    public Factory(NBTTagCompound tag, IColony colonie) {
        super(tag.func_74779_i("name"), colonie);
        int id = tag.func_74762_e("id");
        this.typeFactory = EnumTypeFactory.getID(id);
        this.getColony().addWorkers(this.getWorkers());
        this.getColony().addConsumeEnergy(this.getEnergy());
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74778_a("type", "factory");
        tag.func_74768_a("id", this.getType().ordinal());
        return tag;
    }

    @Override
    public void work() {
    }

    @Override
    public void remove() {
    }

    @Override
    public int getWorkers() {
        return this.getType().getPeople();
    }

    @Override
    public int getEnergy() {
        return this.getType().getEnergy();
    }

    @Override
    public EnumTypeFactory getType() {
        return this.typeFactory;
    }
}

