/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IColonyNet;
import com.denfop.api.space.fakebody.FakePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ColonyNet
implements IColonyNet {
    Map<FakePlayer, List<IColony>> fakePlayerListMap = new HashMap<FakePlayer, List<IColony>>();
    List<IColony> colonyList = new ArrayList<IColony>();
    List<FakePlayer> fakePlayerList = new ArrayList<FakePlayer>();

    @Override
    public Map<FakePlayer, List<IColony>> getMap() {
        return this.fakePlayerListMap;
    }

    @Override
    public boolean canAddColony(IBody body, FakePlayer player) {
        if (!this.fakePlayerListMap.containsKey(player)) {
            return true;
        }
        List<IColony> list = this.fakePlayerListMap.get(player);
        for (IColony colony : list) {
            if (!colony.matched(body)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addColony(IBody body, FakePlayer player) {
        if (this.canAddColony(body, player)) {
            Colony colony = new Colony(body, player);
            if (!this.fakePlayerListMap.containsKey(player)) {
                ArrayList<Colony> colonyList = new ArrayList<Colony>();
                colonyList.add(colony);
                this.fakePlayerListMap.put(player, colonyList);
                this.fakePlayerList.add(player);
            } else {
                List<IColony> colonyList = this.fakePlayerListMap.get(player);
                colonyList.add(colony);
            }
            this.colonyList.add(colony);
        }
    }

    @Override
    public void removeColony(IColony colony, FakePlayer player) {
        List<IColony> colonyList = this.fakePlayerListMap.get(player);
        colonyList.remove(colony);
        this.colonyList.remove(colony);
    }

    @Override
    public void working() {
        for (IColony colony : this.colonyList) {
            colony.update();
        }
    }

    @Override
    public List<IColony> getColonies() {
        return this.colonyList;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound tag, FakePlayer player) {
        List<IColony> list = this.fakePlayerListMap.get(player);
        NBTTagCompound nbt = new NBTTagCompound();
        for (IColony colonie : list) {
            nbt.func_74782_a(colonie.getBody().getName(), (NBTBase)colonie.writeNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("player", (NBTBase)player.writeNBT());
        tag.func_74782_a("colonia", (NBTBase)nbt);
        return tag;
    }

    @Override
    public void addColony(NBTTagCompound tag) {
        NBTTagCompound nbt = tag.func_74775_l("colonia");
        NBTTagCompound tagplayer = nbt.func_74775_l("player");
        FakePlayer player = new FakePlayer(tagplayer.func_74779_i("name"), tagplayer.func_74775_l("tag"));
        if (this.fakePlayerList.contains(player)) {
            return;
        }
        for (IBody body : SpaceNet.instance.getBodyList()) {
            List<Object> list;
            if (!nbt.func_74764_b(body.getName())) continue;
            NBTTagCompound nbt1 = nbt.func_74775_l(body.getName());
            Colony colonie = new Colony(nbt1, player);
            if (!this.fakePlayerListMap.containsKey(player)) {
                list = new ArrayList<Colony>();
                list.add(colonie);
                this.fakePlayerListMap.put(player, this.colonyList);
                this.fakePlayerList.add(player);
                continue;
            }
            list = this.fakePlayerListMap.get(player);
            list.add(colonie);
        }
    }

    @Override
    public List<FakePlayer> getList() {
        return this.fakePlayerList;
    }

    @Override
    public void unload() {
        this.fakePlayerListMap.clear();
        this.colonyList.clear();
        this.fakePlayerList.clear();
    }
}

