/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IFluidRecipes;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IRecipeInputFluidStack;
import com.denfop.api.recipe.RecipeInputFluidStack;
import com.denfop.api.recipe.RecipeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;

public class RecipesFluidCore
implements IFluidRecipes {
    private final List<IHasRecipe> recipes = new ArrayList<IHasRecipe>();
    private final List<String> registeredRecipes = new ArrayList<String>();
    public Map<String, IBaseRecipe> map_recipe_managers = new HashMap<String, IBaseRecipe>();
    public Map<String, List<IRecipeInputFluidStack>> map_recipe_managers_itemStack = new HashMap<String, List<IRecipeInputFluidStack>>();
    public Map<String, List<BaseFluidMachineRecipe>> map_recipes_fluid = new HashMap<String, List<BaseFluidMachineRecipe>>();

    public void init() {
        this.addRecipeManager("obsidian", 2, true);
        this.addRecipeManager("mixer", 1, true);
        this.addRecipeManager("replicator", 1, true);
        this.addRecipeManager("mixer_double", 1, true);
    }

    public void addRecipeManager(String name, int size, boolean consume) {
        this.map_recipe_managers.put(name, new RecipeManager(name, size, consume, true));
    }

    public IBaseRecipe getRecipeFromName(String name) {
        return this.map_recipe_managers.get(name);
    }

    public void addInitRecipes(IHasRecipe hasRecipe) {
        this.recipes.add(hasRecipe);
    }

    public void initializationRecipes() {
        this.recipes.forEach(iHasRecipe -> {
            if (!this.registeredRecipes.contains(iHasRecipe.getName())) {
                this.registeredRecipes.add(iHasRecipe.getName());
                iHasRecipe.init();
            }
        });
    }

    public void addRecipe(String name, BaseFluidMachineRecipe recipe) {
        if (!this.map_recipes_fluid.containsKey(name)) {
            List<FluidStack> iRecipeInputList = recipe.input.getInputs();
            ArrayList<RecipeInputFluidStack> inputStackList = new ArrayList<RecipeInputFluidStack>();
            for (FluidStack recipeInput : iRecipeInputList) {
                inputStackList.add(new RecipeInputFluidStack(recipeInput));
            }
            this.map_recipe_managers_itemStack.put(name, inputStackList);
            ArrayList<BaseFluidMachineRecipe> lst = new ArrayList<BaseFluidMachineRecipe>();
            lst.add(recipe);
            this.map_recipes_fluid.put(name, lst);
        } else {
            List<IRecipeInputFluidStack> iRecipeInputList = this.map_recipe_managers_itemStack.get(name);
            if (iRecipeInputList.isEmpty()) {
                for (FluidStack input1 : recipe.input.getInputs()) {
                    iRecipeInputList.add(new RecipeInputFluidStack(input1));
                }
            } else {
                for (FluidStack stack : recipe.input.getInputs()) {
                    boolean continues1 = false;
                    for (IRecipeInputFluidStack input : iRecipeInputList) {
                        if (input.matched(stack)) continue;
                        iRecipeInputList.add(new RecipeInputFluidStack(stack));
                        continues1 = true;
                        break;
                    }
                    if (!continues1) continue;
                    break;
                }
            }
            this.map_recipe_managers_itemStack.replace(name, iRecipeInputList);
            this.map_recipes_fluid.get(name).add(recipe);
        }
    }

    public List<BaseFluidMachineRecipe> getRecipeList(String name) {
        return this.map_recipes_fluid.get(name);
    }

    public BaseFluidMachineRecipe getRecipeOutput(IBaseRecipe recipe, List<BaseFluidMachineRecipe> recipes, boolean adjustInput, FluidStack ... stacks) {
        List<FluidStack> stack1 = Arrays.asList(stacks);
        int size = recipe.getSize();
        for (BaseFluidMachineRecipe baseMachineRecipe : recipes) {
            List<FluidStack> recipeInputList = baseMachineRecipe.input.getInputs();
            boolean need = true;
            for (int i = 0; i < size; ++i) {
                if (!recipeInputList.get(i).isFluidEqual(stack1.get(i))) {
                    need = true;
                    break;
                }
                if (recipeInputList.get((int)i).amount > stack1.get((int)i).amount) {
                    need = true;
                    break;
                }
                need = false;
            }
            if (need) continue;
            if (adjustInput) {
                for (int j = 0; j < stack1.size(); ++j) {
                    stack1.get((int)j).amount -= recipeInputList.get((int)j).amount;
                }
                continue;
            }
            return baseMachineRecipe;
        }
        return null;
    }

    public BaseFluidMachineRecipe getRecipeOutput(IBaseRecipe recipe, List<BaseFluidMachineRecipe> recipes, boolean adjustInput, List<FluidStack> stacks) {
        int size = recipe.getSize();
        for (BaseFluidMachineRecipe baseMachineRecipe : recipes) {
            List<FluidStack> recipeInputList = baseMachineRecipe.input.getInputs();
            boolean need = true;
            for (int i = 0; i < size; ++i) {
                if (!recipeInputList.get(i).isFluidEqual(stacks.get(i))) {
                    need = true;
                    break;
                }
                if (recipeInputList.get((int)i).amount > stacks.get((int)i).amount) {
                    need = true;
                    break;
                }
                need = false;
            }
            if (need) continue;
            if (adjustInput) {
                for (int j = 0; j < stacks.size(); ++j) {
                    stacks.get((int)j).amount -= recipeInputList.get((int)j).amount;
                }
                continue;
            }
            return baseMachineRecipe;
        }
        return null;
    }
}

