/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IMultiUpdateTick;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidTank;

public class InvSlotMultiRecipes
extends InvSlot {
    private final IMultiUpdateTick tile;
    private final ProcessMultiComponent processMultiComponent;
    public MachineRecipe recycler_output;
    private RecipeArrayList<IRecipeInputStack> accepts;
    private List<BaseMachineRecipe> recipe_list;
    private IBaseRecipe recipe;
    private FluidTank tank;

    public InvSlotMultiRecipes(TileEntityInventory base, IBaseRecipe baseRecipe, IMultiUpdateTick tile, int size, ProcessMultiComponent processMultiComponent) {
        super(base, InvSlot.TypeItemSlot.INPUT, size);
        this.recipe = baseRecipe;
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.tile = tile;
        this.tank = null;
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.recycler_output = new MachineRecipe(new BaseMachineRecipe(null, new RecipeOutput(null, IUItem.scrap)), Collections.singletonList(1));
        this.processMultiComponent = processMultiComponent;
    }

    public InvSlotMultiRecipes(TileEntityInventory base, String baseRecipe, IMultiUpdateTick tile, int size, ProcessMultiComponent processMultiComponent) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile, size, processMultiComponent);
    }

    public InvSlotMultiRecipes(TileEntityInventory base, String baseRecipe, IMultiUpdateTick tile, FluidTank tank, int size, ProcessMultiComponent processMultiComponent) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile, size, processMultiComponent);
        this.tank = tank;
    }

    public IBaseRecipe getRecipe() {
        return this.recipe;
    }

    public void load() {
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        if (this.recipe.getName().equals("recycler")) {
            this.recycler_output = new MachineRecipe(new BaseMachineRecipe(null, new RecipeOutput(null, IUItem.scrap)), Collections.singletonList(1));
        }
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        if (!this.recipe.getName().equals("recycler")) {
            this.tile.setRecipeOutput(this.process(index), index);
        } else {
            this.processMultiComponent.getOutput(index);
        }
        this.tile.onUpdate();
    }

    public BaseMachineRecipe consume(MachineRecipe recipe) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).func_190926_b()) continue;
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        this.contents.forEach(list::add);
        if (this.tank == null) {
            return Recipes.recipes.getRecipeConsume(this.recipe, recipe, this.recipe.consume(), list);
        }
        return Recipes.recipes.getRecipeOutputFluid(this.recipe.getName(), this.recipe.consume(), list, this.tank);
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.recipe.getName().equals("recycler") && !itemStack.func_190926_b()) {
            return true;
        }
        return !itemStack.func_190926_b() && !(itemStack.func_77973_b() instanceof IUpgradeItem) && (this.recipe.getName().equals("painter") || this.recipe.getName().equals("upgradeblock") || this.recipe.getName().equals("recycler") || (!this.recipe.getName().equals("furnace") ? this.accepts.contains(itemStack) : this.accepts.contains(new RecipeInputStack(itemStack))));
    }

    public void consume(int number, int amount) {
        this.consume(number, amount, false, false);
    }

    public void consume(int number, int amount, boolean simulate, boolean consumeContainers) {
        ItemStack stack = this.get(number);
        if (!stack.func_190926_b() && stack.func_190916_E() >= 1 && this.accepts(stack, number) && (stack.func_190916_E() >= 1 || consumeContainers || !stack.func_77973_b().hasContainerItem(stack))) {
            int currentAmount = Math.min(amount, stack.func_190916_E());
            if (!simulate) {
                if (stack.func_190916_E() == currentAmount) {
                    if (!consumeContainers && stack.func_77973_b().hasContainerItem(stack)) {
                        this.put(number, stack.func_77973_b().getContainerItem(stack));
                    } else {
                        this.put(number, null);
                    }
                } else {
                    stack.func_190920_e(stack.func_190916_E() - currentAmount);
                }
            }
        }
    }

    @Override
    public ItemStack get(int index) {
        return super.get(index);
    }

    public boolean continue_proccess(InvSlotOutput slot, int slotid) {
        if (this.tile.getRecipeOutput(slotid) == null) {
            return false;
        }
        if (!this.recipe.getName().equals("recycler")) {
            return slot.canAdd(this.tile.getRecipeOutput((int)slotid).getRecipe().output.items) && this.get(slotid).func_190916_E() >= this.tile.getRecipeOutput(slotid).getList().get(0);
        }
        return !this.get(slotid).func_190926_b() && slot.canAdd(this.tile.getRecipeOutput((int)slotid).getRecipe().output.items);
    }

    public MachineRecipe process(int slotid) {
        if (this.get(slotid).func_190926_b()) {
            return null;
        }
        return this.getOutputFor(slotid);
    }

    public MachineRecipe fastprocess(int slotid) {
        if (this.get(slotid).func_190926_b()) {
            return null;
        }
        MachineRecipe output = this.getOutputFor(slotid);
        return output;
    }

    public MachineRecipe consume(int slotid) {
        if (this.get(slotid).func_190926_b()) {
            if (this.fastprocess(slotid) == null) {
                return null;
            }
            throw new NullPointerException();
        }
        if (!this.recipe.getName().equals("recycler")) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(this.get(slotid));
            if (this.tank == null) {
                return Recipes.recipes.getMachineRecipeConsume(this.recipe, this.tile.getRecipeOutput(slotid), this.recipe.consume(), list);
            }
            return Recipes.recipes.getRecipeOutputMachineFluid(this.recipe.getName(), this.recipe.consume(), list, this.tank);
        }
        this.get(slotid).func_190918_g(1);
        return this.recycler_output;
    }

    private MachineRecipe getOutputFor(int slotid) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.get(slotid));
        if (this.tank == null) {
            return Recipes.recipes.getRecipeMachineMultiOutput(this.recipe, this.recipe_list, false, list);
        }
        return Recipes.recipes.getRecipeOutputMachineFluid(this.recipe.getName(), false, list, this.tank);
    }

    public void setNameRecipe(String nameRecipe) {
        this.recipe = Recipes.recipes.getRecipe(nameRecipe);
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
    }
}

