/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.componets.Fluids;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidHandlerRecipe {
    private final Fluids component;
    List<FluidTank> inputTank = new ArrayList<FluidTank>();
    List<FluidTank> outputTank = new ArrayList<FluidTank>();
    private BaseFluidMachineRecipe output;
    private IBaseRecipe name;
    private List<BaseFluidMachineRecipe> list_recipe;

    public FluidHandlerRecipe(String name, Fluids fluid_component) {
        this.component = fluid_component;
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(name);
        ArrayList list = new ArrayList();
        fluid_component.getAllTanks().forEach(list::add);
        for (Fluids.InternalFluidTank internalFluidTank : list) {
            if (internalFluidTank.canFill()) {
                this.inputTank.add(internalFluidTank);
                continue;
            }
            this.outputTank.add(internalFluidTank);
        }
        this.output = null;
    }

    public void load() {
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(this.name.getName());
        this.getOutput();
    }

    public void setName(String name) {
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.getOutput();
    }

    public Fluids getComponent() {
        return this.component;
    }

    public void consume() {
        for (int i = 0; i < this.name.getSize(); ++i) {
            this.inputTank.get(i).drain(this.output.input.getInputs().get(i), true);
        }
    }

    public BaseFluidMachineRecipe output() {
        return this.output;
    }

    public BaseFluidMachineRecipe getOutput() {
        if (this.output != null) {
            return this.output;
        }
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                return null;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
        return this.output;
    }

    public void checkOutput() {
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                if (this.output != null) {
                    this.output = null;
                }
                return;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
    }
}

