/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.LogicReactor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public class LogicComponent {
    private final IReactorItem item;
    private final ItemStack stack;
    private final IAdvReactor reactor;
    private int count;
    private List<LogicComponent> logicComponents;
    private final int x;
    private final int y;
    public int damage;
    double heat;

    public LogicComponent(IReactorItem item, int x, int y, ItemStack stack, IAdvReactor reactor) {
        this.item = item;
        this.x = x;
        this.y = y;
        this.logicComponents = new ArrayList<LogicComponent>(Collections.nCopies(4, LogicReactor.NULL));
        this.heat = item.getHeat(reactor);
        if (item.getType() == EnumTypeComponent.ROD) {
            this.damage = 1;
        }
        this.stack = stack;
        this.count = 0;
        this.reactor = reactor;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public List<LogicComponent> getLogicComponents() {
        return this.logicComponents;
    }

    public IReactorItem getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicComponent that = (LogicComponent)o;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public void updateAllInterface(List<LogicComponent> logicComponents, int width, int height, IAdvReactor reactor) {
        double temp_heat;
        LogicComponent cmp;
        if (this.x == -1 || this.y == -1) {
            return;
        }
        int i = -1;
        int k = 0;
        while (i <= 1) {
            if (this.x + i < 0 || this.x + i >= width) {
                ++this.count;
            } else {
                if (this.getItem().getType() == EnumTypeComponent.ROD) {
                    this.heat *= reactor.getMulHeatRod(this.x, this.y, this.stack);
                }
                if ((cmp = logicComponents.get(this.x + i + width * this.y)).getItem() != null && cmp.x != -1) {
                    this.logicComponents.set(k, cmp);
                    if (this.getItem().getType() == EnumTypeComponent.ROD && cmp.getItem().getType() == EnumTypeComponent.ROD) {
                        temp_heat = this.heat;
                        this.heat += cmp.heat / 4.0;
                        cmp.heat += temp_heat / 4.0;
                    }
                }
                if (cmp.equals(LogicReactor.NULL)) {
                    ++this.count;
                }
            }
            i += 2;
            ++k;
        }
        int j = -1;
        k = 2;
        while (j <= 1) {
            if (this.y + j < 0 || this.y + j >= height) {
                ++this.count;
            } else {
                cmp = logicComponents.get(this.x + width * (this.y + j));
                if (cmp.getItem() != null) {
                    this.logicComponents.set(k, cmp);
                    if (this.getItem().getType() == EnumTypeComponent.ROD && cmp.getItem().getType() == EnumTypeComponent.ROD) {
                        temp_heat = this.heat;
                        this.heat += cmp.heat / 4.0;
                        cmp.heat += temp_heat / 4.0;
                    }
                }
                if (cmp.equals(LogicReactor.NULL)) {
                    ++this.count;
                }
                if (this.getItem().getType() == EnumTypeComponent.ROD && this.count != 0) {
                    this.heat *= (double)(this.count + 1) * 1.5;
                }
            }
            j += 2;
            ++k;
        }
        this.logicComponents.removeIf(logicComponent -> logicComponent.x == -1);
    }

    public boolean canExtractHeat() {
        return this.getItem().caneExtractHeat();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean onTick() {
        if (this.getItem().getRepairOther(this.reactor) > 0) {
            for (LogicComponent component : this.logicComponents) {
                component.item.damageItem(component.getStack(), this.getItem().getRepairOther(this.reactor));
            }
        }
        if (this.damage != 0) {
            this.item.damageItem(this.stack, -1 * this.damage);
        }
        return this.item.needClear(this.getStack());
    }

    public double getHeat() {
        if (this.getItem().getType() == EnumTypeComponent.CAPACITOR || this.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
            return 0.0;
        }
        return this.heat;
    }
}

