/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.hadroncollider;

import com.denfop.api.hadroncollider.EnumLevelCollider;
import com.denfop.api.hadroncollider.IBatteryBlock;
import com.denfop.api.hadroncollider.IBlocksStabilizator;
import com.denfop.api.hadroncollider.IColliderBuilding;
import com.denfop.api.hadroncollider.IExtractBlock;
import com.denfop.api.hadroncollider.IMagnetBlock;
import com.denfop.api.hadroncollider.IMainController;
import com.denfop.api.hadroncollider.IOverclockingBlock;
import com.denfop.api.hadroncollider.IPurifierBlock;
import com.denfop.api.hadroncollider.IReceivedBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Structures {
    private final EnumLevelCollider level;
    private final Map<BlockPos, Class> map;
    private final BlockPos pos;

    public Structures(EnumLevelCollider levelCollider, BlockPos pos) {
        this.level = levelCollider;
        this.map = new HashMap<BlockPos, Class>();
        this.pos = pos;
        this.process();
    }

    public Structures(EnumLevelCollider levelCollider) {
        this.level = levelCollider;
        this.map = new HashMap<BlockPos, Class>();
        this.pos = BlockPos.field_177992_a;
        this.process();
    }

    public IMainController hasController(BlockPos pos, Class classes, World world) {
        for (Map.Entry<BlockPos, Class> entry : this.map.entrySet()) {
            if (entry.getValue() != classes) continue;
            BlockPos pos1 = entry.getKey();
            BlockPos pos2 = new BlockPos(pos.func_177958_n() - pos1.func_177958_n(), pos.func_177956_o() - pos1.func_177956_o(), pos.func_177952_p() - pos1.func_177952_p());
            if (!(world.func_175625_s(pos2) instanceof IMainController)) continue;
            return (IMainController)world.func_175625_s(pos2);
        }
        return null;
    }

    public boolean update(IMainController controller) {
        BlockPos pos = ((TileEntity)controller).func_174877_v();
        for (Map.Entry<BlockPos, Class> entry : this.map.entrySet()) {
            BlockPos pos1 = entry.getKey();
            BlockPos pos2 = pos.func_177971_a((Vec3i)pos1);
            if (((TileEntity)controller).func_145831_w().func_175625_s(pos2) == null) {
                return false;
            }
            if (((TileEntity)controller).func_145831_w().func_175625_s(pos2) instanceof IColliderBuilding) continue;
            return false;
        }
        return true;
    }

    private void process() {
        switch (this.level) {
            case ONE: {
                this.map.put(this.pos, IMainController.class);
                this.map.put(this.pos.func_177982_a(0, 0, 1), IPurifierBlock.class);
                this.map.put(this.pos.func_177982_a(1, 0, 1), IOverclockingBlock.class);
                this.map.put(this.pos.func_177982_a(1, 0, 0), IExtractBlock.class);
                break;
            }
            case TWO: {
                this.map.put(this.pos, IMainController.class);
                this.map.put(this.pos.func_177982_a(0, 0, -1), IReceivedBlock.class);
                this.map.put(this.pos.func_177982_a(0, 0, 1), IOverclockingBlock.class);
                this.map.put(this.pos.func_177982_a(1, 0, 2), IBlocksStabilizator.class);
                this.map.put(this.pos.func_177982_a(2, 0, 2), IBatteryBlock.class);
                this.map.put(this.pos.func_177982_a(3, 0, 2), IBlocksStabilizator.class);
                this.map.put(this.pos.func_177982_a(1, 0, -2), IBlocksStabilizator.class);
                this.map.put(this.pos.func_177982_a(2, 0, -2), IMagnetBlock.class);
                this.map.put(this.pos.func_177982_a(3, 0, -2), IBlocksStabilizator.class);
                this.map.put(this.pos.func_177982_a(4, 0, 0), IBlocksStabilizator.class);
                this.map.put(this.pos.func_177982_a(4, 0, -1), IExtractBlock.class);
                this.map.put(this.pos.func_177982_a(4, 0, 1), IBlocksStabilizator.class);
            }
        }
    }
}

