/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.GuiElementFluidToFluids;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.gui.GuiCore;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GuiElementMultiRecipe
extends GuiElement<GuiElementFluidToFluids> {
    private BaseMachineRecipe recipe;

    public GuiElementMultiRecipe(GuiCore<?> gui, int x, int y, int width, int height, EnumTypeMachines recipe, ItemStack stack) {
        super(gui, x, y, width, height);
        List<BaseMachineRecipe> recipes = Recipes.recipes.getRecipeList(recipe.recipe);
        block0: for (BaseMachineRecipe recipe1 : recipes) {
            for (ItemStack stack1 : recipe1.output.items) {
                if (!stack1.func_77969_a(stack)) continue;
                this.recipe = recipe1;
                continue block0;
            }
        }
    }

    public static GuiElementMultiRecipe GuiElementMultiRecipe(GuiCore<?> gui, int x, int y, EnumTypeMachines recipe, ItemStack stack) {
        return new GuiElementMultiRecipe(gui, x, y, 36, 75, recipe, stack);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        ItemStack stack1;
        int fluidX = this.x + 1 + 19;
        int fluidY = this.y + 1;
        if (mouseX >= fluidX && mouseX <= fluidX + 18 && mouseY >= fluidY && mouseY <= fluidY + 18 && !ModUtils.isEmpty(stack1 = this.recipe.input.getInputs().get(0).getInputs().get(0))) {
            this.gui.drawTooltip(mouseX, mouseY, stack1);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        GuiElementMultiRecipe.bindCommonTexture1();
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.recipe.input.getFluid();
        if (fs != null && fs.amount > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(fluid.getLocalizedName(fs));
                ret.add("Amount: " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                String state = fs.getFluid().isGaseous() ? "Gas" : "Liquid";
                ret.add("Type: " + state);
            } else {
                ret.add("Invalid FluidStack instance.");
            }
        } else {
            ret.add("No Fluid");
            ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
            ret.add("Type: Not Available");
        }
        return ret;
    }
}

