/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.api.Recipes;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.gui.GuiCore;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class DefaultRecipeElement
extends GuiElement<DefaultRecipeElement> {
    private final Supplier<ItemStack> itemSupplier;
    private int texY;
    private int texX;
    private List<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
    private int size = 0;
    private BaseMachineRecipe recipe;

    public DefaultRecipeElement(GuiCore<?> gui, int x, int y, Supplier<ItemStack> itemSupplier, String nameRecipe) {
        super(gui, x, y, 120, 20);
        this.itemSupplier = itemSupplier;
        List<BaseMachineRecipe> recipes = Recipes.recipes.getRecipeList(nameRecipe);
        block6: for (BaseMachineRecipe recipe : recipes) {
            for (ItemStack output_stack : recipe.output.items) {
                if (!((ItemStack)this.itemSupplier.get()).func_77969_a(output_stack)) continue;
                this.recipe = recipe;
                continue block6;
            }
        }
        if (this.recipe != null) {
            this.inputs = this.recipe.input.getInputs();
            this.size = this.inputs.size();
        }
        this.texX = 0;
        this.texY = 0;
        switch (this.size) {
            case 2: {
                this.texX = 1;
                this.texY = 146;
                break;
            }
            case 3: {
                this.texX = 1;
                this.texY = 168;
                break;
            }
            case 4: {
                this.texX = 1;
                this.texY = 190;
                break;
            }
            case 1: {
                this.texX = 1;
                this.texY = 212;
            }
        }
    }

    public DefaultRecipeElement(GuiCore<?> gui, int x, int y, Supplier<ItemStack> itemSupplier, String nameRecipe, boolean input) {
        super(gui, x, y, 120, 20);
        this.itemSupplier = itemSupplier;
        this.recipe = Recipes.recipes.getRecipeOutput(nameRecipe, false, (ItemStack)itemSupplier.get());
        if (this.recipe != null) {
            this.inputs = this.recipe.input.getInputs();
            this.size = this.inputs.size();
        }
        this.texX = 0;
        this.texY = 0;
        switch (this.size) {
            case 2: {
                this.texX = 1;
                this.texY = 146;
                break;
            }
            case 3: {
                this.texX = 1;
                this.texY = 168;
                break;
            }
            case 4: {
                this.texX = 1;
                this.texY = 190;
                break;
            }
            case 1: {
                this.texX = 1;
                this.texY = 212;
            }
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        ItemStack stack;
        int i;
        super.drawBackground(mouseX, mouseY);
        DefaultRecipeElement.bindCommonTexture1();
        this.getGui().func_73729_b(mouseX + this.x, mouseY + this.y, this.texX, this.texY, this.width, this.height);
        int x = 0;
        for (i = 0; i < this.size; ++i) {
            IInputItemStack ingredient = this.inputs.get(i);
            List<ItemStack> items = ingredient.getInputs();
            int perm = (int)(System.currentTimeMillis() / 1000L % (long)items.size());
            stack = items.get(perm);
            x = this.x + 1 + 19 * i;
            RenderHelper.func_74520_c();
            this.gui.drawItemStack(x, this.y + 1, stack);
            RenderHelper.func_74518_a();
        }
        x += 44;
        for (i = 0; i < this.recipe.output.items.size(); ++i) {
            stack = this.recipe.getOutput().items.get(i);
            if (ModUtils.isEmpty(stack)) continue;
            RenderHelper.func_74520_c();
            this.gui.drawItemStack(x += 19 * i, this.y + 1, stack);
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int i;
        ItemStack stack = (ItemStack)this.itemSupplier.get();
        int x = 0;
        for (i = 0; i < this.size; ++i) {
            IInputItemStack ingredient = this.inputs.get(i);
            List<ItemStack> items = ingredient.getInputs();
            int perm = (int)(System.currentTimeMillis() / 1000L % (long)items.size());
            stack = items.get(perm);
            x = this.x + 1 + 19 * i;
            if (mouseX < x || mouseX >= x + 19 || mouseY <= this.y + 1 || mouseY >= this.y + 20) continue;
            this.gui.drawTooltip(mouseX, mouseY, stack);
        }
        x += 44;
        for (i = 0; i < this.recipe.output.items.size(); ++i) {
            stack = this.recipe.getOutput().items.get(i);
            if (mouseX < (x += 19 * i) || mouseX >= x + 19 || mouseY <= this.y + 1 || mouseY >= this.y + 20) continue;
            this.gui.drawTooltip(mouseX, mouseY, stack);
        }
    }
}

